/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.CtrlChartPanel;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class SeriesChartPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private transient DataTable dataTable;
    private YIntervalSeriesCollection dataset = null;
    private boolean[] columns;
    private int[] axis = new int[]{-1, -1, -1};
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int INDEX = 2;
    private boolean plotBounds = false;
    private List<Integer> plotIndexToColumnIndexMap = new ArrayList<Integer>();
    private ChartPanel panel = new ChartPanel(null);

    public SeriesChartPlotter() {
        this.setBackground(Color.white);
    }

    public SeriesChartPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    private JFreeChart createChart(XYDataset dataset, boolean createLegend) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        if (this.plotBounds) {
            if (dataset.getSeriesCount() == 2) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f, 1, 1));
                renderer.setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
            } else {
                int i = 0;
                while (i < dataset.getSeriesCount() - 1) {
                    renderer.setSeriesStroke(i, (Stroke)new BasicStroke(1.5f, 1, 1));
                    renderer.setSeriesPaint(i, (Paint)this.getColorProvider().getPointColor((double)i / (double)(dataset.getSeriesCount() - 2)));
                    ++i;
                }
            }
            float[] dashArray = new float[]{7.0f, 14.0f};
            renderer.setSeriesStroke(dataset.getSeriesCount() - 1, (Stroke)new BasicStroke(1.5f, 1, 1, 1.0f, dashArray, 0.0f));
            renderer.setSeriesPaint(dataset.getSeriesCount() - 1, (Paint)Color.GRAY.brighter());
            renderer.setSeriesFillPaint(dataset.getSeriesCount() - 1, (Paint)Color.GRAY);
        } else if (dataset.getSeriesCount() == 1) {
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f, 1, 1));
            renderer.setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
        } else {
            int i = 0;
            while (i < dataset.getSeriesCount()) {
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(1.5f, 1, 1));
                renderer.setSeriesPaint(i, (Paint)this.getColorProvider().getPointColor((double)i / (double)(dataset.getSeriesCount() - 1)));
                ++i;
            }
        }
        renderer.setAlpha(0.25f);
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        if (this.axis[2] < 0) {
            xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits((Locale)Locale.US));
        }
        xAxis.setAutoRange(true);
        xAxis.setAutoRangeStickyZero(false);
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setLabelFont(LABEL_FONT_BOLD);
        xAxis.setTickLabelFont(LABEL_FONT);
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)Locale.US));
        yAxis.setAutoRange(true);
        yAxis.setAutoRangeStickyZero(false);
        yAxis.setAutoRangeIncludesZero(false);
        yAxis.setLabelFont(LABEL_FONT_BOLD);
        yAxis.setTickLabelFont(LABEL_FONT);
        return chart;
    }

    public Icon getIcon(int index) {
        return null;
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[dataTable.getNumberOfColumns()];
        this.updatePlotter();
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public void setPlotColumn(int index, boolean plot) {
        if (index >= 0 && index < this.columns.length) {
            this.columns[index] = plot;
        }
        this.updatePlotter();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public String getPlotName() {
        return "Plot Series";
    }

    public int getNumberOfAxes() {
        return this.axis.length;
    }

    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "Lower Bound";
            }
            case 1: {
                return "Upper Bound";
            }
            case 2: {
                return "Index Dimension";
            }
        }
        return "none";
    }

    public int getAxis(int index) {
        return this.axis[index];
    }

    public void setAxis(int index, int dimension) {
        if (this.axis[index] != dimension) {
            this.axis[index] = dimension;
            this.updatePlotter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareData() {
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            this.dataset = new YIntervalSeriesCollection();
            this.plotBounds = false;
            this.plotIndexToColumnIndexMap.clear();
            int columnCount = 0;
            int c = 0;
            while (c < this.dataTable.getNumberOfColumns()) {
                if (this.getPlotColumn(c) && this.dataTable.isNumerical(c)) {
                    YIntervalSeries series = new YIntervalSeries((Comparable)((Object)this.dataTable.getColumnName(c)));
                    Iterator<DataTableRow> i = this.dataTable.iterator();
                    int index = 1;
                    while (i.hasNext()) {
                        DataTableRow row = i.next();
                        double value = row.getValue(c);
                        if (this.axis[2] >= 0 && !this.dataTable.isNominal(this.axis[2])) {
                            double indexValue = row.getValue(this.axis[2]);
                            series.add(indexValue, value, value, value);
                            continue;
                        }
                        series.add((double)index++, value, value, value);
                    }
                    this.dataset.addSeries(series);
                    this.plotIndexToColumnIndexMap.add(c);
                    ++columnCount;
                }
                ++c;
            }
            if (this.getAxis(0) > -1 && this.getAxis(1) > -1 && this.dataTable.isNumerical(this.getAxis(0)) && this.dataTable.isNumerical(this.getAxis(1))) {
                YIntervalSeries series = new YIntervalSeries((Comparable)((Object)"Bounds"));
                Iterator<DataTableRow> i = this.dataTable.iterator();
                int index = 1;
                while (i.hasNext()) {
                    double upperValue;
                    DataTableRow row = i.next();
                    double lowerValue = row.getValue(this.getAxis(0));
                    if (lowerValue > (upperValue = row.getValue(this.getAxis(1)))) {
                        double dummy = lowerValue;
                        lowerValue = upperValue;
                        upperValue = dummy;
                    }
                    double mean = (upperValue - lowerValue) / 2.0 + lowerValue;
                    if (this.axis[2] >= 0 && !this.dataTable.isNominal(this.axis[2])) {
                        double indexValue = row.getValue(this.axis[2]);
                        series.add(indexValue, mean, lowerValue, upperValue);
                        continue;
                    }
                    series.add((double)index++, mean, lowerValue, upperValue);
                }
                this.dataset.addSeries(series);
                ++columnCount;
                this.plotBounds = true;
            }
            return columnCount;
        }
    }

    public JComponent getPlotter() {
        return this.panel;
    }

    private void updatePlotter() {
        LegendTitle legend;
        int categoryCount = this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.colors.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Series plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        boolean createLegend = categoryCount > 0 && categoryCount < maxClasses;
        JFreeChart chart = this.createChart((XYDataset)this.dataset, createLegend);
        chart.setBackgroundPaint((Paint)Color.white);
        if (this.axis[2] >= 0 && !this.dataTable.isNominal(this.axis[2]) && (this.dataTable.isDate(this.axis[2]) || this.dataTable.isDateTime(this.axis[2]))) {
            DateAxis domainAxis = new DateAxis(this.dataTable.getColumnName(this.axis[2]));
            domainAxis.setTimeZone(Tools.getPreferredTimeZone());
            chart.getXYPlot().setDomainAxis((ValueAxis)domainAxis);
        }
        if ((legend = chart.getLegend()) != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(LABEL_FONT);
        }
        if (this.panel instanceof CtrlChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new CtrlChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
        }
        this.panel.getChartRenderingInfo().setEntityCollection(null);
    }
}

