/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.MatrixPropertyTableModel;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.TableColumn;

public class MatrixPropertyTable
extends ExtendedJTable {
    private static final long serialVersionUID = 2348648114479673318L;
    private transient Operator operator;
    private MatrixPropertyTableModel model;
    private String rowBaseName;

    public MatrixPropertyTable(String baseName, String rowBaseName, String columnBaseName, double[][] parameterMatrix, Operator operator) {
        super(null, false, false);
        this.rowBaseName = rowBaseName;
        this.operator = operator;
        this.setCellColorProvider(new CellColorProvider(){

            public Color getCellColor(int row, int column) {
                if (column == 0) {
                    return SwingTools.LIGHTEST_BLUE;
                }
                return Color.WHITE;
            }
        });
        if (parameterMatrix != null) {
            int numberOfRows = parameterMatrix[0].length;
            int numberOfColumns = parameterMatrix.length;
            this.model = new MatrixPropertyTableModel(baseName, columnBaseName, numberOfRows, numberOfColumns + 1);
            this.setModel(this.model);
            int i = 0;
            while (i < numberOfColumns) {
                this.getModel().setValueAt(String.valueOf(rowBaseName) + " " + (i + 1), i, 0);
                int j = 0;
                while (j < numberOfRows) {
                    this.getModel().setValueAt(Double.toString(parameterMatrix[i][j]), i, j + 1);
                    ++j;
                }
                ++i;
            }
        } else {
            this.model = new MatrixPropertyTableModel(baseName, columnBaseName, 0, 0);
            this.setModel(this.model);
        }
    }

    public void addRow() {
        if (this.model.getColumnCount() == 0) {
            this.addColumn();
        }
        this.model.addRow(new Object[this.model.getColumnCount()]);
        int currentRow = this.model.getRowCount() - 1;
        this.model.setValueAt(String.valueOf(this.rowBaseName) + " " + (currentRow + 1), currentRow, 0);
    }

    public void addColumn() {
        this.model.addColumn((Object)this.model.getColumnCount(), new Object[this.model.getRowCount()]);
    }

    public void removeSelectedRow() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length < this.model.getRowCount()) {
            int i = selectedRows.length - 1;
            while (i >= 0) {
                this.model.removeRow(selectedRows[i]);
                --i;
            }
            this.model.fireTableStructureChanged();
        }
    }

    public void removeSelectedColumn() {
        int[] selectedColumns = this.getSelectedColumns();
        if (selectedColumns.length < this.model.getColumnCount() - 1) {
            int i = selectedColumns.length - 1;
            while (i >= 0) {
                this.removeColumn(selectedColumns[i]);
                --i;
            }
            this.model.fireTableStructureChanged();
        }
    }

    public void removeSelectedRowAndColumn() {
        if (this.model.getRowCount() > 1) {
            this.model.removeRow(this.model.getRowCount() - 1);
            this.removeColumn(this.model.getColumnCount() - 1);
            this.model.fireTableStructureChanged();
        }
    }

    public void fillNewRowAndColumn() {
        int currentRow = this.model.getRowCount() - 1;
        int currentColumn = this.model.getColumnCount() - 1;
        this.model.setValueAt("1.0", 0, currentColumn);
        int i = 1;
        while (i < currentColumn) {
            this.model.setValueAt("1.0", currentRow, i);
            this.model.setValueAt("1.0", i, currentColumn);
            ++i;
        }
        this.model.setValueAt("0.0", currentRow, currentColumn);
    }

    public double[][] getParameterMatrix() {
        double[][] matrix = new double[this.getModel().getRowCount()][this.getModel().getColumnCount() - 1];
        int i = 0;
        while (i < this.getModel().getRowCount()) {
            int j = 0;
            while (j < this.getModel().getColumnCount() - 1) {
                matrix[i][j] = Double.parseDouble((String)this.getModel().getValueAt(i, j + 1));
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public Operator getOperator(int row) {
        return this.operator;
    }

    public void removeColumn(int index) {
        TableColumn column = this.getColumnModel().getColumn(index);
        int modelIndex = column.getModelIndex();
        Vector<Vector> modelData = this.model.getDataVector();
        Vector columnIdentifiers = this.model.getColumnIdentifiers();
        this.removeColumn(column);
        columnIdentifiers.removeElementAt(modelIndex);
        int i = 0;
        while (i < modelData.size()) {
            Vector row = modelData.get(i);
            row.removeElementAt(modelIndex);
            ++i;
        }
        this.model.setDataVector(modelData, columnIdentifiers);
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn currentColumn = columns.nextElement();
            if (currentColumn.getModelIndex() < modelIndex) continue;
            currentColumn.setModelIndex(currentColumn.getModelIndex() - 1);
        }
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }
}

