/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.SOMDimensionalityReductionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.math.som.KohonenNet;
import com.rapidminer.tools.math.som.RandomDataContainer;
import com.rapidminer.tools.math.som.RitterAdaptation;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOMDimensionalityReduction
extends Operator {
    public static final String PARAMETER_NUMBER_OF_DIMENSIONS = "number_of_dimensions";
    public static final String PARAMETER_NET_SIZE = "net_size";
    public static final String PARAMETER_TRAINING_ROUNDS = "training_rounds";
    public static final String PARAMETER_LEARNING_RATE_START = "learning_rate_start";
    public static final String PARAMETER_LEARNING_RATE_END = "learning_rate_end";
    public static final String PARAMETER_ADAPTION_RADIUS_START = "adaption_radius_start";
    public static final String PARAMETER_ADAPTION_RADIUS_END = "adaption_radius_end";

    public SOMDimensionalityReduction(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int trainingRounds = this.getParameterAsInt(PARAMETER_TRAINING_ROUNDS);
        int netSize = this.getParameterAsInt(PARAMETER_NET_SIZE);
        int dimensions = this.getParameterAsInt(PARAMETER_NUMBER_OF_DIMENSIONS);
        double learningRateStart = this.getParameterAsDouble(PARAMETER_LEARNING_RATE_START);
        double learningRateEnd = this.getParameterAsDouble(PARAMETER_LEARNING_RATE_END);
        double adaptionRadiusStart = this.getParameterAsDouble(PARAMETER_ADAPTION_RADIUS_START);
        double adaptionRadiusEnd = this.getParameterAsDouble(PARAMETER_ADAPTION_RADIUS_END);
        if (learningRateStart < learningRateEnd) {
            throw new UserError((Operator)this, 116, PARAMETER_LEARNING_RATE_START, "Learning rate at first round must be greater than in last round: (" + learningRateEnd + ")");
        }
        if (adaptionRadiusStart < adaptionRadiusEnd) {
            throw new UserError((Operator)this, 116, PARAMETER_ADAPTION_RADIUS_START, "Adaption radius at first round must be greater than in last round: (" + adaptionRadiusEnd + ")");
        }
        KohonenNet net = this.prepareSOM(exampleSet, dimensions, netSize, trainingRounds, learningRateStart, learningRateEnd, adaptionRadiusStart, adaptionRadiusEnd);
        SOMDimensionalityReductionModel model = new SOMDimensionalityReductionModel(exampleSet, net, dimensions);
        ExampleSet newExampleSet = model.apply(exampleSet);
        if (this.getParameterAsBoolean("return_preprocessing_model")) {
            return new IOObject[]{newExampleSet, model};
        }
        return new IOObject[]{newExampleSet};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KohonenNet prepareSOM(ExampleSet exampleSet, int netDimensions, int netSize, int trainingRounds, double learningRateStart, double learningRateEnd, double adaptionRadiusStart, double adaptionRadiusEnd) {
        int dataDimension;
        RandomDataContainer data = new RandomDataContainer();
        ExampleSet exampleSet2 = exampleSet;
        synchronized (exampleSet2) {
            Iterator iterator = exampleSet.iterator();
            dataDimension = exampleSet.getAttributes().size();
            while (iterator.hasNext()) {
                data.addData(SOMDimensionalityReduction.getDoubleArrayFromExample((Example)iterator.next()));
            }
        }
        KohonenNet net = new KohonenNet(data);
        RitterAdaptation adaptionFunction = new RitterAdaptation();
        adaptionFunction.setAdaptationRadiusStart(adaptionRadiusStart);
        adaptionFunction.setAdaptationRadiusEnd(adaptionRadiusEnd);
        adaptionFunction.setLearnRateStart(learningRateStart);
        adaptionFunction.setLearnRateEnd(learningRateEnd);
        net.setAdaptationFunction(adaptionFunction);
        int[] dimensions = new int[netDimensions];
        int i = 0;
        while (i < netDimensions) {
            dimensions[i] = netSize;
            ++i;
        }
        net.init(dataDimension, dimensions, false);
        net.setTrainingRounds(trainingRounds);
        net.train();
        return net;
    }

    public static double[] getDoubleArrayFromExample(Example example) {
        double[] doubleRow = new double[example.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            doubleRow[i++] = example.getValue(attribute);
        }
        return doubleRow;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("return_preprocessing_model", "Indicates if the preprocessing model should also be returned", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_DIMENSIONS, "Defines the number of dimensions, the data shall be reduced.", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NET_SIZE, "Defines the size of the SOM net, by setting the length of every edge of the net.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_TRAINING_ROUNDS, "Defines the number of trainnig rounds", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_LEARNING_RATE_START, "Defines the strength of an adaption in the first round. The strength will decrease every round until it reaches the learning_rate_end in the last round.", 0.0, Double.POSITIVE_INFINITY, 0.8));
        types.add(new ParameterTypeDouble(PARAMETER_LEARNING_RATE_END, "Defines the strength of an adaption in the last round. The strength will decrease to this value in last round, beginning with learning_rate_start in the first round.", 0.0, Double.POSITIVE_INFINITY, 0.01));
        types.add(new ParameterTypeDouble(PARAMETER_ADAPTION_RADIUS_START, "Defines the radius of the sphere around an stimulus, within an adaption occoures. This radius decreases every round, starting by adaption_radius_start in first round, to adaption_radius_end in last round.", 0.0, Double.POSITIVE_INFINITY, 10.0));
        types.add(new ParameterTypeDouble(PARAMETER_ADAPTION_RADIUS_END, "Defines the radius of the sphere around an stimulus, within an adaption occoures. This radius decreases every round, starting by adaption_radius_start in first round, to adaption_radius_end in last round.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

