/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import java.awt.Component;

public class RelativeRegressionModel
extends PredictionModel {
    private static final long serialVersionUID = -8474869399613666453L;
    private String relativeAttributeName;
    private Model baseModel;

    protected RelativeRegressionModel(ExampleSet trainingExampleSet, Model baseModel, String relativeAttributeName) {
        super(trainingExampleSet);
        this.baseModel = baseModel;
        this.relativeAttributeName = relativeAttributeName;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        ExampleSet resultSet = this.baseModel.apply(exampleSet);
        Attribute relativeAttribute = resultSet.getAttributes().get(this.relativeAttributeName);
        Attribute predLabel = resultSet.getAttributes().getPredictedLabel();
        if (relativeAttribute == null) {
            throw new UserError(null, 111, this.relativeAttributeName);
        }
        if (predLabel == null) {
            throw new UserError(null, 107);
        }
        for (Example e : resultSet) {
            double relativeValue = e.getValue(relativeAttribute);
            double predictedValue = e.getValue(predLabel);
            e.setValue(predLabel, relativeValue + predictedValue);
        }
        return resultSet;
    }

    public String getName() {
        return "Relative Model for " + this.baseModel.getName();
    }

    public Component getVisualizationComponent(IOContainer container) {
        return this.baseModel.getVisualizationComponent(container);
    }
}

