/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.condition.FirstInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.preprocessing.MaterializeDataInMemory;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProcessing
extends OperatorChain {
    public static final String PARAMETER_BATCH_SIZE = "batch_size";

    public BatchProcessing(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        MaterializeDataInMemory materialization = null;
        try {
            materialization = OperatorService.createOperator(MaterializeDataInMemory.class);
        }
        catch (OperatorCreationException e) {
            throw new OperatorException("Cannot create materialization: " + e);
        }
        if (materialization != null) {
            int batchSize = this.getParameterAsInt(PARAMETER_BATCH_SIZE);
            int size = exampleSet.size();
            int currentStart = 0;
            while (currentStart < size) {
                ExampleSet materializedSet = Tools.getLinearSubsetCopy(exampleSet, batchSize, currentStart);
                IOContainer innerInput = new IOContainer(materializedSet);
                int o = 0;
                while (o < this.getNumberOfOperators()) {
                    innerInput = this.getOperator(o).apply(innerInput);
                    ++o;
                }
                currentStart += batchSize;
            }
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new FirstInnerOperatorCondition(new Class[]{ExampleSet.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_BATCH_SIZE, "This number of examples is processed batch-wise by the inner operators of this operator.", 1, Integer.MAX_VALUE, 1000));
        return types;
    }
}

