/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.text;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.FirstInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.text.TextObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSegmenter
extends OperatorChain {
    private static final String PARAMETER_START_REGEX = "start_regex";
    private static final String PARAMETER_END_REGEX = "end_regex";

    public TextSegmenter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        TextObject text = this.getInput(TextObject.class);
        IOContainer input = this.getInput();
        Pattern startPattern = Pattern.compile(this.getParameterAsString(PARAMETER_START_REGEX));
        Pattern endPattern = Pattern.compile(this.getParameterAsString(PARAMETER_END_REGEX));
        Matcher startMatcher = startPattern.matcher(text.getText());
        Matcher endMatcher = endPattern.matcher(text.getText());
        int start = 0;
        while (startMatcher.find(start)) {
            if (!endMatcher.find(startMatcher.end())) break;
            TextObject segment = new TextObject(text.getText().substring(startMatcher.start(), endMatcher.end()));
            Iterator<Operator> childIterator = super.getOperators();
            IOContainer childInput = input.append(segment);
            while (childIterator.hasNext()) {
                try {
                    childInput = childIterator.next().apply(childInput);
                }
                catch (ConcurrentModificationException e) {
                    if (this.isDebugMode()) {
                        e.printStackTrace();
                    }
                    throw new UserError(this, 923);
                }
            }
            start = endMatcher.end();
        }
        return input.getIOObjects();
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new FirstInnerOperatorCondition(new Class[]{TextObject.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameters = super.getParameterTypes();
        parameters.add(new ParameterTypeString(PARAMETER_START_REGEX, "This regular expression specifies the start of segments."));
        parameters.add(new ParameterTypeString(PARAMETER_END_REGEX, "This regular expression specifies the end of segments."));
        return parameters;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{TextObject.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }
}

