/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.clustering.exampledistribution;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.clustering.exampledistribution.ExampleDistributionMeasure;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.ClassNameMapper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleDistributionEvaluator
extends Operator {
    public static final String PARAMETER_MEASURE = "measure";
    private static final String[] DEFAULT_MEASURES = new String[]{"com.rapidminer.operator.validation.clustering.exampledistribution.SumOfSquares", "com.rapidminer.operator.validation.clustering.exampledistribution.GiniCoefficient"};
    private ClassNameMapper MEASURE_MAP;
    private double distribution = 0.0;

    public ExampleDistributionEvaluator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("item_distribution", "The distribution of items over clusters.", false){

            public double getDoubleValue() {
                return ExampleDistributionEvaluator.this.distribution;
            }
        });
    }

    public InputDescription getInputDescription(Class cls) {
        if (ClusterModel.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ClusterModel model = this.getInput(ClusterModel.class);
        ExampleDistributionMeasure measure = (ExampleDistributionMeasure)this.MEASURE_MAP.getInstantiation(this.getParameterAsString(PARAMETER_MEASURE));
        int totalNumberOfItems = 0;
        int[] count = new int[model.getNumberOfClusters()];
        int i = 0;
        while (i < model.getNumberOfClusters()) {
            int numItemsInCluster = model.getCluster(i).getNumberOfExamples();
            totalNumberOfItems += numItemsInCluster;
            count[i] = numItemsInCluster;
            ++i;
        }
        PerformanceVector performance = null;
        try {
            performance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException e) {
            performance = new PerformanceVector();
        }
        this.distribution = measure.evaluate(count, totalNumberOfItems);
        EstimatedPerformance criterion = new EstimatedPerformance("Example distribution", this.distribution, 1, false);
        performance.addCriterion(criterion);
        return new IOObject[]{performance};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ClusterModel.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        this.MEASURE_MAP = new ClassNameMapper(DEFAULT_MEASURES);
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeStringCategory type = new ParameterTypeStringCategory(PARAMETER_MEASURE, "the item distribution measure to apply", this.MEASURE_MAP.getShortClassNames());
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

