/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionMatrixOperator
extends Operator {
    public static final String PARAMETER_ATTRIBUTE = "attribute";

    public TransitionMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE));
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 119, attribute.getName(), "TransitionMatrix");
        }
        TreeSet<String> values = new TreeSet<String>();
        HashMap<Tupel<String, String>, Integer> transitions = new HashMap<Tupel<String, String>, Integer>();
        int numberOfTransitions = exampleSet.size() - 1;
        String lastValue = null;
        for (Example example : exampleSet) {
            String currentValue = example.getNominalValue(attribute);
            values.add(currentValue);
            if (lastValue != null) {
                Tupel<String, String> currentTupel = new Tupel<String, String>(lastValue, currentValue);
                if (transitions.containsKey(currentTupel)) {
                    transitions.put(currentTupel, (Integer)transitions.get(currentTupel) + 1);
                } else {
                    transitions.put(currentTupel, 1);
                }
            }
            lastValue = currentValue;
        }
        String[] valueArray = values.toArray(new String[0]);
        HashMap<String, Integer> valuePositions = new HashMap<String, Integer>();
        int i = 0;
        String[] stringArray = valueArray;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            valuePositions.put(value, i);
            ++i;
            ++n2;
        }
        NumericalMatrix matrix = new NumericalMatrix("Transition", valueArray, false);
        for (Map.Entry entry : transitions.entrySet()) {
            matrix.setValue((Integer)valuePositions.get(((Tupel)entry.getKey()).getFirst()), (Integer)valuePositions.get(((Tupel)entry.getKey()).getSecond()), (double)((Integer)entry.getValue()).intValue() / (double)numberOfTransitions);
        }
        return new IOObject[]{exampleSet, matrix};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE, "Specifies the nominal attribute."));
        return types;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, NumericalMatrix.class};
    }
}

