/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import java.util.Arrays;

class SimpleMatrix {
    SimpleMatrix() {
    }

    static double[][] matrix(int r, int c) {
        if (r <= 0 || c <= 0) {
            throw new IllegalArgumentException();
        }
        return new double[r][c];
    }

    static double[][] matrix(int s) {
        return SimpleMatrix.matrix(s, s);
    }

    static double[][] matrix(int s, double v) {
        return SimpleMatrix.matrix(s, s, v);
    }

    static double[][] matrix(int r, int c, double v) {
        double[][] m = SimpleMatrix.matrix(r, c);
        while (r > 0) {
            Arrays.fill(m[--r], v);
        }
        return m;
    }

    static double[][] matrix(double[][] m) {
        double[][] mc = SimpleMatrix.matrix(SimpleMatrix.nbRows(m), SimpleMatrix.nbColumns(m));
        int r = 0;
        while (r < SimpleMatrix.nbRows(m)) {
            int c = 0;
            while (c < SimpleMatrix.nbColumns(m)) {
                mc[r][c] = m[r][c];
                ++c;
            }
            ++r;
        }
        return mc;
    }

    static double[][] matrix(double[] v) {
        double[][] m = SimpleMatrix.matrix(SimpleMatrix.dimension(v), 1);
        int r = 0;
        while (r < SimpleMatrix.dimension(v)) {
            m[r][0] = v[r];
            ++r;
        }
        return m;
    }

    static double[] vector(int dimension) {
        return new double[dimension];
    }

    static double[] vector(double[] v) {
        double[] vc = (double[])v.clone();
        return vc;
    }

    static double[][] matrixIdentity(int s) {
        double[][] m = SimpleMatrix.matrix(s, s);
        int i = 0;
        while (i < s) {
            m[i][i] = 1.0;
            ++i;
        }
        return m;
    }

    static int nbRows(double[][] m) {
        return m.length;
    }

    static int nbColumns(double[][] m) {
        return m[0].length;
    }

    static int dimension(double[] v) {
        return v.length;
    }

    static boolean isSquare(double[][] m) {
        return SimpleMatrix.nbRows(m) == SimpleMatrix.nbColumns(m);
    }

    static double[][] transpose(double[][] m) {
        double[][] t = SimpleMatrix.matrix(SimpleMatrix.nbColumns(m), SimpleMatrix.nbRows(m));
        int r = 0;
        while (r < SimpleMatrix.nbRows(m)) {
            int c = 0;
            while (c < SimpleMatrix.nbColumns(m)) {
                t[c][r] = m[r][c];
                ++c;
            }
            ++r;
        }
        return t;
    }

    static double[][] plus(double[][] m1, double[][] m2) {
        if (SimpleMatrix.nbRows(m1) != SimpleMatrix.nbRows(m2) || SimpleMatrix.nbColumns(m1) != SimpleMatrix.nbColumns(m2)) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        double[][] s = SimpleMatrix.matrix(m1);
        int r = 0;
        while (r < SimpleMatrix.nbRows(s)) {
            int c = 0;
            while (c < SimpleMatrix.nbColumns(s)) {
                double[] dArray = s[r];
                int n = c;
                dArray[n] = dArray[n] + m2[r][c];
                ++c;
            }
            ++r;
        }
        return s;
    }

    static double[] plus(double[] v1, double[] v2) {
        if (SimpleMatrix.dimension(v1) != SimpleMatrix.dimension(v2)) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
        double[] s = SimpleMatrix.vector(v1);
        int i = 0;
        while (i < SimpleMatrix.dimension(v1)) {
            int n = i;
            s[n] = s[n] + v2[i];
            ++i;
        }
        return s;
    }

    static double[] minus(double[] v1, double[] v2) {
        if (SimpleMatrix.dimension(v1) != SimpleMatrix.dimension(v2)) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
        double[] s = SimpleMatrix.vector(v1);
        int i = 0;
        while (i < SimpleMatrix.dimension(v1)) {
            int n = i;
            s[n] = s[n] - v2[i];
            ++i;
        }
        return s;
    }

    static double[][] times(double[][] m1, double[][] m2) {
        if (SimpleMatrix.nbRows(m2) != SimpleMatrix.nbColumns(m1)) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        double[][] p = SimpleMatrix.matrix(SimpleMatrix.nbRows(m1), SimpleMatrix.nbRows(m2));
        int r = 0;
        while (r < SimpleMatrix.nbRows(m1)) {
            int c = 0;
            while (c < SimpleMatrix.nbColumns(m2)) {
                int i = 0;
                while (i < SimpleMatrix.nbColumns(m1)) {
                    double[] dArray = p[r];
                    int n = c;
                    dArray[n] = dArray[n] + m1[r][i] * m2[i][c];
                    ++i;
                }
                ++c;
            }
            ++r;
        }
        return p;
    }

    static double[] times(double[][] m, double[] v) {
        if (SimpleMatrix.dimension(v) != SimpleMatrix.nbColumns(m)) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        double[] p = SimpleMatrix.vector(SimpleMatrix.nbRows(m));
        int r = 0;
        while (r < SimpleMatrix.nbRows(m)) {
            int i = 0;
            while (i < SimpleMatrix.nbColumns(m)) {
                int n = r;
                p[n] = p[n] + m[r][i] * v[i];
                ++i;
            }
            ++r;
        }
        return p;
    }

    static double[][] decomposeCholesky(double[][] m) {
        if (!SimpleMatrix.isSquare(m)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double[][] l = SimpleMatrix.matrix(SimpleMatrix.nbRows(m), SimpleMatrix.nbColumns(m));
        int j = 0;
        while (j < SimpleMatrix.nbRows(m)) {
            double d;
            double[] lj = l[j];
            double d2 = 0.0;
            int k = 0;
            while (k < j) {
                double[] lk = l[k];
                double s = 0.0;
                int i = 0;
                while (i < k) {
                    s += lk[i] * lj[i];
                    ++i;
                }
                lj[k] = s = (m[j][k] - s) / l[k][k];
                d2 += s * s;
                ++k;
            }
            d2 = m[j][j] - d2;
            if (d <= 0.0) {
                throw new IllegalArgumentException("Matrix is not positive defined");
            }
            l[j][j] = Math.sqrt(d2);
            k = j + 1;
            while (k < SimpleMatrix.nbRows(m)) {
                l[j][k] = 0.0;
                ++k;
            }
            ++j;
        }
        return l;
    }

    static double determinantCholesky(double[][] l) {
        if (!SimpleMatrix.isSquare(l)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double d = 1.0;
        int i = 0;
        while (i < SimpleMatrix.nbRows(l)) {
            d *= l[i][i];
            ++i;
        }
        return d * d;
    }

    static double[][] inverseCholesky(double[][] l) {
        if (!SimpleMatrix.isSquare(l)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double[][] li = SimpleMatrix.lowerTriangularInverse(l);
        double[][] ic = SimpleMatrix.matrix(SimpleMatrix.nbRows(l));
        int r = 0;
        while (r < SimpleMatrix.nbRows(l)) {
            int c = 0;
            while (c < SimpleMatrix.nbRows(l)) {
                int i = 0;
                while (i < SimpleMatrix.nbRows(l)) {
                    double[] dArray = ic[r];
                    int n = c;
                    dArray[n] = dArray[n] + li[i][r] * li[i][c];
                    ++i;
                }
                ++c;
            }
            ++r;
        }
        return ic;
    }

    static double[][] lowerTriangularInverse(double[][] m) {
        if (!SimpleMatrix.isSquare(m)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double[][] lti = SimpleMatrix.matrix(SimpleMatrix.nbRows(m));
        int j = 0;
        while (j < SimpleMatrix.nbRows(m)) {
            if (m[j][j] == 0.0) {
                throw new IllegalArgumentException("Matrix is not full rank");
            }
            lti[j][j] = 1.0 / m[j][j];
            int i = j + 1;
            while (i < SimpleMatrix.nbRows(m)) {
                double sum = 0.0;
                int k = j;
                while (k < i) {
                    sum -= m[i][k] * lti[k][j];
                    ++k;
                }
                lti[i][j] = sum / m[i][i];
                ++i;
            }
            ++j;
        }
        return lti;
    }

    static String toString(double[][] m) {
        String s = "[";
        int r = 0;
        while (r < SimpleMatrix.nbRows(m)) {
            s = String.valueOf(s) + "[";
            int c = 0;
            while (c < SimpleMatrix.nbColumns(m)) {
                s = String.valueOf(s) + " " + m[r][c];
                ++c;
            }
            s = String.valueOf(s) + " ]\n";
            ++r;
        }
        return String.valueOf(s) + " ]\n";
    }

    static String toString(double[] v) {
        String s = "[";
        int r = 0;
        while (r < SimpleMatrix.dimension(v)) {
            s = String.valueOf(s) + " " + v[r];
            ++r;
        }
        return String.valueOf(s) + " ]\n";
    }
}

