/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.extraction;

import com.rapidminer.operator.UserError;

public class ExtractionException
extends Exception {
    private static final long serialVersionUID = 3040027053737902154L;
    private final Exception originalException;
    private final UserError error;

    public ExtractionException(Exception originalException) {
        this("Could not extract information from document", originalException, null);
    }

    public ExtractionException(String message, Exception originalException) {
        this(message, originalException, null);
    }

    public ExtractionException(String message, Exception originalException, UserError error) {
        super(message);
        this.originalException = originalException;
        this.error = error;
        if (error == null) {
            error = new UserError(null, 306, new Object[]{"WVTool", originalException});
        }
    }

    public UserError getUserError() {
        return this.error;
    }

    public String toString() {
        if (this.originalException != null) {
            return String.valueOf(super.toString()) + "\nOriginal Exception:\n" + this.originalException;
        }
        return this.toString();
    }
}

