/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.io.IOException;
import marytts.util.io.MaryRandomAccessFile;

public class GMMTrainerParams {
    public static final int EM_TOTAL_COMPONENTS_DEFAULT = 1;
    public static final boolean EM_IS_DIAGONAL_COVARIANCE_DEFAULT = true;
    public static final int EM_MIN_ITERATIONS_DEFAULT = 500;
    public static final int EM_MAX_ITERATIONS_DEFAULT = 2000;
    public static final boolean EM_IS_UPDATE_COVARIANCES_DEFAULT = true;
    public static final double EM_TINY_LOGLIKELIHOOD_CHANGE_PERCENT_DEFAULT = 1.0E-4;
    public static final double EM_MIN_COVARIANCE_ALLOWED_DEFAULT = 1.0E-4;
    public static final boolean EM_USE_NATIVE_C_LIB_TRAINER_DEFAULT = false;
    public int totalComponents;
    public boolean isDiagonalCovariance;
    public int kmeansMaxIterations;
    public double kmeansMinClusterChangePercent;
    public int kmeansMinSamplesInOneCluster;
    public int emMinIterations;
    public int emMaxIterations;
    public boolean isUpdateCovariances;
    public double tinyLogLikelihoodChangePercent;
    public double minCovarianceAllowed;
    public boolean useNativeCLibTrainer;

    public GMMTrainerParams() {
        this.totalComponents = 1;
        this.isDiagonalCovariance = true;
        this.kmeansMaxIterations = 200;
        this.kmeansMinClusterChangePercent = 1.0E-4;
        this.kmeansMinSamplesInOneCluster = 10;
        this.emMinIterations = 500;
        this.emMaxIterations = 2000;
        this.isUpdateCovariances = true;
        this.tinyLogLikelihoodChangePercent = 1.0E-4;
        this.minCovarianceAllowed = 1.0E-4;
        this.useNativeCLibTrainer = false;
    }

    public GMMTrainerParams(GMMTrainerParams existing) {
        this.totalComponents = existing.totalComponents;
        this.isDiagonalCovariance = existing.isDiagonalCovariance;
        this.kmeansMaxIterations = existing.kmeansMaxIterations;
        this.kmeansMinClusterChangePercent = existing.kmeansMinClusterChangePercent;
        this.kmeansMinSamplesInOneCluster = existing.kmeansMinSamplesInOneCluster;
        this.emMinIterations = existing.emMinIterations;
        this.emMaxIterations = existing.emMaxIterations;
        this.isUpdateCovariances = existing.isUpdateCovariances;
        this.tinyLogLikelihoodChangePercent = existing.tinyLogLikelihoodChangePercent;
        this.minCovarianceAllowed = existing.minCovarianceAllowed;
        this.useNativeCLibTrainer = existing.useNativeCLibTrainer;
    }

    public GMMTrainerParams(MaryRandomAccessFile stream) {
        this.read(stream);
    }

    public void write(MaryRandomAccessFile stream) {
        if (stream != null) {
            try {
                stream.writeInt(this.totalComponents);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeBoolean(this.isDiagonalCovariance);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeInt(this.kmeansMaxIterations);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeDouble(this.kmeansMinClusterChangePercent);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeInt(this.kmeansMinSamplesInOneCluster);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeInt(this.emMinIterations);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeInt(this.emMaxIterations);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeBoolean(this.isUpdateCovariances);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeDouble(this.tinyLogLikelihoodChangePercent);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeDouble(this.minCovarianceAllowed);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stream.writeBoolean(this.useNativeCLibTrainer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void read(MaryRandomAccessFile stream) {
        if (stream != null) {
            try {
                this.totalComponents = stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.isDiagonalCovariance = stream.readBoolean();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.kmeansMaxIterations = stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.kmeansMinClusterChangePercent = stream.readDouble();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.kmeansMinSamplesInOneCluster = stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.emMinIterations = stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.emMaxIterations = stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.isUpdateCovariances = stream.readBoolean();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.tinyLogLikelihoodChangePercent = stream.readDouble();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.minCovarianceAllowed = stream.readDouble();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.useNativeCLibTrainer = stream.readBoolean();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

