/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.StringTokenizer;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.UnidataObsDatasetHelper;
import ucar.nc2.dt.trajectory.SingleTrajectoryObsDataset;
import ucar.nc2.util.CancelTask;

public class UnidataTrajectoryObsDataset
extends SingleTrajectoryObsDataset
implements TypedDatasetFactoryIF {
    private String timeDimName;
    private String timeVarName;
    private String latVarName;
    private String lonVarName;
    private String elevVarName;

    public static boolean isValidFile(NetcdfFile ds) {
        Attribute cdmDtAtt = ds.findGlobalAttributeIgnoreCase("cdm_data_type");
        if (cdmDtAtt == null) {
            cdmDtAtt = ds.findGlobalAttributeIgnoreCase("cdm_datatype");
        }
        if (cdmDtAtt == null) {
            return false;
        }
        if (!cdmDtAtt.isString()) {
            return false;
        }
        String cdmDtString = cdmDtAtt.getStringValue();
        if (cdmDtString == null) {
            return false;
        }
        if (!cdmDtString.equalsIgnoreCase(FeatureType.TRAJECTORY.toString())) {
            return false;
        }
        Attribute conventionsAtt = ds.findGlobalAttributeIgnoreCase("Conventions");
        if (conventionsAtt == null) {
            return false;
        }
        if (!conventionsAtt.isString()) {
            return false;
        }
        String convString = conventionsAtt.getStringValue();
        StringTokenizer stoke = new StringTokenizer(convString, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Observation Dataset v1.0")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return UnidataTrajectoryObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new UnidataTrajectoryObsDataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.TRAJECTORY;
    }

    public UnidataTrajectoryObsDataset() {
    }

    public UnidataTrajectoryObsDataset(NetcdfDataset ncd) throws IOException {
        super(ncd);
        this.latVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Lat);
        this.lonVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Lon);
        this.timeVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Time);
        this.elevVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Height);
        if (this.latVar == null) {
            throw new IllegalStateException("Missing latitude variable");
        }
        if (this.lonVar == null) {
            throw new IllegalStateException("Missing longitude coordinate variable");
        }
        if (this.timeVar == null) {
            throw new IllegalStateException("Missing time coordinate variable");
        }
        if (this.elevVar == null) {
            throw new IllegalStateException("Missing height coordinate variable");
        }
        this.timeDimName = this.timeVar.getDimension(0).getName();
        this.timeVarName = this.timeVar.getShortName();
        this.latVarName = this.latVar.getShortName();
        this.lonVarName = this.lonVar.getShortName();
        this.elevVarName = this.elevVar.getShortName();
        SingleTrajectoryObsDataset.Config trajConfig = new SingleTrajectoryObsDataset.Config("1Hz data", ncd.getRootGroup().findDimension(this.timeDimName), ncd.getRootGroup().findVariable(this.timeVarName), ncd.getRootGroup().findVariable(this.latVarName), ncd.getRootGroup().findVariable(this.lonVarName), ncd.getRootGroup().findVariable(this.elevVarName));
        this.setTrajectoryInfo(trajConfig);
    }
}

