/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class EscapeStrings {
    public static String asciiAlphaNumeric = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static String asciiNonAlphaNumeric = " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    private static String _namAllowedInURL = "!#$&'()*+,-./:;=?@_~";
    private static String _namAllowedInURLQuery = "!#$&'()*+,-./:;=?@_~";
    private static String _disallowedInUrlQuery = " \"<>[\\]^`{|}%";
    private static String _disallowedInUrl = " \"<>[\\]^`{|}%";
    public static String _allowableInUrlQuery = asciiAlphaNumeric + _namAllowedInURLQuery;
    public static String _allowableInUrl = asciiAlphaNumeric + _namAllowedInURL;
    private static String _disallowedInOGC = EscapeStrings.stringUnion(" ?&=,+", EscapeStrings.stringDiff(asciiNonAlphaNumeric, "-_.!~*'()"));
    private static String _namAllowedInOGC = "-_.!~*'()";
    public static String _allowableInOGC = asciiAlphaNumeric + _namAllowedInOGC;
    private static char _URIEscape = (char)37;
    private static String _allowableInURI = asciiAlphaNumeric + "-+_\\*!~";
    private static String _allowableInURI_CE = asciiAlphaNumeric + "-+_\\,=";
    public static String opendap_identifier_special_characters = "_!~*-\"";
    public static String opendap_identifier_characters = asciiAlphaNumeric + opendap_identifier_special_characters;
    static byte blank = (byte)32;
    static byte plus = (byte)43;
    static final byte hexa = 97;
    static final byte hexf = 102;
    static final byte hexA = 65;
    static final byte hexF = 70;
    static final byte hex0 = 48;
    static final byte hex9 = 57;
    static final byte ten = 10;
    private static final int sep = 46;

    public static String normalizeToXML(String s) {
        String xmlGT = "&gt;";
        String xmlLT = "&lt;";
        String xmlAmp = "&amp;";
        String xmlApos = "&apos;";
        String xmlQuote = "&quot;";
        StringBuffer sb = new StringBuffer(s);
        block7: for (int offset = 0; offset < sb.length(); ++offset) {
            char c = sb.charAt(offset);
            switch (c) {
                case '>': {
                    sb.replace(offset, offset + 1, xmlGT);
                    continue block7;
                }
                case '<': {
                    sb.replace(offset, offset + 1, xmlLT);
                    continue block7;
                }
                case '&': {
                    sb.replace(offset, offset + 1, xmlAmp);
                    continue block7;
                }
                case '\'': {
                    sb.replace(offset, offset + 1, xmlApos);
                    continue block7;
                }
                case '\"': {
                    sb.replace(offset, offset + 1, xmlQuote);
                    continue block7;
                }
            }
        }
        return sb.toString();
    }

    private static String stringUnion(String s1, String s2) {
        String union = s1;
        for (char c : s2.toCharArray()) {
            if (union.indexOf(c) >= 0) continue;
            union = union + c;
        }
        return union;
    }

    private static String stringDiff(String s1, String s2) {
        String diff = "";
        for (char c : s1.toCharArray()) {
            if (s2.indexOf(c) >= 0) continue;
            diff = diff + c;
        }
        return diff;
    }

    private static String escapeString(String in, String allowable, char esc, boolean spaceplus) throws Exception {
        StringBuffer out = new StringBuffer();
        if (in == null) {
            return null;
        }
        byte[] utf8 = in.getBytes("UTF-8");
        byte[] allow8 = allowable.getBytes("UTF-8");
        for (byte b : utf8) {
            if (b == blank && spaceplus) {
                out.append('+');
                continue;
            }
            boolean found = false;
            for (byte a : allow8) {
                if (a != b) continue;
                found = true;
                break;
            }
            if (found) {
                out.append((char)b);
                continue;
            }
            String c = Integer.toHexString(b);
            out.append(esc);
            if (c.length() < 2) {
                out.append('0');
            }
            out.append(c);
        }
        return out.toString();
    }

    private static String unescapeString(String in, char escape, boolean spaceplus) throws Exception {
        if (in == null) {
            return null;
        }
        byte[] utf8 = in.getBytes("UTF-8");
        byte escape8 = (byte)escape;
        byte[] out = new byte[utf8.length];
        int index8 = 0;
        int i = 0;
        while (i < utf8.length) {
            byte b;
            if ((b = utf8[i++]) == plus && spaceplus) {
                out[index8++] = blank;
            } else if (b == escape8 && i + 2 <= utf8.length) {
                b = (byte)(EscapeStrings.fromHex(utf8[i]) << 4 | EscapeStrings.fromHex(utf8[i + 1]));
                i += 2;
            }
            out[index8++] = b;
        }
        return new String(out, 0, index8, "UTF-8");
    }

    private static byte fromHex(byte b) throws NumberFormatException {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(10 + (b - 97));
        }
        if (b >= 65 && b <= 70) {
            return (byte)(10 + (b - 65));
        }
        throw new NumberFormatException("Illegal hex character: " + b);
    }

    public static String[] splitURL(String url) {
        String[] pair = new String[2];
        int index = url.indexOf(63);
        if (index >= 0) {
            pair[0] = url.substring(0, index);
            pair[1] = url.substring(index + 1, url.length());
        } else {
            pair[0] = url;
            pair[1] = null;
        }
        return pair;
    }

    public static String escapeDAPIdentifier(String id) {
        String s;
        try {
            s = EscapeStrings.escapeString(id, opendap_identifier_characters, _URIEscape, false);
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String unEscapeDAPIdentifier(String id) {
        String s;
        try {
            s = EscapeStrings.unescapeString(id, _URIEscape, false);
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String escapeURLQuery(String ce) {
        try {
            ce = EscapeStrings.escapeString(ce, _allowableInUrlQuery, _URIEscape, false);
        }
        catch (Exception e) {
            ce = null;
        }
        return ce;
    }

    public static String unescapeURLQuery(String ce) {
        try {
            ce = EscapeStrings.unescapeString(ce, _URIEscape, false);
        }
        catch (Exception e) {
            ce = null;
        }
        return ce;
    }

    public static String urlEncode(String s) {
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String urlDecode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String escapeURL(String url) {
        String newurl = null;
        try {
            URI u = new URI(url);
            u = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), EscapeStrings.escapeString(u.getPath(), _allowableInUrl, _URIEscape, true), EscapeStrings.escapeURLQuery(u.getQuery()), u.getFragment());
            newurl = u.toASCIIString();
        }
        catch (Exception e) {
            newurl = url;
        }
        return newurl;
    }

    public static String unescapeURL(String url) {
        String newurl = null;
        newurl = EscapeStrings.urlDecode(url);
        return newurl;
    }

    public static String escapeOGC(String s) {
        return EscapeStrings.urlEncode(s);
    }

    public static String unescapeOGC(String s) {
        return EscapeStrings.urlDecode(s);
    }

    public static String backslashEscape(String x, String reservedChars) {
        if (reservedChars == null) {
            return x;
        }
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            sb.setCharAt(pos, '\\');
            sb.insert(++pos, c);
            ++pos;
        }
        return sb.toString();
    }

    public static String backslashUnescape(String x) {
        if (!x.contains("\\")) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x.length());
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (c == '\\') {
                c = x.charAt(++pos);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> tokenizeEscapedName(String escapedName) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        int start = 0;
        while ((pos = escapedName.indexOf(46, pos + 1)) > 0) {
            if (pos <= 0 || escapedName.charAt(pos - 1) == '\\') continue;
            result.add(escapedName.substring(start, pos));
            start = pos + 1;
        }
        result.add(escapedName.substring(start, escapedName.length()));
        return result;
    }

    public static int indexOf(String escapedName, char c) {
        int pos = 0;
        do {
            if ((pos = escapedName.indexOf(c, pos + 1)) > 0) continue;
            return pos;
        } while (pos <= 0 || escapedName.charAt(pos - 1) == '\\');
        return pos;
    }

    public static void main(String[] args) {
        String s = "http://motherlode.ucar.edu:8081/thredds/dodsC/fmrc/NCEP/GFS/Global_0p5deg/runs/NCEP-GFS-Global_0p5deg_RUN_2011-07-15T00:00:00Z.html.asc?Total_cloud_cover_low_cloud%5B1:1:1%5D%5B0:1:360%5D%5B0:1:719%5D";
        System.out.printf("%s%n", s);
        System.out.printf("%s%n", EscapeStrings.unescapeURL(s));
    }

    public static void mainOld(String[] args) throws Exception {
    }
}

