/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import thredds.filesystem.CacheDirectory;
import thredds.filesystem.CacheFile;
import thredds.filesystem.CacheFileProto;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class CacheTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted cacheTable;
    private BeanTableSorted elemTable;
    private BeanTableSorted cfileTable;
    private CacheManager ehcache;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private JSplitPane split;
    private JTextArea interval;
    private JTextArea startDate;
    private JTextArea endDate;

    public CacheTable(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.cacheTable = new BeanTableSorted(CacheBean.class, (PreferencesExt)prefs.node("Cache"), false);
        this.cacheTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CacheBean bean = (CacheBean)CacheTable.this.cacheTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                ArrayList<ElemBean> beans = new ArrayList<ElemBean>();
                for (Object key : bean.cache.getKeys()) {
                    beans.add(new ElemBean((String)key, bean.cache.get(key)));
                }
                CacheTable.this.elemTable.setBeans(beans);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.cacheTable.getJTable(), "Options");
        varPopup.addAction("Show Stats", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CacheBean bean = (CacheBean)CacheTable.this.cacheTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CacheTable.this.infoTA.clear();
                Formatter f = new Formatter();
                try {
                    f.format("%s", bean.cache.getStatistics());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(CacheTable.this, e1.getMessage());
                }
                CacheTable.this.infoTA.appendLine(f.toString());
                CacheTable.this.infoTA.gotoTop();
                CacheTable.this.infoWindow.showIfNotIconified();
            }
        });
        this.elemTable = new BeanTableSorted(ElemBean.class, (PreferencesExt)prefs.node("Elem"), false);
        this.elemTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ElemBean bean = (ElemBean)CacheTable.this.elemTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CacheDirectory cd = (CacheDirectory)bean.value;
                ArrayList<CacheFileBean> beans = new ArrayList<CacheFileBean>();
                for (CacheFile cfile : cd.getChildren()) {
                    beans.add(new CacheFileBean(cfile));
                }
                CacheTable.this.cfileTable.setBeans(beans);
            }
        });
        this.cfileTable = new BeanTableSorted(CacheFileBean.class, (PreferencesExt)prefs.node("CacheFileBean"), false);
        this.cfileTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CacheFileBean bean = (CacheFileBean)CacheTable.this.cfileTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CacheTable.this.infoTA.setText(bean.cfile.toString());
                CacheTable.this.infoWindow.showIfNotIconified();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 100)));
        AbstractButton infoButton = BAMutil.makeButtcon("Info", "Info", false);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CacheTable.this.ehcache == null) {
                    return;
                }
                Formatter f = new Formatter();
                f.format(" Proto count = %d size = %d %n", CacheFileProto.countRead, CacheFileProto.countReadSize);
                int avg = CacheFileProto.countRead == 0 ? 0 : CacheFileProto.countReadSize / CacheFileProto.countRead;
                f.format("       avg = %d %n", avg);
                CacheTable.this.infoTA.setText(f.toString());
                CacheTable.this.infoTA.gotoTop();
                CacheTable.this.infoWindow.show();
            }
        });
        buttPanel.add(infoButton);
        this.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane(0, this.cacheTable, this.elemTable);
        JSplitPane split2 = new JSplitPane(0, split, this.cfileTable);
        this.add((Component)split2, "Center");
    }

    public void exit() {
        this.cacheTable.saveState(false);
        this.elemTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
    }

    public void setCache(CacheManager ehcache) {
        this.ehcache = ehcache;
        String[] cacheNames = ehcache.getCacheNames();
        ArrayList<CacheBean> beans = new ArrayList<CacheBean>();
        for (String cacheName : cacheNames) {
            Cache cache = ehcache.getCache(cacheName);
            System.out.printf("Open Cache %s%n %s%n", cache, cache.getStatistics().toString());
            beans.add(new CacheBean(cache));
        }
        this.cacheTable.setBeans(beans);
    }

    public class CacheFileBean {
        CacheFile cfile;

        public String getShortName() {
            return this.cfile.getShortName();
        }

        public Date getLastModified() {
            return new Date(this.cfile.getLastModified());
        }

        public long getLength() {
            return this.cfile.getLength();
        }

        public boolean isDirectory() {
            return this.cfile.isDirectory();
        }

        public CacheFileBean() {
        }

        CacheFileBean(CacheFile cfile) {
            this.cfile = cfile;
        }
    }

    public class ElemBean {
        String key;
        Object value;

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public ElemBean() {
        }

        ElemBean(String key, Element elem) {
            this.key = key;
            this.value = elem.getObjectValue();
        }
    }

    public class CacheBean {
        Cache cache;

        public CacheBean() {
        }

        CacheBean(Cache cache) {
            this.cache = cache;
        }

        public String getName() {
            return this.cache.getName();
        }

        public String getStatus() {
            return this.cache.getStatus().toString();
        }

        public int getDiskStoreSize() {
            return this.cache.getDiskStoreSize();
        }

        public int getSize() {
            return this.cache.getSize();
        }

        public long getMemoryStoreSize() {
            return this.cache.getMemoryStoreSize();
        }
    }
}

