/*
 * Decompiled with CFR 0.152.
 */
package opendap.Server;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opendap.Server.AbstractClause;
import opendap.Server.DAP2ServerSideException;
import opendap.Server.Operator;
import opendap.Server.SubClause;
import opendap.Server.TopLevelClause;
import opendap.Server.ValueClause;
import opendap.Server.parsers.ExprParserConstants;

public class RelOpClause
extends AbstractClause
implements TopLevelClause {
    protected boolean value;
    protected int operator;
    protected SubClause lhs;
    protected List rhs;

    protected RelOpClause(int operator, SubClause lhs, List rhs) throws DAP2ServerSideException {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
        this.children = new ArrayList();
        this.children.add(lhs);
        this.children.addAll(rhs);
        this.constant = true;
        for (SubClause current : this.children) {
            current.setParent(this);
            if (current.isConstant()) continue;
            this.constant = false;
        }
        if (this.constant) {
            this.evaluate();
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean evaluate() throws DAP2ServerSideException {
        if (this.constant && this.defined) {
            return this.value;
        }
        if (this.rhs.size() == 1) {
            this.value = Operator.op(this.operator, this.lhs.evaluate(), ((SubClause)this.rhs.get(0)).evaluate());
        } else {
            this.value = false;
            Iterator it = this.rhs.iterator();
            while (it.hasNext() && !this.value) {
                if (!Operator.op(this.operator, this.lhs.evaluate(), ((SubClause)it.next()).evaluate())) continue;
                this.value = true;
            }
        }
        this.defined = true;
        return this.value;
    }

    public SubClause getLHS() {
        return this.lhs;
    }

    public List getRHS() {
        return this.rhs;
    }

    public int getOperator() {
        return this.operator;
    }

    public void printConstraint(PrintWriter os) {
        this.lhs.printConstraint(os);
        String op = ExprParserConstants.tokenImage[this.operator];
        op = op.substring(1, op.length() - 1);
        os.print(op);
        if (this.rhs.size() == 1) {
            ((ValueClause)this.rhs.get(0)).printConstraint(os);
        } else {
            os.print("{");
            Iterator it = this.rhs.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    os.print(",");
                }
                ((ValueClause)it.next()).printConstraint(os);
                first = false;
            }
            os.print("}");
        }
    }
}

