/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.border.EtchedBorder;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.ui.GeoGridTable;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.gis.MapBean;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.ui.grid.GridController;
import ucar.nc2.ui.grid.GridTable;
import ucar.nc2.ui.grid.VertPanel;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.MFlowLayout;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.ProgressMonitor;
import ucar.nc2.ui.widget.ProgressMonitorTask;
import ucar.nc2.ui.widget.SuperComboBox;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.NamedObject;
import ucar.util.prefs.PreferencesExt;

public class GridUI
extends JPanel {
    private static final String DATASET_URL = "DatasetURL";
    private static final String GEOTIFF_FILECHOOSER_DEFAULTDIR = "geotiffDefDir";
    private PreferencesExt store;
    private JFrame parent;
    private FileManager fileChooser;
    SuperComboBox fieldChooser;
    SuperComboBox levelChooser;
    SuperComboBox timeChooser;
    SuperComboBox ensembleChooser;
    SuperComboBox runtimeChooser;
    NavigatedPanel panz = new NavigatedPanel();
    VertPanel vertPanel;
    GridTable gridTable;
    JLabel dataValueLabel;
    JLabel positionLabel;
    private GridController controller;
    private ColorScale.Panel colorScalePanel;
    private GeoGridTable dsTable;
    private TextHistoryPane datasetInfoTA;
    private TextHistoryPane ncmlTA;
    private JPanel drawingPanel;
    private JSplitPane splitDraw;
    private JComboBox csDataMinMax;
    private PopupMenu mapBeanMenu;
    private JLabel datasetNameLabel;
    private IndependentWindow infoWindow = null;
    private IndependentWindow ncmlWindow = null;
    private IndependentWindow gtWindow = null;
    private JDialog dsDialog = null;
    private FileManager geotiffFileChooser;
    private JPanel fieldPanel;
    private JPanel toolPanel;
    private JToolBar navToolbar;
    private JToolBar moveToolbar;
    private AbstractAction navToolbarAction;
    private AbstractAction moveToolbarAction;
    private JMenu configMenu;
    private AbstractAction redrawAction;
    private AbstractAction showDatasetInfoAction;
    private AbstractAction showNcMLAction;
    private AbstractAction showGridTableAction;
    private AbstractAction showGridDatasetInfoAction;
    private AbstractAction showNetcdfDatasetAction;
    private AbstractAction minmaxHorizAction;
    private AbstractAction minmaxVertAction;
    private AbstractAction minmaxVolAction;
    private AbstractAction minmaxHoldAction;
    private AbstractAction fieldLoopAction;
    private AbstractAction levelLoopAction;
    private AbstractAction timeLoopAction;
    private boolean selected = false;
    private int mapBeanCount = 0;
    private boolean debugBeans = false;
    private boolean debugChooser = false;
    private boolean debugPrint = false;
    private boolean debugHelp = false;
    private boolean debugTask = false;
    private ArrayList choosers;

    public GridUI(PreferencesExt pstore, RootPaneContainer root, FileManager fileChooser, int defaultHeight) {
        this.store = pstore;
        this.fileChooser = fileChooser;
        try {
            this.choosers = new ArrayList();
            this.fieldChooser = new SuperComboBox(root, "field", true, null);
            this.choosers.add(new Chooser("field", this.fieldChooser, true));
            this.levelChooser = new SuperComboBox(root, "level", false, null);
            this.choosers.add(new Chooser("level", this.levelChooser, false));
            this.timeChooser = new SuperComboBox(root, "time", false, null);
            this.choosers.add(new Chooser("time", this.timeChooser, false));
            this.ensembleChooser = new SuperComboBox(root, "ensemble", false, null);
            this.choosers.add(new Chooser("ensemble", this.ensembleChooser, false));
            this.runtimeChooser = new SuperComboBox(root, "runtime", false, null);
            this.choosers.add(new Chooser("runtime", this.runtimeChooser, false));
            this.makeActionsDataset();
            this.makeActionsToolbars();
            this.gridTable = new GridTable("field");
            this.gtWindow = new IndependentWindow("Grid Table Information", BAMutil.getImage("GDVs"), this.gridTable.getPanel());
            PreferencesExt dsNode = (PreferencesExt)pstore.node("DatasetTable");
            this.dsTable = new GeoGridTable(dsNode, true);
            this.dsDialog = this.dsTable.makeDialog(root, "NetcdfDataset Info", false);
            Rectangle bounds = (Rectangle)dsNode.getBean("DialogBounds", new Rectangle(50, 50, 800, 450));
            this.dsDialog.setBounds(bounds);
            this.controller = new GridController(this, this.store);
            this.makeUI(defaultHeight);
            this.controller.finishInit();
            this.geotiffFileChooser = new FileManager(this.parent);
            this.geotiffFileChooser.setCurrentDirectory(this.store.get(GEOTIFF_FILECHOOSER_DEFAULTDIR, "."));
        }
        catch (Exception e) {
            System.out.println("UI creation failed");
            e.printStackTrace();
        }
    }

    public void storePersistentData() {
        this.store.putInt("vertSplit", this.splitDraw.getDividerLocation());
        this.store.putBoolean("navToolbarAction", (Boolean)this.navToolbarAction.getValue("state"));
        this.store.putBoolean("moveToolbarAction", (Boolean)this.moveToolbarAction.getValue("state"));
        this.dsTable.save();
        this.dsTable.getPrefs().putBeanObject("DialogBounds", this.dsDialog.getBounds());
        this.store.put(GEOTIFF_FILECHOOSER_DEFAULTDIR, this.geotiffFileChooser.getCurrentDirectory());
        this.controller.storePersistentData();
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean b) {
        this.selected = b;
        this.showGridTableAction.setEnabled(b);
        this.showNcMLAction.setEnabled(b);
        this.showNcMLAction.setEnabled(b);
        this.showNetcdfDatasetAction.setEnabled(b);
        this.showGridDatasetInfoAction.setEnabled(b);
        this.navToolbarAction.setEnabled(b);
        this.moveToolbarAction.setEnabled(b);
        this.controller.showGridAction.setEnabled(b);
        this.controller.showContoursAction.setEnabled(b);
        this.controller.showContourLabelsAction.setEnabled(b);
        this.redrawAction.setEnabled(b);
        this.minmaxHorizAction.setEnabled(b);
        this.minmaxVertAction.setEnabled(b);
        this.minmaxVolAction.setEnabled(b);
        this.minmaxHoldAction.setEnabled(b);
        this.fieldLoopAction.setEnabled(b);
        this.levelLoopAction.setEnabled(b);
        this.timeLoopAction.setEnabled(b);
        this.panz.setEnabledActions(b);
    }

    public void addMapBean(MapBean mb) {
        this.mapBeanMenu.addAction(mb.getActionDesc(), mb.getIcon(), mb.getAction());
        if (this.mapBeanCount == 0) {
            this.setMapRenderer(mb.getRenderer());
        }
        ++this.mapBeanCount;
        mb.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Renderer")) {
                    GridUI.this.setMapRenderer((Renderer)e.getNewValue());
                }
            }
        });
    }

    void setMapRenderer(Renderer mapRenderer) {
        this.controller.setMapRenderer(mapRenderer);
    }

    public void setDataset(InvDataset ds) {
        if (ds == null) {
            return;
        }
        OpenDatasetTask openTask = new OpenDatasetTask(ds);
        ProgressMonitor pm = new ProgressMonitor(openTask);
        pm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("success")) {
                    GridUI.this.controller.showDataset();
                    GridUI.this.gridTable.setDataset(GridUI.this.controller.getFields());
                    GridUI.this.datasetNameLabel.setText("Dataset:  " + GridUI.this.controller.getDatasetUrlString());
                    GridUI.this.setSelected(true);
                    GridUI.this.gtWindow.hide();
                }
            }
        });
        pm.start(this, "Open Dataset " + ds.getName(), 100);
    }

    public void setDataset(ucar.nc2.dt.GridDataset ds) {
        this.controller.setGridDataset(ds);
        this.controller.showDataset();
        this.datasetNameLabel.setText("Dataset:  " + this.controller.getDatasetUrlString());
        this.gridTable.setDataset(this.controller.getFields());
    }

    void setFields(List fields) {
        this.fieldChooser.setCollection(fields.iterator());
    }

    void setField(GridDatatype field) {
        List<NamedObject> names;
        NamedObject no;
        int idx = this.fieldChooser.setSelectedByName(field.getFullName());
        if (idx < 0) {
            this.fieldChooser.setSelectedByIndex(0);
        }
        this.fieldChooser.setToolTipText(field.getDescription());
        GridCoordSystem gcs = field.getCoordinateSystem();
        CoordinateAxis1D axis = gcs.getVerticalAxis();
        this.setChooserWanted("level", axis != null);
        if (axis != null) {
            List<NamedObject> levels = axis.getNames();
            this.levelChooser.setCollection(levels.iterator());
            no = levels.get(this.controller.getCurrentLevelIndex());
            this.levelChooser.setSelectedByName(no.getName());
        }
        if (gcs.hasTimeAxis()) {
            axis = gcs.hasTimeAxis1D() ? gcs.getTimeAxis1D() : gcs.getTimeAxisForRun(0);
            this.setChooserWanted("time", axis != null);
            if (axis != null) {
                names = axis.getNames();
                this.timeChooser.setCollection(names.iterator());
                no = names.get(this.controller.getCurrentTimeIndex());
                this.timeChooser.setSelectedByName(no.getName());
            }
        } else {
            this.setChooserWanted("time", false);
        }
        this.setChooserWanted("ensemble", (axis = gcs.getEnsembleAxis()) != null);
        if (axis != null) {
            names = axis.getNames();
            this.ensembleChooser.setCollection(names.iterator());
            no = names.get(this.controller.getCurrentEnsembleIndex());
            this.ensembleChooser.setSelectedByName(no.getName());
        }
        this.setChooserWanted("runtime", (axis = gcs.getRunTimeAxis()) != null);
        if (axis != null) {
            names = axis.getNames();
            this.runtimeChooser.setCollection(names.iterator());
            no = names.get(this.controller.getCurrentRunTimeIndex());
            this.runtimeChooser.setSelectedByName(no.getName());
        }
        this.setChoosers();
        this.colorScalePanel.setUnitString(field.getUnitsString());
    }

    void setDrawHorizAndVert(boolean drawHoriz, boolean drawVert) {
        this.drawingPanel.removeAll();
        if (drawHoriz && drawVert) {
            this.splitDraw.setTopComponent(this.panz);
            this.splitDraw.setBottomComponent(this.vertPanel);
            this.drawingPanel.add((Component)this.splitDraw, "Center");
        } else if (drawHoriz) {
            this.drawingPanel.add((Component)this.panz, "Center");
        } else if (drawVert) {
            this.drawingPanel.add((Component)this.splitDraw, "Center");
        }
    }

    private void makeActionsDataset() {
        AbstractAction chooseLocalDatasetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvDatasetImpl invDs;
                String filename = GridUI.this.fileChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                try {
                    invDs = new InvDatasetImpl(filename, FeatureType.GRID, ServiceType.NETCDF);
                }
                catch (Exception ue) {
                    JOptionPane.showMessageDialog(GridUI.this, "Invalid filename = <" + filename + ">\n" + ue.getMessage());
                    ue.printStackTrace();
                    return;
                }
                GridUI.this.setDataset(invDs);
            }
        };
        BAMutil.setActionProperties(chooseLocalDatasetAction, "FileChooser", "open Local dataset...", false, 76, -1);
        this.redrawAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridUI.this.repaint();
                GridUI.this.controller.start(true);
                GridUI.this.controller.draw(true);
            }
        };
        BAMutil.setActionProperties(this.redrawAction, "alien", "RedRaw", false, 87, 0);
        this.showDatasetInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GridUI.this.infoWindow == null) {
                    GridUI.this.datasetInfoTA = new TextHistoryPane();
                    GridUI.this.infoWindow = new IndependentWindow("Dataset Information", BAMutil.getImage("GDVs"), GridUI.this.datasetInfoTA);
                    GridUI.this.infoWindow.setSize(700, 700);
                    GridUI.this.infoWindow.setLocation(100, 100);
                }
                GridUI.this.datasetInfoTA.clear();
                GridUI.this.datasetInfoTA.appendLine(GridUI.this.controller.getDatasetInfo());
                GridUI.this.datasetInfoTA.gotoTop();
                GridUI.this.infoWindow.show();
            }
        };
        BAMutil.setActionProperties(this.showDatasetInfoAction, "Information", "Show info...", false, 83, -1);
        this.showNcMLAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GridUI.this.ncmlWindow == null) {
                    GridUI.this.ncmlTA = new TextHistoryPane();
                    GridUI.this.ncmlWindow = new IndependentWindow("Dataset NcML", BAMutil.getImage("GDVs"), GridUI.this.ncmlTA);
                    GridUI.this.ncmlWindow.setSize(700, 700);
                    GridUI.this.ncmlWindow.setLocation(200, 70);
                }
                GridUI.this.ncmlTA.clear();
                GridUI.this.ncmlTA.appendLine(GridUI.this.controller.getNcML());
                GridUI.this.ncmlTA.gotoTop();
                GridUI.this.ncmlWindow.show();
            }
        };
        BAMutil.setActionProperties(this.showNcMLAction, null, "Show NcML...", false, 88, -1);
        this.showGridDatasetInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GridUI.this.ncmlWindow == null) {
                    GridUI.this.ncmlTA = new TextHistoryPane();
                    GridUI.this.ncmlWindow = new IndependentWindow("Dataset NcML", BAMutil.getImage("GDVs"), GridUI.this.ncmlTA);
                    GridUI.this.ncmlWindow.setSize(700, 700);
                    GridUI.this.ncmlWindow.setLocation(200, 70);
                }
                GridUI.this.ncmlTA.clear();
                GridUI.this.ncmlTA.appendLine(GridUI.this.controller.getDatasetXML());
                GridUI.this.ncmlTA.gotoTop();
                GridUI.this.ncmlWindow.show();
            }
        };
        BAMutil.setActionProperties(this.showGridDatasetInfoAction, null, "Show GridDataset Info XML...", false, 88, -1);
        this.showGridTableAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridUI.this.gtWindow.show();
            }
        };
        BAMutil.setActionProperties(this.showGridTableAction, "Table", "grid Table...", false, 84, -1);
        this.showNetcdfDatasetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetcdfDataset netcdfDataset = GridUI.this.controller.getNetcdfDataset();
                if (null != netcdfDataset) {
                    try {
                        GridUI.this.dsTable.setDataset(netcdfDataset, null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    GridUI.this.dsDialog.show();
                }
            }
        };
        BAMutil.setActionProperties(this.showNetcdfDatasetAction, "netcdf", "NetcdfDataset Table Info...", false, 68, -1);
        this.minmaxHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridUI.this.csDataMinMax.setSelectedIndex(0);
                GridUI.this.controller.setDataMinMaxType(0);
            }
        };
        BAMutil.setActionProperties(this.minmaxHorizAction, null, "Horizontal plane", false, 72, 0);
        this.minmaxVertAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridUI.this.csDataMinMax.setSelectedIndex(1);
                GridUI.this.controller.setDataMinMaxType(1);
            }
        };
        BAMutil.setActionProperties(this.minmaxVertAction, null, "Vertical plane", false, 86, 0);
        this.minmaxVolAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridUI.this.csDataMinMax.setSelectedIndex(2);
                GridUI.this.controller.setDataMinMaxType(2);
            }
        };
        BAMutil.setActionProperties(this.minmaxVolAction, null, "Grid volume", false, 71, 0);
        this.minmaxHoldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridUI.this.csDataMinMax.setSelectedIndex(3);
                GridUI.this.controller.setDataMinMaxType(3);
            }
        };
        BAMutil.setActionProperties(this.minmaxHoldAction, null, "Hold scale constant", false, 67, 0);
        this.fieldLoopAction = new LoopControlAction(this.fieldChooser);
        this.levelLoopAction = new LoopControlAction(this.levelChooser);
        this.timeLoopAction = new LoopControlAction(this.timeChooser);
    }

    private void makeActionsToolbars() {
        this.navToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    GridUI.this.toolPanel.add(GridUI.this.navToolbar);
                } else {
                    GridUI.this.toolPanel.remove(GridUI.this.navToolbar);
                }
            }
        };
        BAMutil.setActionProperties(this.navToolbarAction, "MagnifyPlus", "show Navigate toolbar", true, 77, 0);
        this.navToolbarAction.putValue("state", new Boolean(this.store.getBoolean("navToolbarAction", true)));
        this.moveToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    GridUI.this.toolPanel.add(GridUI.this.moveToolbar);
                } else {
                    GridUI.this.toolPanel.remove(GridUI.this.moveToolbar);
                }
            }
        };
        BAMutil.setActionProperties(this.moveToolbarAction, "Up", "show Move toolbar", true, 77, 0);
        this.moveToolbarAction.putValue("state", new Boolean(this.store.getBoolean("moveToolbarAction", true)));
    }

    private void makeUI(int defaultHeight) {
        this.datasetNameLabel = new JLabel();
        this.toolPanel = new JPanel();
        this.toolPanel.setBorder(new EtchedBorder());
        this.toolPanel.setLayout(new MFlowLayout(0, 0, 0));
        JMenu dataMenu = new JMenu("Dataset");
        dataMenu.setMnemonic('D');
        this.configMenu = new JMenu("Configure");
        this.configMenu.setMnemonic('C');
        JMenu toolMenu = new JMenu("Controls");
        toolMenu.setMnemonic('T');
        this.addActionsToMenus(dataMenu, this.configMenu, toolMenu);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(dataMenu);
        menuBar.add(this.configMenu);
        menuBar.add(toolMenu);
        this.toolPanel.add(menuBar);
        this.fieldPanel = new JPanel();
        this.fieldPanel.setLayout(new FlowLayout(0, 0, 0));
        this.toolPanel.add(this.fieldPanel);
        this.toolPanel.add(this.controller.strideSpinner);
        BAMutil.addActionToContainer(this.toolPanel, this.controller.drawHorizAction);
        BAMutil.addActionToContainer(this.toolPanel, this.controller.drawVertAction);
        this.mapBeanMenu = MapBean.makeMapSelectButton();
        this.toolPanel.add(this.mapBeanMenu.getParentComponent());
        this.panz.setLayout(new FlowLayout());
        this.navToolbar = this.panz.getNavToolBar();
        this.moveToolbar = this.panz.getMoveToolBar();
        if (((Boolean)this.navToolbarAction.getValue("state")).booleanValue()) {
            this.toolPanel.add(this.navToolbar);
        }
        if (((Boolean)this.moveToolbarAction.getValue("state")).booleanValue()) {
            this.toolPanel.add(this.moveToolbar);
        }
        BAMutil.addActionToContainer(this.toolPanel, this.panz.setReferenceAction);
        BAMutil.addActionToContainer(this.toolPanel, this.controller.dataProjectionAction);
        BAMutil.addActionToContainer(this.toolPanel, this.controller.showGridAction);
        BAMutil.addActionToContainer(this.toolPanel, this.controller.showContoursAction);
        BAMutil.addActionToContainer(this.toolPanel, this.controller.showContourLabelsAction);
        BAMutil.addActionToContainer(this.toolPanel, this.redrawAction);
        this.vertPanel = new VertPanel();
        this.splitDraw = new JSplitPane(0, this.panz, this.vertPanel);
        int divLoc = this.store.getInt("vertSplit", 2 * defaultHeight / 3);
        this.splitDraw.setDividerLocation(divLoc);
        this.drawingPanel = new JPanel(new BorderLayout());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        this.positionLabel = new JLabel("position");
        this.positionLabel.setToolTipText("position at cursor");
        this.dataValueLabel = new JLabel("data value", 0);
        this.dataValueLabel.setToolTipText("data value (double click on grid)");
        statusPanel.add((Component)this.positionLabel, "West");
        statusPanel.add((Component)this.dataValueLabel, "Center");
        this.panz.setPositionLabel(this.positionLabel);
        this.colorScalePanel = new ColorScale.Panel(this, this.controller.getColorScale());
        String[] csDataTypes = new String[]{"horiz", "vert", "Vol", "hold"};
        this.csDataMinMax = new JComboBox<String>(csDataTypes);
        this.csDataMinMax.setToolTipText("ColorScale Min/Max setting");
        this.csDataMinMax.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridUI.this.controller.setDataMinMaxType(GridUI.this.csDataMinMax.getSelectedIndex());
            }
        });
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)this.colorScalePanel, "Center");
        westPanel.add((Component)this.csDataMinMax, "North");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.add((Component)this.datasetNameLabel, "North");
        northPanel.add((Component)this.toolPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)northPanel, "North");
        this.add((Component)statusPanel, "South");
        this.add((Component)westPanel, "West");
        this.add((Component)this.drawingPanel, "Center");
        this.setDrawHorizAndVert(this.controller.drawHorizOn, this.controller.drawVertOn);
    }

    private void setChoosers() {
        this.fieldPanel.removeAll();
        for (int i = 0; i < this.choosers.size(); ++i) {
            Chooser c = (Chooser)this.choosers.get(i);
            if (!c.isWanted) continue;
            this.fieldPanel.add(c.field);
        }
    }

    private void setChooserWanted(String name, boolean want) {
        for (int i = 0; i < this.choosers.size(); ++i) {
            Chooser chooser = (Chooser)this.choosers.get(i);
            if (!chooser.name.equals(name)) continue;
            chooser.isWanted = want;
        }
    }

    private void addToolbarOption(String toolbarName, JToolBar toolbar, AbstractAction act) {
        boolean wantsToolbar = this.store.getBoolean(toolbarName, true);
        if (wantsToolbar) {
            this.toolPanel.add(toolbar);
        }
    }

    void addActionsToMenus(JMenu datasetMenu, JMenu configMenu, JMenu toolMenu) {
        BAMutil.addActionToMenu(datasetMenu, this.showGridTableAction);
        BAMutil.addActionToMenu(datasetMenu, this.showDatasetInfoAction);
        BAMutil.addActionToMenu(datasetMenu, this.showNcMLAction);
        BAMutil.addActionToMenu(datasetMenu, this.showGridDatasetInfoAction);
        BAMutil.addActionToMenu(datasetMenu, this.showNetcdfDatasetAction);
        JMenu toolbarMenu = new JMenu("Toolbars");
        toolbarMenu.setMnemonic('T');
        configMenu.add(toolbarMenu);
        BAMutil.addActionToMenu(toolbarMenu, this.navToolbarAction);
        BAMutil.addActionToMenu(toolbarMenu, this.moveToolbarAction);
        JMenu displayMenu = new JMenu("Display control");
        displayMenu.setMnemonic('D');
        BAMutil.addActionToMenu(displayMenu, this.controller.showGridAction);
        BAMutil.addActionToMenu(displayMenu, this.controller.showContoursAction);
        BAMutil.addActionToMenu(displayMenu, this.controller.showContourLabelsAction);
        BAMutil.addActionToMenu(displayMenu, this.redrawAction);
        toolMenu.add(displayMenu);
        JMenu loopMenu = new JMenu("Loop control");
        loopMenu.setMnemonic('L');
        BAMutil.addActionToMenu(loopMenu, this.fieldLoopAction);
        BAMutil.addActionToMenu(loopMenu, this.levelLoopAction);
        BAMutil.addActionToMenu(loopMenu, this.timeLoopAction);
        toolMenu.add(loopMenu);
        JMenu mmMenu = new JMenu("ColorScale min/max");
        mmMenu.setMnemonic('C');
        BAMutil.addActionToMenu(mmMenu, this.minmaxHorizAction);
        BAMutil.addActionToMenu(mmMenu, this.minmaxVertAction);
        BAMutil.addActionToMenu(mmMenu, this.minmaxVolAction);
        BAMutil.addActionToMenu(mmMenu, this.minmaxHoldAction);
        toolMenu.add(mmMenu);
        JMenu zoomMenu = new JMenu("Zoom/Pan");
        zoomMenu.setMnemonic('Z');
        this.panz.addActionsToMenu(zoomMenu);
        toolMenu.add(zoomMenu);
    }

    private class OpenDatasetTask
    extends ProgressMonitorTask
    implements CancelTask {
        ThreddsDataFactory factory = new ThreddsDataFactory();
        InvDataset invds;

        OpenDatasetTask(InvDataset ds) {
            this.invds = ds;
        }

        @Override
        public void run() {
            NetcdfDataset dataset = null;
            GridDataset gridDataset = null;
            Formatter errlog = new Formatter();
            try {
                dataset = this.factory.openDataset(this.invds, true, (CancelTask)this, errlog);
                gridDataset = new GridDataset(dataset);
            }
            catch (IOException e) {
                this.setError("Failed to open datset: " + errlog);
            }
            boolean bl = this.success = !this.cancel && gridDataset != null;
            if (this.success) {
                GridUI.this.controller.setGridDataset(gridDataset);
            }
            this.done = true;
        }
    }

    private class LoopControlAction
    extends AbstractAction {
        SuperComboBox scbox;

        LoopControlAction(SuperComboBox cbox) {
            this.scbox = cbox;
            BAMutil.setActionProperties(this, null, cbox.getName(), false, 0, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.scbox.getLoopControl().show();
        }
    }

    private class Chooser {
        boolean isWanted;
        String name;
        SuperComboBox field;

        Chooser(String name, SuperComboBox field, boolean want) {
            this.name = name;
            this.field = field;
            this.isWanted = want;
        }
    }
}

