/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.radial.CFnetCDF2Dataset;
import ucar.nc2.dt.radial.Dorade2Dataset;
import ucar.nc2.dt.radial.LevelII2Dataset;
import ucar.nc2.dt.radial.Nids2Dataset;
import ucar.nc2.util.CancelTask;

public class RadialDatasetSweepFactory {
    private StringBuffer log;

    public String getErrorMessages() {
        return this.log == null ? "" : this.log.toString();
    }

    public RadialDatasetSweep open(String location, CancelTask cancelTask) throws IOException {
        this.log = new StringBuffer();
        NetcdfDataset ncd = NetcdfDataset.acquireDataset(location, cancelTask);
        return this.open(ncd);
    }

    public RadialDatasetSweep open(NetcdfDataset ncd) {
        String convention = ncd.findAttValueIgnoreCase(null, "Conventions", null);
        if (null != convention && convention.equals("_Coordinates")) {
            String format = ncd.findAttValueIgnoreCase(null, "Format", null);
            if (format.equals("Unidata/netCDF/Dorade")) {
                return new Dorade2Dataset(ncd);
            }
            if (format.equals("ARCHIVE2") || format.equals("AR2V0001")) {
                return new LevelII2Dataset(ncd);
            }
            if (format.equals("Level3/NIDS")) {
                return new Nids2Dataset(ncd);
            }
        } else if (null != convention && convention.startsWith("CF/Radial")) {
            return new CFnetCDF2Dataset(ncd);
        }
        return null;
    }
}

