/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.ControllerOS;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.DatasetCollectionFromCatalog;
import thredds.inventory.DateExtractor;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.DateExtractorNone;
import thredds.inventory.FeatureCollectionConfig;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import thredds.inventory.bdb.MetadataManager;
import thredds.inventory.filter.Composite;
import thredds.inventory.filter.LastModifiedLimit;
import thredds.inventory.filter.RegExpMatchOnName;
import thredds.inventory.filter.WildcardMatchOnName;
import thredds.inventory.filter.WildcardMatchOnPath;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.ListenerManager;

@ThreadSafe
public class DatasetCollectionManager
implements CollectionManager {
    public static final String CATALOG = "catalog:";
    public static final String RESCAN = "rescan";
    public static final String PROTO = "proto";
    private static final Logger logger = LoggerFactory.getLogger(DatasetCollectionManager.class);
    private static MController controller;
    private static boolean enableMetadataManager;
    protected String collectionName;
    protected DateExtractor dateExtractor;
    private final CollectionSpecParser sp;
    private final List<MCollection> scanList = new ArrayList<MCollection>();
    private final TimeUnit recheck;
    private final double olderThanFilterInSecs;
    private final FeatureCollectionConfig.ProtoChoice protoChoice;
    private Map<String, MFile> map;
    private long lastScanned;
    private long lastChanged;
    private ListenerManager lm;
    private MetadataManager mm;

    public static void enableMetadataManager() {
        enableMetadataManager = true;
    }

    public static void setController(MController _controller) {
        controller = _controller;
    }

    public static DatasetCollectionManager open(String collection, String olderThan, Formatter errlog) throws IOException {
        if (collection.startsWith(CATALOG)) {
            return new DatasetCollectionFromCatalog(collection);
        }
        return new DatasetCollectionManager(collection, olderThan, errlog);
    }

    private DatasetCollectionManager(String collectionSpec, String olderThan, Formatter errlog) {
        this.sp = new CollectionSpecParser(collectionSpec, errlog);
        this.collectionName = collectionSpec;
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(2);
        if (null != this.sp.getFilter()) {
            filters.add(new WildcardMatchOnName(this.sp.getFilter()));
        }
        this.olderThanFilterInSecs = this.getOlderThanFilter(filters, olderThan);
        this.dateExtractor = this.sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(this.sp.getDateFormatMark(), true);
        this.scanList.add(new MCollection(this.sp.getTopDir(), this.sp.getTopDir(), this.sp.wantSubdirs(), filters, null));
        this.createListenerManager();
    }

    public DatasetCollectionManager(FeatureCollectionConfig config, Formatter errlog) {
        this.sp = new CollectionSpecParser(config.spec, errlog);
        this.collectionName = config.name != null ? config.name : config.spec;
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != this.sp.getFilter()) {
            filters.add(new WildcardMatchOnName(this.sp.getFilter()));
        }
        this.olderThanFilterInSecs = this.getOlderThanFilter(filters, config.olderThan);
        this.dateExtractor = this.sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(this.sp.getDateFormatMark(), true);
        this.scanList.add(new MCollection(this.sp.getTopDir(), this.sp.getTopDir(), this.sp.wantSubdirs(), filters, null));
        this.recheck = this.makeRecheck(config.recheckAfter);
        this.protoChoice = config.protoConfig.choice;
        this.createListenerManager();
    }

    private double getOlderThanFilter(List<MFileFilter> filters, String olderThan) {
        if (olderThan != null) {
            try {
                TimeUnit tu = new TimeUnit(olderThan);
                double olderThanV = tu.getValueInSeconds();
                filters.add(new LastModifiedLimit((long)(1000.0 * olderThanV)));
                return olderThanV;
            }
            catch (Exception e) {
                logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderThan);
            }
        }
        return -1.0;
    }

    private TimeUnit makeRecheck(String recheckS) {
        if (recheckS != null) {
            try {
                return new TimeUnit(recheckS);
            }
            catch (Exception e) {
                logger.error(this.collectionName + ": Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
        return null;
    }

    @Override
    public void close() {
        if (this.mm != null) {
            this.mm.close();
        }
    }

    protected DatasetCollectionManager() {
        this.recheck = null;
        this.olderThanFilterInSecs = -1.0;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.sp = null;
        this.createListenerManager();
    }

    public DatasetCollectionManager(String recheckS) {
        this.recheck = this.makeRecheck(recheckS);
        this.olderThanFilterInSecs = -1.0;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.sp = null;
        this.createListenerManager();
    }

    public void setDateExtractor(DateExtractor dateExtractor) {
        this.dateExtractor = dateExtractor;
    }

    public void addDirectoryScan(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, Object auxInfo) {
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != regexpPatternString) {
            filters.add(new RegExpMatchOnName(regexpPatternString));
        } else if (suffix != null) {
            filters.add(new WildcardMatchOnPath("*" + suffix + "$"));
        }
        if (olderS != null) {
            try {
                TimeUnit tu = new TimeUnit(olderS);
                filters.add(new LastModifiedLimit((long)(1000.0 * tu.getValueInSeconds())));
            }
            catch (Exception e) {
                logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
        boolean wantSubdirs = true;
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            wantSubdirs = false;
        }
        Composite filter = filters.size() == 0 ? null : (filters.size() == 1 ? (MFileFilter)filters.get(0) : new Composite(filters));
        MCollection mc = new MCollection(dirName, dirName, wantSubdirs, filter, auxInfo);
        StringBuilder sb = new StringBuilder(dirName);
        if (wantSubdirs) {
            sb.append("**/");
        }
        if (null != regexpPatternString) {
            sb.append(regexpPatternString);
        } else if (suffix != null) {
            sb.append(suffix);
        } else {
            sb.append("noFilter");
        }
        this.collectionName = sb.toString();
        this.scanList.add(mc);
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public String getRoot() {
        return this.sp == null ? null : this.sp.getTopDir();
    }

    public CollectionSpecParser getCollectionSpecParser() {
        return this.sp;
    }

    public double getOlderThanFilterInSecs() {
        return this.olderThanFilterInSecs;
    }

    @Override
    public TimeUnit getRecheck() {
        return this.recheck;
    }

    @Override
    public long getLastScanned() {
        return this.lastScanned;
    }

    @Override
    public long getLastChanged() {
        return this.lastChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(CancelTask cancelTask) throws IOException {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        if (!this.hasScans()) {
            this.map = newMap;
            return;
        }
        this.scan(newMap, cancelTask);
        this.deleteOld(newMap);
        DatasetCollectionManager datasetCollectionManager = this;
        synchronized (datasetCollectionManager) {
            this.map = newMap;
            this.lastChanged = this.lastScanned = System.currentTimeMillis();
        }
        if (logger.isInfoEnabled()) {
            logger.debug(this.collectionName + ": initial scan found n datasets = " + this.map.keySet().size());
        }
        this.lm.sendEvent(new TriggerEvent(RESCAN));
    }

    public boolean rescanIfNeeded() throws IOException {
        if (this.isRescanNeeded()) {
            return this.rescan();
        }
        return false;
    }

    protected boolean hasScans() {
        return !this.scanList.isEmpty();
    }

    @Override
    public boolean isRescanNeeded() {
        if (!this.hasScans()) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.collectionName + ": rescan not needed, no scanners");
            }
            return false;
        }
        if (this.recheck == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.collectionName + ": rescan not needed, recheck null");
            }
            return false;
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.lastScanned);
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.collectionName + ": rescan not needed, last= " + lastCheckedDate + " now = " + now);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rescan() throws IOException {
        DatasetCollectionManager datasetCollectionManager;
        boolean changed;
        if (this.map == null) {
            this.scan(null);
            return this.hasScans();
        }
        Map<String, MFile> oldMap = this.map;
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.scan(newMap, null);
        int nnew = 0;
        for (MFile newDataset : newMap.values()) {
            String path = newDataset.getPath();
            MFile oldDataset = oldMap.get(path);
            if (oldDataset != null) {
                newMap.put(path, oldDataset);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(this.collectionName + ": rescan retains old Dataset= " + path);
                continue;
            }
            ++nnew;
            if (!logger.isDebugEnabled()) continue;
            logger.debug(this.collectionName + ": rescan found new Dataset= " + path);
        }
        int ndelete = 0;
        for (MFile oldDataset : oldMap.values()) {
            String path = oldDataset.getPath();
            MFile newDataset = (MFile)newMap.get(path);
            if (newDataset != null) continue;
            ++ndelete;
            if (!logger.isDebugEnabled()) continue;
            logger.debug(this.collectionName + ": rescan found deleted Dataset= " + path);
        }
        boolean bl = changed = nnew > 0 || ndelete > 0;
        if (changed) {
            datasetCollectionManager = this;
            synchronized (datasetCollectionManager) {
                this.map = newMap;
                this.lastChanged = this.lastScanned = System.currentTimeMillis();
            }
        }
        datasetCollectionManager = this;
        synchronized (datasetCollectionManager) {
            this.lastScanned = System.currentTimeMillis();
        }
        if (logger.isInfoEnabled()) {
            logger.info(this.collectionName + ": rescan at " + new Date() + ": nnew = " + nnew + " ndelete = " + ndelete);
        }
        if (changed) {
            this.lm.sendEvent(new TriggerEvent(RESCAN));
        }
        return changed;
    }

    @Override
    public List<MFile> getFiles() {
        if (this.map == null) {
            return null;
        }
        ArrayList<MFile> result = new ArrayList<MFile>(this.map.values());
        Collections.sort(result);
        return result;
    }

    @Override
    public Date extractRunDate(MFile mfile) {
        return this.dateExtractor == null ? null : this.dateExtractor.getDate(mfile);
    }

    public boolean hasDateExtractor() {
        return this.dateExtractor != null && !(this.dateExtractor instanceof DateExtractorNone);
    }

    protected void scan(Map<String, MFile> map, CancelTask cancelTask) throws IOException {
        if (null == controller) {
            controller = new ControllerOS();
        }
        for (MCollection mc : this.scanList) {
            Iterator<MFile> iter;
            Iterator<MFile> iterator = iter = mc.wantSubdirs() ? controller.getInventory(mc) : controller.getInventoryNoSubdirs(mc);
            if (iter == null) {
                logger.error(this.collectionName + ": DatasetCollectionManager Invalid collection= " + mc);
                continue;
            }
            while (iter.hasNext()) {
                MFile mfile = iter.next();
                mfile.setAuxInfo(mc.getAuxInfo());
                map.put(mfile.getPath(), mfile);
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("DatasetCollectionManager{ collectionName='%s' recheck=%s ", this.collectionName, this.recheck);
        for (MCollection mc : this.scanList) {
            f.format("%n dir=%s filter=%s", mc.getDirectoryName(), mc.getFileFilter());
        }
        return f.toString();
    }

    public int getProtoIndex() {
        int n = this.map.values().size();
        int protoIdx = 0;
        switch (this.protoChoice) {
            case First: {
                protoIdx = 0;
                break;
            }
            case Random: {
                Random r = new Random(System.currentTimeMillis());
                protoIdx = r.nextInt(n - 1);
                break;
            }
            case Penultimate: {
                protoIdx = Math.max(n - 2, 0);
                break;
            }
            case Latest: {
                protoIdx = Math.max(n - 1, 0);
            }
        }
        return protoIdx;
    }

    @Override
    public void resetProto() {
        this.lm.sendEvent(new TriggerEvent(PROTO));
    }

    private void createListenerManager() {
        this.lm = new ListenerManager("thredds.inventory.DatasetCollectionManager$TriggerListener", "thredds.inventory.DatasetCollectionManager$TriggerEvent", "handleCollectionEvent");
    }

    public void addEventListener(TriggerListener l) {
        this.lm.addListener(l);
    }

    public void removeEventListener(TriggerListener l) {
        this.lm.removeListener(l);
    }

    private void initMM() {
        if (this.collectionName == null) {
            return;
        }
        try {
            this.mm = new MetadataManager(this.collectionName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void deleteOld(Map<String, MFile> newMap) {
        if (this.mm == null && enableMetadataManager) {
            this.initMM();
        }
        if (this.mm != null) {
            this.mm.delete(newMap);
        }
    }

    @Override
    public void putMetadata(MFile file, String key, byte[] value) {
        if (this.mm == null) {
            this.initMM();
        }
        if (this.mm != null) {
            this.mm.put(file.getPath() + "#" + key, value);
        }
    }

    @Override
    public byte[] getMetadata(MFile file, String key) {
        if (this.mm == null) {
            this.initMM();
        }
        return this.mm == null ? null : this.mm.getBytes(file.getPath() + "#" + key);
    }

    static {
        enableMetadataManager = false;
    }

    public static interface TriggerListener {
        public void handleCollectionEvent(TriggerEvent var1);
    }

    public class TriggerEvent
    extends EventObject {
        private String message;

        TriggerEvent(String message) {
            super(DatasetCollectionManager.this);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

