/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.noaa;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayScalar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.unidata.io.RandomAccessFile;

public class StructureDataRegexp
extends StructureData {
    protected Matcher matcher;

    public StructureDataRegexp(StructureMembers members, Matcher m) {
        super(members);
        this.matcher = m;
    }

    protected Object parse(DataType dt, VinfoField vinfo) throws NumberFormatException {
        return this.parse(dt, vinfo, vinfo.fldno);
    }

    protected Object parse(DataType dt, VinfoField vinfo, int fldno) throws NumberFormatException {
        String svalue;
        String string = svalue = fldno <= this.matcher.groupCount() ? this.matcher.group(fldno) : " ";
        if (dt == DataType.STRING || dt == DataType.CHAR) {
            return svalue.trim();
        }
        try {
            boolean isBlank;
            svalue = svalue.trim();
            boolean bl = isBlank = svalue.length() == 0;
            if (dt == DataType.DOUBLE) {
                return isBlank ? 0.0 : new Double(svalue);
            }
            if (dt == DataType.FLOAT) {
                float result = isBlank ? 0.0f : new Float(svalue).floatValue();
                return Float.valueOf(vinfo.hasScale ? result * vinfo.scale : result);
            }
            if (dt == DataType.INT) {
                return isBlank ? 0 : new Integer(svalue);
            }
            if (dt == DataType.LONG) {
                return isBlank ? 0L : new Long(svalue);
            }
        }
        catch (NumberFormatException e) {
            System.out.printf("  %d = <%s> %n", fldno, svalue);
            throw e;
        }
        return null;
    }

    @Override
    public Array getArray(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        if (m.getDataType() == DataType.STRING) {
            String result = this.matcher.group(f.fldno);
            return new ArrayObject(String.class, new int[0], new Object[]{result.trim()});
        }
        if (m.getDataType() == DataType.SEQUENCE) {
            return this.getArraySequence(m);
        }
        if (!m.isScalar()) {
            if (m.getDataType() == DataType.FLOAT) {
                float[] ja = this.getJavaArrayFloat(m);
                return Array.factory(DataType.FLOAT, m.getShape(), (Object)ja);
            }
            if (m.getDataType() == DataType.CHAR) {
                char[] ja = this.getJavaArrayChar(m);
                return Array.factory(DataType.CHAR, m.getShape(), (Object)ja);
            }
            if (m.getDataType() == DataType.BYTE) {
                byte[] ja = this.getJavaArrayByte(m);
                return Array.factory(DataType.BYTE, m.getShape(), (Object)ja);
            }
        }
        Object result = this.parse(m.getDataType(), f);
        if (m.getDataType() == DataType.CHAR) {
            return new ArrayChar((String)result);
        }
        return new ArrayScalar(result);
    }

    @Override
    public float convertScalarFloat(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return ((Number)this.parse(m.getDataType(), f)).floatValue();
    }

    @Override
    public double convertScalarDouble(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return ((Number)this.parse(m.getDataType(), f)).doubleValue();
    }

    @Override
    public int convertScalarInt(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return ((Number)this.parse(m.getDataType(), f)).intValue();
    }

    @Override
    public long convertScalarLong(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return ((Number)this.parse(m.getDataType(), f)).longValue();
    }

    @Override
    public double getScalarDouble(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return (Double)this.parse(m.getDataType(), f);
    }

    @Override
    public double[] getJavaArrayDouble(StructureMembers.Member m) {
        return new double[0];
    }

    @Override
    public float getScalarFloat(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        Object result = this.parse(m.getDataType(), f);
        return result instanceof Float ? ((Float)result).floatValue() : ((Double)result).floatValue();
    }

    @Override
    public float[] getJavaArrayFloat(StructureMembers.Member m) {
        int n = m.getSize();
        float[] result = new float[n];
        VinfoField f = (VinfoField)m.getDataObject();
        for (int i = 0; i < n; ++i) {
            result[i] = ((Float)this.parse(m.getDataType(), f, f.fldno + f.stride * i)).floatValue();
        }
        return result;
    }

    @Override
    public byte getScalarByte(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return (Byte)this.parse(m.getDataType(), f);
    }

    @Override
    public byte[] getJavaArrayByte(StructureMembers.Member m) {
        int n = m.getSize();
        byte[] result = new byte[n];
        VinfoField f = (VinfoField)m.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s = (String)this.parse(m.getDataType(), f, f.fldno + f.stride * i);
            result[i] = (byte)s.charAt(0);
        }
        return result;
    }

    @Override
    public int getScalarInt(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return (Integer)this.parse(m.getDataType(), f);
    }

    @Override
    public int[] getJavaArrayInt(StructureMembers.Member m) {
        return new int[0];
    }

    @Override
    public short getScalarShort(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return (Short)this.parse(m.getDataType(), f);
    }

    @Override
    public short[] getJavaArrayShort(StructureMembers.Member m) {
        return new short[0];
    }

    @Override
    public long getScalarLong(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return (Long)this.parse(m.getDataType(), f);
    }

    @Override
    public long[] getJavaArrayLong(StructureMembers.Member m) {
        return new long[0];
    }

    @Override
    public char getScalarChar(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        String result = (String)this.parse(m.getDataType(), f);
        return result.charAt(0);
    }

    @Override
    public char[] getJavaArrayChar(StructureMembers.Member m) {
        int n = m.getSize();
        char[] result = new char[n];
        VinfoField f = (VinfoField)m.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s = (String)this.parse(m.getDataType(), f, f.fldno + f.stride * i);
            result[i] = s.charAt(0);
        }
        return result;
    }

    @Override
    public String getScalarString(StructureMembers.Member m) {
        VinfoField f = (VinfoField)m.getDataObject();
        return (String)this.parse(m.getDataType(), f);
    }

    @Override
    public String[] getJavaArrayString(StructureMembers.Member m) {
        return new String[]{this.getScalarString(m)};
    }

    @Override
    public StructureData getScalarStructure(StructureMembers.Member m) {
        return null;
    }

    @Override
    public ArrayStructure getArrayStructure(StructureMembers.Member m) {
        return null;
    }

    @Override
    public ArraySequence getArraySequence(StructureMembers.Member m) {
        return null;
    }

    public static class VinfoField {
        int fldno;
        int stride = 4;
        float scale;
        boolean hasScale;

        public VinfoField(int fldno) {
            this.fldno = fldno;
        }
    }

    public static class Vinfo {
        RandomAccessFile rafile;
        StructureMembers sm;
        Pattern p;
        int nelems = -1;

        public Vinfo(RandomAccessFile raff, StructureMembers sm, Pattern p) {
            this.sm = sm;
            this.rafile = raff;
            this.p = p;
        }
    }
}

