/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.aggregation.AggregationUtility;
import org.gcube.documentstore.records.implementation.AggregatedField;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

public class AggregatedServiceUsageRecord
extends AbstractServiceUsageRecord
implements AggregatedUsageRecord<AggregatedServiceUsageRecord, ServiceUsageRecord> {
    private static final long serialVersionUID = 6387584974618335623L;
    @AggregatedField
    public static final String DURATION = "duration";
    @RequiredField
    @ValidLong
    @AggregatedField
    public static final String MAX_INVOCATION_TIME = "maxInvocationTime";
    @RequiredField
    @ValidLong
    @AggregatedField
    public static final String MIN_INVOCATION_TIME = "minInvocationTime";

    public AggregatedServiceUsageRecord() {
    }

    public AggregatedServiceUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedServiceUsageRecord(ServiceUsageRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        long duration = record.getDuration();
        this.setMinInvocationTime(duration);
        this.setMaxInvocationTime(duration);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    @Override
    public int getOperationCount() {
        return super.getOperationCount();
    }

    @Override
    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    public long getMaxInvocationTime() {
        return (Long)this.resourceProperties.get(MAX_INVOCATION_TIME);
    }

    public void setMaxInvocationTime(long maxInvocationTime) throws InvalidValueException {
        super.setResourceProperty(MAX_INVOCATION_TIME, Long.valueOf(maxInvocationTime));
    }

    public long getMinInvocationTime() {
        return (Long)this.resourceProperties.get(MIN_INVOCATION_TIME);
    }

    public void setMinInvocationTime(long minInvocationTime) throws InvalidValueException {
        this.setResourceProperty(MIN_INVOCATION_TIME, Long.valueOf(minInvocationTime));
    }

    @Override
    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    @Override
    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    @Override
    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    @Override
    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    protected long durationWeightedAverage(AggregatedServiceUsageRecord record) {
        long thisDuration = this.getDuration() * (long)this.getOperationCount();
        long recordDuration = record.getDuration() * (long)record.getOperationCount();
        long totalOperationCount = this.getOperationCount() + record.getOperationCount();
        return (thisDuration + recordDuration) / totalOperationCount;
    }

    @Override
    public AggregatedServiceUsageRecord aggregate(AggregatedServiceUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            long min;
            AggregationUtility<AggregatedServiceUsageRecord> aggregationUtility = new AggregationUtility<AggregatedServiceUsageRecord>(this);
            this.setDuration(this.durationWeightedAverage(record));
            long max = record.getMaxInvocationTime();
            if (max > this.getMaxInvocationTime()) {
                this.setMaxInvocationTime(max);
            }
            if ((min = record.getMinInvocationTime()) < this.getMinInvocationTime()) {
                this.setMinInvocationTime(min);
            }
            aggregationUtility.aggregate(record);
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex);
        }
        return this;
    }

    @Override
    public AggregatedServiceUsageRecord aggregate(ServiceUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedServiceUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex);
        }
    }

    @Override
    public boolean isAggregable(AggregatedServiceUsageRecord record) throws NotAggregatableRecordsExceptions {
        AggregationUtility<AggregatedServiceUsageRecord> aggregationUtility = new AggregationUtility<AggregatedServiceUsageRecord>(this);
        return aggregationUtility.isAggregable(record);
    }

    @Override
    public boolean isAggregable(ServiceUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.isAggregable(new AggregatedServiceUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex);
        }
    }

    @Override
    public Class<ServiceUsageRecord> getAggregable() {
        return ServiceUsageRecord.class;
    }
}

