/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.accounting;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.contentmanager.storageserver.accounting.Report;
import org.gcube.contentmanager.storageserver.parse.utils.DateUtils;
import org.gcube.documentstore.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportAccountingImpl
implements Report {
    private static final String DEFAULT_PRODUCTION_ROOT_SCOPE = "d4science.research-infrastructures.eu";
    private static final String DEFAULT_PRODUCTION_PROVIDER_URI = "data.d4science.org";
    final Logger logger = LoggerFactory.getLogger(ReportAccountingImpl.class);
    public AccountingPersistence accountingPersistence;
    private String providerUri;

    @Override
    public void init() {
        this.accountingPersistence = AccountingPersistenceFactory.getPersistence();
    }

    @Override
    public StorageUsageRecord setGenericProperties(StorageUsageRecord sur, String resourceType, String consumerId, String resourceScope, String creationTime, String lastAccess, String owner, String operation, String size) {
        this.logger.trace("set accounting generic properties:  operation: " + operation + " resourceType: " + resourceType + " consumerId " + consumerId + " scope: " + resourceScope + " creationTime " + creationTime + " lastAccess " + lastAccess + " owner " + owner);
        if (this.accountingPersistence == null) {
            this.init();
        }
        if (sur == null) {
            sur = new StorageUsageRecord();
        }
        try {
            sur.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            sur.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            if (consumerId != null) {
                sur.setConsumerId(consumerId);
            }
            if (resourceScope != null) {
                sur.setResourceScope(resourceScope);
                sur = this.setProviderUri(sur, resourceScope);
            }
            if (owner != null) {
                sur.setResourceOwner(owner);
            }
            if (operation != null) {
                AbstractStorageUsageRecord.OperationType accountingOperation = this.convertOperation(operation);
                this.logger.debug("operation converted: " + (Object)((Object)accountingOperation));
                sur.setOperationType(accountingOperation);
            }
            if (size != null) {
                sur.setDataVolume(Long.parseLong(size));
            }
        }
        catch (InvalidValueException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.logger.debug("generic fields completed ");
        return sur;
    }

    protected StorageUsageRecord setProviderUri(StorageUsageRecord sur, String resourceScope) throws InvalidValueException, URISyntaxException {
        this.logger.debug("retrieve root scope from  resourceScope " + resourceScope);
        String rootScope = resourceScope.substring(1);
        this.logger.debug("rootScope extrapolated is: " + rootScope);
        if (sur == null) {
            sur = new StorageUsageRecord();
        }
        sur.setProviderURI(new URI(this.buildProviderURI(resourceScope)));
        return sur;
    }

    protected String buildProviderURI(String resourceScope) {
        String rootScope = resourceScope.substring(1);
        if (resourceScope.contains(DEFAULT_PRODUCTION_ROOT_SCOPE)) {
            this.providerUri = DEFAULT_PRODUCTION_PROVIDER_URI;
            return this.providerUri;
        }
        if (rootScope.indexOf("/") != -1) {
            int i = rootScope.indexOf("/");
            rootScope = rootScope.substring(0, i);
            this.logger.debug("removed sub scopes. rootScope: " + rootScope);
        }
        this.providerUri = "data." + rootScope + ".org";
        this.logger.debug("set provider uri: " + this.providerUri);
        return this.providerUri;
    }

    @Override
    public StorageUsageRecord setSpecificProperties(StorageUsageRecord sur, String filePath, String dataType, String callerIP, String id) {
        this.logger.trace("set accounting properties:  remotePath: " + filePath + " dataType " + dataType + " callerIP " + callerIP + " resoruceURI " + id);
        if (sur == null) {
            sur = new StorageUsageRecord();
        }
        try {
            if (filePath != null) {
                sur.setResourceProperty("remotePath", (Serializable)((Object)filePath));
            }
            if (callerIP != null) {
                sur.setResourceProperty("callerIP", (Serializable)((Object)callerIP));
            }
            if (id != null) {
                try {
                    sur.setResourceURI(new URI(id));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        return sur;
    }

    private AbstractStorageUsageRecord.OperationType convertOperation(String operation) {
        this.logger.debug("converting operation: " + operation);
        switch (operation) {
            case "UPLOAD": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "DELETE": {
                return AbstractStorageUsageRecord.OperationType.DELETE;
            }
            case "MOVE": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "COPY": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "MOVE_DIR": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "COPY_DIR": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "DOWNLOAD": {
                return AbstractStorageUsageRecord.OperationType.READ;
            }
        }
        throw new RuntimeException("The operation " + operation + " is not converted or supported");
    }

    @Override
    public void printRecord(StorageUsageRecord record) {
        this.logger.info(" accounting properties: \n\t owner: " + record.getResourceOwner() + "\n\t scope " + record.getResourceScope() + "\n\t type " + (Object)((Object)record.getOperationType()) + "\n\t consumer  " + record.getConsumerId() + "\n\t file  " + record.getResourceProperty("remotePath") + "\n\t size  " + record.getDataVolume() + "\n\t caller  " + record.getResourceProperty("callerIP") + "\n\t id  " + record.getId() + "\n\t resourceURI  " + record.getResourceURI() + "\n\t providerURI  " + record.getProviderURI() + "\n\t Now  " + DateUtils.now("dd MM yyyy 'at' hh:mm:ss z") + "\n\t operation " + (Object)((Object)record.getOperationType()));
    }

    @Override
    public void send(StorageUsageRecord sur) {
        this.accountingPersistence = AccountingPersistenceFactory.getPersistence();
        if (this.accountingPersistence != null) {
            this.logger.debug("report sending...");
            try {
                this.accountingPersistence.account(sur);
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            this.logger.info(" report send:  \n\t" + sur);
        } else {
            this.logger.error("Problem on building accounting record: Factory Object is null ");
        }
    }

    public String getProviderUri() {
        return this.providerUri;
    }
}

