/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.beans.text.i18n;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.fao.vrmf.core.impl.design.patterns.pair.NameValuePair;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

public class BundleManager
extends ImmutableLoggingClient {
    private final Locale _locale;
    private final Collection<ResourceBundle> _bundles;
    private static final String DEFAULT_PLACEHOLDER = "{}";
    private static final String NULL_SUBSTITUTE = "<NULL>";
    private final ResourceBundle.Control _UTF8PropertyResourceBundleController;

    private BundleManager(Locale locale) {
        this._UTF8PropertyResourceBundleController = new ResourceBundle.Control(){

            @Override
            public List<String> getFormats(String baseName) {
                if (baseName == null) {
                    throw new NullPointerException();
                }
                return Arrays.asList("properties");
            }

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                if (baseName == null || locale == null || format == null || loader == null) {
                    throw new NullPointerException();
                }
                PropertyResourceBundle bundle = null;
                if (format.equals("properties")) {
                    String bundleName = this.toBundleName(baseName, locale);
                    String resourceName = this.toResourceName(bundleName, format);
                    InputStreamReader r = new InputStreamReader(loader.getResourceAsStream(resourceName), "UTF-8");
                    bundle = new PropertyResourceBundle(r);
                    ((Reader)r).close();
                }
                return bundle;
            }
        };
        this._locale = locale == null ? Locale.getDefault() : locale;
        this._bundles = new ArrayList<ResourceBundle>();
    }

    public BundleManager(Locale locale, String ... bundleNames) {
        this(locale);
        assert (bundleNames != null) : "Bundle names cannot be NULL";
        assert (bundleNames.length > 0) : "Bundle names cannot be empty";
        String[] stringArray = bundleNames;
        int n = bundleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            try {
                this._bundles.add(ResourceBundle.getBundle(bundleName, this._locale, Thread.currentThread().getContextClassLoader(), this._UTF8PropertyResourceBundleController));
            }
            catch (MissingResourceException MRe) {
                this._log.error("Unable to initialize bundle manager for locale '{}' and bundle name '{}'. Unexpected {} caught [ {} ]", new Object[]{locale.getLanguage(), bundleName, MRe.getClass().getSimpleName(), MRe.getMessage()});
                this._log.error("Unexpected exception caught", (Throwable)MRe);
            }
            ++n2;
        }
    }

    public BundleManager(Locale locale, String bundleName) {
        String[] stringArray;
        if (bundleName == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = bundleName;
        }
        this(locale, stringArray);
    }

    public BundleManager(String bundleName) {
        this(Locale.getDefault(), bundleName);
    }

    private String wrapTextID(String textID) {
        return textID == null ? null : "!! " + textID + " !!";
    }

    public String getText(String textID) {
        if (this._bundles == null || this._bundles.isEmpty()) {
            this._log.warn("No bundle available: returning entry ID as value for '{}'", (Object)textID);
            return this.wrapTextID(textID);
        }
        for (ResourceBundle bundle : this._bundles) {
            try {
                return bundle.getString(textID);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this._log.warn("No data available for entry ID in any of the bundles: returning entry ID as value for '{}'", (Object)textID);
        return this.wrapTextID(textID);
    }

    public <S extends Serializable> String getText(String textID, Collection<S> parameters) {
        return this.getTextWithCustomPlaceholder(textID, DEFAULT_PLACEHOLDER, parameters.toArray(new Serializable[parameters.size()]));
    }

    public <S extends Serializable> String getText(String textID, S ... parameters) {
        return this.getTextWithCustomPlaceholder(textID, DEFAULT_PLACEHOLDER, (Serializable[])parameters);
    }

    public <S extends Serializable> String getTextWithCustomPlaceholder(String textID, String placeholder, S ... parameters) {
        String text = this.getText(textID);
        if (text == null || "".equals(text)) {
            return text;
        }
        if (placeholder == null || "".equals(placeholder)) {
            this._log.warn("Invalid placeholder for parameter substitution (\"{}\"). Using \"{}\" instead...", (Object)placeholder, (Object)DEFAULT_PLACEHOLDER);
            placeholder = DEFAULT_PLACEHOLDER;
        }
        int numPlaceholders = 0;
        int index = 0;
        while ((index = text.indexOf(placeholder, index)) != -1) {
            ++numPlaceholders;
            index += placeholder.length();
        }
        int setParameters = 0;
        S[] SArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            S parameter = SArray[n2];
            if (parameter != null) {
                ++setParameters;
            }
            ++n2;
        }
        if (numPlaceholders > setParameters) {
            this._log.warn("Label: {} - {} placeholders vs. {} provided parameters: some placeholder will remain as it is...", new Object[]{textID, numPlaceholders, setParameters});
        } else if (numPlaceholders < setParameters) {
            this._log.warn("Label: {} - {} placeholders vs. {} provided parameters: some parameter will not be used...", new Object[]{textID, numPlaceholders, setParameters});
        }
        index = 0;
        SArray = parameters;
        n = parameters.length;
        n2 = 0;
        while (n2 < n) {
            S param = SArray[n2];
            index = text.indexOf(placeholder);
            if (index >= 0) {
                text = String.valueOf(text.substring(0, index)) + (param == null ? NULL_SUBSTITUTE : param.toString()) + text.substring(index + placeholder.length());
            }
            ++n2;
        }
        return text;
    }

    public String[] getLabels() {
        TreeSet<String> labels = new TreeSet<String>();
        for (ResourceBundle bundle : this._bundles) {
            labels.addAll(bundle.keySet());
        }
        return labels.toArray(new String[labels.size()]);
    }

    public NameValuePair[] getLabelsAndValues() {
        ArrayList<NameValuePair> labelsAndValues = new ArrayList<NameValuePair>();
        String[] stringArray = this.getLabels();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            labelsAndValues.add(new NameValuePair(label, (Serializable)((Object)this.getText(label))));
            ++n2;
        }
        return labelsAndValues.toArray(new NameValuePair[labelsAndValues.size()]);
    }

    public String toJSON() {
        StringBuilder JSON = new StringBuilder();
        JSON.append("{\n");
        NameValuePair[] nameValuePairArray = this.getLabelsAndValues();
        int n = nameValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            NameValuePair data = nameValuePairArray[n2];
            JSON.append("\t").append("\"").append(data.getName().replace("\"", "\\\"")).append("\"");
            JSON.append(": ").append("\"").append(((String)((Object)data.getValue())).replace("\"", "\\\"")).append("\"").append(",\n");
            ++n2;
        }
        JSON.append("\t_padder: \"\" //TO BE REMOVED...\n");
        JSON.append("}");
        return JSON.toString();
    }
}

