/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.patterns.data.partitioners;

import java.util.Collection;
import org.fao.fi.comet.core.model.matchlets.Matchlet;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.patterns.data.partitioners.SpeciesDataPartitioner;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public class LengthBasedSpeciesDataPartitioner
extends SpeciesDataPartitioner {
    public static final int INCLUDE_EVERYTHING = -1;
    private int _maxLength = -1;

    public LengthBasedSpeciesDataPartitioner() {
    }

    public LengthBasedSpeciesDataPartitioner(int maxLength) {
        this.setMaxLength(maxLength);
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int maxLength) {
        AssertionUtils.$true(maxLength >= -1, "The maximum length parameter must be greater than or equal to {} (actually: {})", -1, maxLength);
        this._maxLength = maxLength;
    }

    @Override
    public boolean include(ReferenceSpeciesData source, ReferenceSpeciesData target, Collection<? extends Matchlet<ReferenceSpeciesData, ?, ReferenceSpeciesData, ?>> matchlets) {
        boolean keepByScientificName;
        if (this._maxLength == -1) {
            return true;
        }
        String sourceGenus = source.getGenus();
        String targetGenus = target.getGenus();
        String sourceScientificName = source.getScientificName();
        String sourceSpecies = source.getSpecies();
        String targetSpecies = target.getSpecies();
        String targetScientificName = target.getScientificName();
        boolean bothGenuses = sourceGenus != null && targetGenus != null;
        boolean bothSpecies = sourceSpecies != null && targetSpecies != null;
        boolean keepByGenuses = !bothGenuses || Math.abs(sourceGenus.length() - targetGenus.length()) <= this._maxLength;
        boolean keepBySpecies = !bothSpecies || Math.abs(sourceSpecies.length() - targetSpecies.length()) <= this._maxLength;
        boolean bl = keepByScientificName = !bothSpecies && Math.abs(sourceScientificName.length() - targetScientificName.length()) <= this._maxLength * 2 + 1;
        return keepByGenuses && keepBySpecies || keepByScientificName;
    }
}

