/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.models.application.messaging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import org.fao.vrmf.core.helpers.singletons.io.EncryptionUtils;
import org.fao.vrmf.core.models.application.messaging.MessagePriority;
import org.fao.vrmf.core.models.application.messaging.MessageType;

public class Message
implements Serializable {
    private static final long serialVersionUID = 6167243292419724171L;
    private MessagePriority _priority;
    private MessageType _type;
    private String _targetHost;
    private String _targetApplication;
    private String _targetUserId;
    private String _targetSessionId;
    private String _text;
    private String _senderHost;
    private String _senderApplication;
    private String _senderUserId;
    private String _senderSessionId;
    private Date _timestamp = new Date();

    public Message() {
        this._type = MessageType.INFO;
        this._priority = MessagePriority.NORMAL;
    }

    public Message(String text, MessagePriority priority, MessageType type) {
        this();
        this._text = text;
        this._priority = priority;
        this._type = type;
    }

    public final String getMessageId() {
        String asString = this.toString();
        try {
            return EncryptionUtils.getMD5Sum(asString);
        }
        catch (Throwable t) {
            return asString;
        }
    }

    public MessagePriority getPriority() {
        return this._priority;
    }

    public void setPriority(MessagePriority priority) {
        this._priority = priority;
    }

    public MessageType getType() {
        return this._type;
    }

    public void setType(MessageType type) {
        this._type = type;
    }

    public String getTargetHost() {
        return this._targetHost;
    }

    public void setTargetHost(String targetHost) {
        this._targetHost = targetHost;
    }

    public String getTargetApplication() {
        return this._targetApplication;
    }

    public void setTargetApplication(String targetApplication) {
        this._targetApplication = targetApplication;
    }

    public String getTargetUserId() {
        return this._targetUserId;
    }

    public void setTargetUserId(String targetUserId) {
        this._targetUserId = targetUserId;
    }

    public String getTargetSessionId() {
        return this._targetSessionId;
    }

    public void setTargetSessionId(String targetSessionId) {
        this._targetSessionId = targetSessionId;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getSenderHost() {
        return this._senderHost;
    }

    public void setSenderHost(String senderHost) {
        this._senderHost = senderHost;
    }

    public String getSenderApplication() {
        return this._senderApplication;
    }

    public void setSenderApplication(String senderApplication) {
        this._senderApplication = senderApplication;
    }

    public String getSenderUserId() {
        return this._senderUserId;
    }

    public void setSenderUserId(String senderUserId) {
        this._senderUserId = senderUserId;
    }

    public String getSenderSessionId() {
        return this._senderSessionId;
    }

    public void setSenderSessionId(String senderSessionId) {
        this._senderSessionId = senderSessionId;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.hashCode()).append("@").append(this._type == null ? null : this._type._description).append(":").append(this._priority == null ? null : this._priority.getDescription()).append(":").append(this._timestamp).append(":").append(this._text);
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
        result = 31 * result + (this._senderApplication == null ? 0 : this._senderApplication.hashCode());
        result = 31 * result + (this._senderHost == null ? 0 : this._senderHost.hashCode());
        result = 31 * result + (this._senderSessionId == null ? 0 : this._senderSessionId.hashCode());
        result = 31 * result + (this._senderUserId == null ? 0 : this._senderUserId.hashCode());
        result = 31 * result + (this._targetApplication == null ? 0 : this._targetApplication.hashCode());
        result = 31 * result + (this._targetHost == null ? 0 : this._targetHost.hashCode());
        result = 31 * result + (this._targetSessionId == null ? 0 : this._targetSessionId.hashCode());
        result = 31 * result + (this._targetUserId == null ? 0 : this._targetUserId.hashCode());
        result = 31 * result + (this._text == null ? 0 : this._text.hashCode());
        result = 31 * result + (this._timestamp == null ? 0 : this._timestamp.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (this._priority != other._priority) {
            return false;
        }
        if (this._senderApplication == null ? other._senderApplication != null : !this._senderApplication.equals(other._senderApplication)) {
            return false;
        }
        if (this._senderHost == null ? other._senderHost != null : !this._senderHost.equals(other._senderHost)) {
            return false;
        }
        if (this._senderSessionId == null ? other._senderSessionId != null : !this._senderSessionId.equals(other._senderSessionId)) {
            return false;
        }
        if (this._senderUserId == null ? other._senderUserId != null : !this._senderUserId.equals(other._senderUserId)) {
            return false;
        }
        if (this._targetApplication == null ? other._targetApplication != null : !this._targetApplication.equals(other._targetApplication)) {
            return false;
        }
        if (this._targetHost == null ? other._targetHost != null : !this._targetHost.equals(other._targetHost)) {
            return false;
        }
        if (this._targetSessionId == null ? other._targetSessionId != null : !this._targetSessionId.equals(other._targetSessionId)) {
            return false;
        }
        if (this._targetUserId == null ? other._targetUserId != null : !this._targetUserId.equals(other._targetUserId)) {
            return false;
        }
        if (this._text == null ? other._text != null : !this._text.equals(other._text)) {
            return false;
        }
        if (this._timestamp == null ? other._timestamp != null : !this._timestamp.equals(other._timestamp)) {
            return false;
        }
        return this._type == other._type;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        if (this._type == null) {
            this._type = MessageType.INFO;
        }
        if (this._priority == null) {
            this._priority = MessagePriority.NORMAL;
        }
        if (this._timestamp == null) {
            this._timestamp = new Date();
        }
    }
}

