/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.processors.impl;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import org.fao.vrmf.core.tools.lexical.processors.AbstractLexicalProcessor;

public class DiacriticsProcessor
extends AbstractLexicalProcessor {
    private static final String DIACRITICS_D = "\u00d0";
    private static final String DIACRITICS_E = "\u0388";
    private static final String DIACRITICS_H = "\u0126";
    private static final String DIACRITICS_I = "\u03aa";
    private static final String DIACRITICS_L = "\u0141";
    private static final String DIACRITICS_O = "\u00d8";
    private static final String DIACRITICS_SS = "\u00df";
    private static final String DIACRITICS_AE = "\u00c6";
    private static final String DIACRITICS_OE = "\u0152";
    private static final Map<String, String> DIACRITICS_MAP = new HashMap<String, String>();

    static {
        DIACRITICS_MAP.put("AE", DIACRITICS_AE);
        DIACRITICS_MAP.put("D", DIACRITICS_D);
        DIACRITICS_MAP.put("E", DIACRITICS_E);
        DIACRITICS_MAP.put("H", DIACRITICS_H);
        DIACRITICS_MAP.put("I", DIACRITICS_I);
        DIACRITICS_MAP.put("L", DIACRITICS_L);
        DIACRITICS_MAP.put("O", DIACRITICS_O);
        DIACRITICS_MAP.put("OE", DIACRITICS_OE);
        DIACRITICS_MAP.put("SS", DIACRITICS_SS);
    }

    @Override
    protected String doProcess(String toProcess) {
        String mapping = null;
        for (String letter : DIACRITICS_MAP.keySet()) {
            mapping = DIACRITICS_MAP.get(letter);
            toProcess = toProcess.replaceAll(mapping, letter).replaceAll(mapping.toLowerCase(), letter.toLowerCase());
        }
        toProcess = Normalizer.normalize(toProcess, Normalizer.Form.NFD);
        toProcess = toProcess.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return toProcess;
    }
}

