/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.patterns.data.providers.impl.basic;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.core.patterns.data.providers.SizeAwareDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.StreamingSeekableDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.impl.DataProviderSkeleton;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public class StreamableSeekableChunkedDelegateDataProvider<ENTITY extends Serializable>
extends DataProviderSkeleton<ENTITY>
implements SizeAwareDataProvider<ENTITY> {
    private final StreamingSeekableDataProvider<ENTITY> _backingProvider;
    private final int _from;
    private final int _to;

    public StreamableSeekableChunkedDelegateDataProvider(String providerID, StreamingSeekableDataProvider<ENTITY> backingProvider, int from, int to) {
        super(providerID);
        AssertionUtils.$nNull(backingProvider, "Backing provider cannot be NULL", new Object[0]);
        AssertionUtils.$pos(from, "Starting position must be greater than zero (currently: {})", from);
        AssertionUtils.$pos(to, "Ending position must be greater than zero (currently: {})", to);
        AssertionUtils.$true(from <= to, "Starting position ({}) must be greater than (or equal to) the ending position ({})", from, to);
        int dataSize = backingProvider.getAvailableDataSize();
        AssertionUtils.$true(to <= dataSize, "Ending position ({}) must be lower than or equal to the provider data size ({})", to, dataSize);
        this._from = from;
        this._to = to;
        this._backingProvider = backingProvider;
    }

    @Override
    public Iterator<ProvidedData<ENTITY>> iterator() {
        final StreamableSeekableChunkedDelegateDataProvider $this = this;
        return new Iterator<ProvidedData<ENTITY>>(){
            private final int _currentPos;
            private final Iterator<ProvidedData<ENTITY>> _realIterator;
            {
                this._currentPos = streamableSeekableChunkedDelegateDataProvider2._from;
                this._realIterator = streamableSeekableChunkedDelegateDataProvider2._backingProvider.seek(streamableSeekableChunkedDelegateDataProvider2._from).iterator();
            }

            @Override
            public boolean hasNext() {
                return this._realIterator.hasNext() && this._currentPos < $this._to;
            }

            @Override
            public ProvidedData<ENTITY> next() {
                if (this.hasNext()) {
                    return this._realIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int getAvailableDataSize() {
        return this._to - this._from + 1;
    }

    @Override
    protected final void doReleaseResources() throws Exception {
        this._backingProvider.releaseResources();
    }
}

