/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species;

import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.domain.species.CommonReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.model.SpeciesData;
import org.fao.fi.comet.domain.species.model.VernacularNameData;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public class ReferenceSpeciesFactory
extends CommonReferenceSpeciesFactory {
    public static final ReferenceSpeciesData newInstance(String name) {
        return ReferenceSpeciesFactory.newInstance(name, null);
    }

    public static final ReferenceSpeciesData newInstance(String scientificName, String author) {
        ReferenceSpeciesData data = new ReferenceSpeciesData();
        data.setId(scientificName);
        data.setScientificName(scientificName);
        data.setAuthor(author);
        data.setGenericCName(new TypedComplexName("generic", scientificName, null, null, null));
        return data;
    }

    public static final ReferenceSpeciesData newInstance(String dataSource, String id, String kingdom, String phylum, String klass, String order, String family, String genus, String species, String scientificName, VernacularNameData[] vernacularNames, String author) {
        ReferenceSpeciesData data = new ReferenceSpeciesData();
        data.setDataSource(dataSource);
        data.setId(id);
        data.setKingdom(kingdom);
        data.setPhylum(phylum);
        data.setKlass(klass);
        data.setOrder(order);
        data.setFamily(family);
        data.setGenus(genus);
        data.setSpecies(species);
        data.setScientificName(StringUtils.rawTrim(String.valueOf(genus == null ? "" : genus) + (species == null ? "" : " " + species)));
        data.setVernacularNames(vernacularNames);
        data.setAuthor(author);
        return data;
    }

    public static final ReferenceSpeciesData newInstance(SpeciesData speciesData) {
        return ReferenceSpeciesFactory.newInstance(speciesData.getDataSource(), speciesData.getId(), speciesData.getKingdom(), speciesData.getPhylum(), speciesData.getKlass(), speciesData.getOrder(), speciesData.getFamily(), speciesData.getGenus(), speciesData.getSpecies(), speciesData.getScientificName(), speciesData.getVernacularNames(), speciesData.getAuthor());
    }
}

