/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.services.invokers.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.fao.vrmf.core.services.AsynchronousService;
import org.fao.vrmf.core.services.invokers.AsynchronousServicesInvokerAndManager;
import org.fao.vrmf.core.services.invokers.impl.AbstractAsynchronousServiceInvoker;
import org.fao.vrmf.core.services.request.ServiceRequest;
import org.fao.vrmf.core.services.response.ServiceResponse;
import org.slf4j.Logger;

public abstract class AbstractAsynchronousServiceInvokerAndManager<REQ extends ServiceRequest, RES extends ServiceResponse, SER extends AsynchronousService<REQ, RES>>
extends AbstractAsynchronousServiceInvoker<REQ, RES, SER>
implements AsynchronousServicesInvokerAndManager<REQ, RES, SER> {
    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.updateAsynchronousServiceProvidersAvailability();
        int timeout = -1;
        for (AsynchronousService provider : super.getServiceProviders()) {
            if (provider == null || provider.getServiceTimeout() <= timeout) continue;
            timeout = provider.getServiceTimeout();
        }
        int effectiveTimeout = 5000;
        if (timeout < 5000) {
            if (timeout == -1) {
                this._log.warn("Unable to determine maximum service timeout: using {} mSec. as base for the service availability polling frequency...", (Object)effectiveTimeout);
            } else {
                this._log.warn("Low maximum service timeout ({} mSec): using {} mSec. as base for the service availability polling frequency instead...", (Object)timeout, (Object)effectiveTimeout);
            }
        } else {
            effectiveTimeout = timeout;
        }
        timeout = effectiveTimeout * 10;
        this._log.info("Scheduling service providers availability check every {} mSec. (base frequency was {} mSec)", (Object)timeout, (Object)effectiveTimeout);
        this.startAvailabilityCheckPoller(timeout);
    }

    @Override
    public void updateAsynchronousServiceProvidersAvailability() {
        List allProviders = super.getServiceProviders();
        if (allProviders == null || allProviders.isEmpty()) {
            this._log.warn("No service providers to check for availability... :|");
            return;
        }
        this._log.info("Polling availability for {} service providers...", (Object)allProviders.size());
        int polled = 0;
        for (AsynchronousService provider : allProviders) {
            try {
                if (provider != null) {
                    this._log.info("Checking availability of service provider {}...", (Object)provider.getClass().getSimpleName());
                    long start = System.currentTimeMillis();
                    provider.setAvailable(provider.checkAvailability(provider.getServiceTimeout()));
                    provider.setLastCheck(start);
                    long end = System.currentTimeMillis();
                    ++polled;
                    this._log.info("Availability of service provider {} has been checked in {} mSec", (Object)provider.getClass().getSimpleName(), (Object)(end - start));
                    continue;
                }
                this._log.warn("Skipping availability check of a NULL service provider...");
            }
            catch (Throwable t) {
                this._log.warn("Unable to check availability of service provider {}: {} [ {} ]", new Object[]{provider.getClass().getSimpleName(), t.getClass().getSimpleName(), t.getMessage()});
                provider.setAvailable(false);
            }
        }
        this._log.info("Completed availability polling of {} out of {} service providers", (Object)polled, (Object)allProviders.size());
        int counter = 1;
        for (AsynchronousService provider : allProviders) {
            if (provider == null) {
                this._log.warn("Service provider #{} is currently NULL", (Object)counter++);
                continue;
            }
            if (provider.isAvailable()) {
                this._log.info("Service provider #{} [ {} ] is currently available", (Object)counter++, (Object)provider.getClass().getSimpleName());
                continue;
            }
            this._log.warn("Service provider #{} [ {} ] is currently unavailable", (Object)counter++, (Object)provider.getClass().getSimpleName());
        }
    }

    @Override
    public final List<SER> getAvailableServiceProviders() {
        List allProviders = super.getServiceProviders();
        if (allProviders == null) {
            return null;
        }
        if (allProviders.isEmpty()) {
            return allProviders;
        }
        ArrayList<AsynchronousService> availableProviders = new ArrayList<AsynchronousService>();
        for (AsynchronousService provider : allProviders) {
            if (provider == null || !provider.isAvailable()) continue;
            availableProviders.add(provider);
        }
        return availableProviders.isEmpty() ? null : availableProviders;
    }

    private ScheduledFuture<?> startAvailabilityCheckPoller(int timeout) {
        final long $delay = Math.round(super.getServiceProviders().size() * timeout);
        final AbstractAsynchronousServiceInvokerAndManager $this = this;
        final Logger $log = this._executorsLog;
        return Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    long start = System.currentTimeMillis();
                    $log.info("Starting Asynchronous Service Invoker and Manager checker polling with thread {} [ delay: {} ]...", (Object)Thread.currentThread().getName(), (Object)$delay);
                    $this.updateAsynchronousServiceProvidersAvailability();
                    long end = System.currentTimeMillis();
                    $log.info("Completed Asynchronous Service Invoker and Manager checker polling with thread {} in {} mSec", (Object)Thread.currentThread().getName(), (Object)(end - start));
                }
                catch (Throwable t) {
                    $log.error("An error occurred while executing scheduled Asynchronous Service Invoker and Manager checker polling: {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
                }
            }
        }, $delay, $delay, TimeUnit.MILLISECONDS);
    }
}

