/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.extensions.collections.impl;

import java.util.Collection;
import java.util.Iterator;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheFacade;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.impl.design.patterns.cache.simple.SimpleCacheFacade;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

public abstract class LazyCollection<ID, ENTRY>
extends ImmutableLoggingClient
implements Collection<ENTRY> {
    protected CacheFacade<ID, ENTRY> _backingCache = null;

    public LazyCollection() {
        this._backingCache = new SimpleCacheFacade<ID, ENTRY>(ClassUtils.getThis(this));
    }

    public LazyCollection(CacheFacade<ID, ENTRY> backingCache) {
        assert (backingCache != null) : "The backign cache cannot be NULL";
        this._backingCache = backingCache;
    }

    @Override
    public int size() {
        return this.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Iterator<ENTRY> iterator() {
        return new Iterator<ENTRY>(){
            private Iterator<ID> _indexIterator;
            {
                this._indexIterator = LazyCollection.this.getIndexes().iterator();
            }

            @Override
            public boolean hasNext() {
                return this._indexIterator.hasNext();
            }

            @Override
            public ENTRY next() {
                return LazyCollection.this.getElement(this._indexIterator.next());
            }

            @Override
            public void remove() {
                throw new RuntimeException("Unimplemented");
            }
        };
    }

    @Override
    public Object[] toArray() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean add(ENTRY e) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean addAll(Collection<? extends ENTRY> c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Unimplemented");
    }

    protected abstract int getSize();

    protected abstract Collection<ID> getIndexes();

    protected abstract ENTRY doGetElement(ID var1);

    private ENTRY getElement(ID index) {
        ENTRY object = this._backingCache.get(index);
        if (object == null) {
            this._log.debug("MISS: Retrieving element with index " + index + " from persistency");
            object = this.doGetElement(index);
            if (object != null) {
                this._backingCache.put(index, object);
            } else {
                this._log.warn("Element with index " + index + " cannot be retrieved from persistency (returns NULL)");
            }
        } else {
            this._log.debug("HIT : Element with index " + index + " is already cached");
        }
        return object;
    }
}

