/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.impl.design.patterns.cache;

import java.io.Serializable;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheFacade;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheListener;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

public abstract class AbstractCacheEventListener<K, V>
extends ImmutableLoggingClient
implements Serializable,
CacheListener<K, V> {
    private static final long serialVersionUID = 252234758998394757L;
    protected CacheFacade<K, V> _cache;

    public AbstractCacheEventListener(CacheFacade<K, V> cache) {
        assert (cache != null);
        this._log.info("Initializing " + this + " with backing cache " + cache);
        this._cache = cache;
    }

    protected final CacheFacade<K, V> getCache() {
        return this._cache;
    }

    protected final String getLogPreamble() {
        return String.valueOf(ClassUtils.getThis(this)) + ": ";
    }

    @Override
    public abstract void entryAdded(CacheFacade<K, V> var1, K var2, V var3);

    @Override
    public abstract void entryUpdated(CacheFacade<K, V> var1, K var2, V var3, V var4);

    @Override
    public abstract void entryRemoved(CacheFacade<K, V> var1, K var2, V var3);

    @Override
    public abstract void entryEvicted(CacheFacade<K, V> var1, K var2, V var3);

    @Override
    public abstract void entryExpired(CacheFacade<K, V> var1, K var2, V var3);

    @Override
    public abstract void cacheCleared(CacheFacade<K, V> var1);
}

