/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.processors.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.vrmf.core.tools.lexical.helpers.RomanNumbersConverter;
import org.fao.vrmf.core.tools.lexical.processors.AbstractLexicalProcessor;

public class RomanNumbersProcessor
extends AbstractLexicalProcessor {
    private static final Pattern ROMAN_NUMBERS_PATTERN_START = Pattern.compile("^((X{0,3}(IX|IV|V?I{0,3})))\\s(.+)");
    private static final Pattern ROMAN_NUMBERS_PATTERN = Pattern.compile("(.*\\s)((X{0,3}(IX|IV|V?I{0,3})))\\s(.+)");
    private static final Pattern ROMAN_NUMBERS_PATTERN_END = Pattern.compile("(.*\\s)((X{0,3}(IX|IV|V?I{0,3})))$");

    @Override
    public boolean mustProcess(String toProcess) {
        return super.mustProcess(toProcess) && (ROMAN_NUMBERS_PATTERN.matcher(toProcess).matches() || ROMAN_NUMBERS_PATTERN_START.matcher(toProcess).matches() || ROMAN_NUMBERS_PATTERN_END.matcher(toProcess).matches());
    }

    @Override
    protected String doProcess(String toProcess) {
        StringBuilder processed = new StringBuilder();
        Matcher r = ROMAN_NUMBERS_PATTERN_START.matcher(toProcess);
        if (r.matches()) {
            processed.append(String.valueOf(RomanNumbersConverter.toLong(r.group(1)))).append(" ").append(r.group(4));
        } else {
            r = ROMAN_NUMBERS_PATTERN.matcher(toProcess);
            if (r.matches()) {
                processed.append(r.group(1)).append(String.valueOf(RomanNumbersConverter.toLong(r.group(2)))).append(" ").append(r.group(5));
            } else {
                r = ROMAN_NUMBERS_PATTERN_END.matcher(toProcess);
                if (r.matches()) {
                    processed.append(r.group(1)).append(String.valueOf(RomanNumbersConverter.toLong(r.group(2))));
                }
            }
        }
        return processed.toString();
    }
}

