/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.preprocess;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.regex.Matcher;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.fao.fi.comet.domain.species.tools.preprocess.post.PostparsingRules;
import org.fao.fi.comet.domain.species.tools.preprocess.pre.PreparsingRules;
import org.fao.vrmf.core.helpers.singletons.io.resources.ResourcesUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.JAXBUtils;

public final class RulesetManager {
    public static String DEFAULT_PREPARSING_RULESET_PACKAGE = "org.fao.fi.comet.domain.species.tools.preprocess.resources.pre";
    public static String DEFAULT_POSTPARSING_RULESET_PACKAGE = "org.fao.fi.comet.domain.species.tools.preprocess.resources.post";

    private RulesetManager() {
    }

    private static <R extends Serializable> R materialize(Class<R> clazz, String xml) throws IOException, JAXBException {
        try {
            return JAXBUtils.fromXML(clazz, xml);
        }
        catch (UnmarshalException Ue) {
            if (Ue.getLinkedException() != null && Ue.getLinkedException().getCause() != null) {
                throw new RuntimeException(Ue.getLinkedException().getCause().getMessage());
            }
            throw Ue;
        }
    }

    public static PreparsingRules readEmbeddedPreparsingRules(String rulesetName) throws IOException, JAXBException {
        return RulesetManager.readEmbeddedPreparsingRules(DEFAULT_PREPARSING_RULESET_PACKAGE, rulesetName);
    }

    public static PreparsingRules readEmbeddedPreparsingRules(String rulesetPackage, String rulesetName) throws IOException, JAXBException {
        return RulesetManager.materialize(PreparsingRules.class, RulesetManager.readRawEmbeddedRuleset(rulesetPackage, rulesetName));
    }

    public static PreparsingRules readExternalPreparsingRules(File file) throws IOException, JAXBException {
        return RulesetManager.materialize(PreparsingRules.class, RulesetManager.readRawExternalRuleset(file));
    }

    public static PreparsingRules readPreparsingRulesFromStream(InputStream stream) throws IOException, JAXBException {
        return RulesetManager.materialize(PreparsingRules.class, RulesetManager.readRawRulesetFromStream(stream));
    }

    public static PostparsingRules readEmbeddedPostparsingRules(String rulesetName) throws IOException, JAXBException {
        return RulesetManager.readEmbeddedPostparsingRules(DEFAULT_POSTPARSING_RULESET_PACKAGE, rulesetName);
    }

    public static PostparsingRules readEmbeddedPostparsingRules(String rulesetPackage, String rulesetName) throws IOException, JAXBException {
        return RulesetManager.materialize(PostparsingRules.class, RulesetManager.readRawEmbeddedRuleset(rulesetPackage, rulesetName));
    }

    public static PostparsingRules readExternalPostparsingRules(File file) throws IOException, JAXBException {
        return RulesetManager.materialize(PostparsingRules.class, RulesetManager.readRawExternalRuleset(file));
    }

    public static PostparsingRules readPostparsingRulesFromStream(InputStream stream) throws IOException, JAXBException {
        return RulesetManager.materialize(PostparsingRules.class, RulesetManager.readRawRulesetFromStream(stream));
    }

    public static String readRawEmbeddedRuleset(String rulesetPackage, String rulesetName) throws IOException {
        String resourceName = String.valueOf(rulesetPackage.replaceAll("\\.", Matcher.quoteReplacement("/"))) + "/" + rulesetName + ".xml";
        InputStream is = null;
        try {
            is = ResourcesUtils.getClasspathResourceAsStream(resourceName);
            String string = RulesetManager.readRawRulesetFromStream(is);
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String readRawExternalRuleset(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = RulesetManager.readRawRulesetFromStream(is);
            return string;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static String readRawRulesetFromStream(InputStream stream) throws IOException {
        String line;
        if (stream == null) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            xml.append(line).append("\n");
        }
        br.close();
        isr.close();
        return xml.toString();
    }
}

