/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.beans.io.file;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.inject.Named;
import org.fao.vrmf.core.helpers.beans.AbstractHelperBean;
import org.fao.vrmf.core.helpers.singletons.io.resources.ResourcesUtils;

@Named
public final class FileUtils
extends AbstractHelperBean {
    private static final long serialVersionUID = 1850909888452866798L;
    private static final int BUFFER_SIZE = 32768;

    public File copyFile(File sourcePath, String sourceFilename, String targetFilename) throws IOException {
        return this.copyFile(sourcePath, sourceFilename, sourcePath, targetFilename);
    }

    public File copyFile(File sourcePath, String sourceFilename, File targetPath) throws IOException {
        return this.copyFile(sourcePath, sourceFilename, targetPath, sourceFilename);
    }

    public File copyFile(File source, File target) throws IOException {
        return this.copyFile(source.getParentFile(), source.getName(), target.getParentFile(), target.getName());
    }

    public File copyFile(File sourcePath, String sourceFilename, File targetPath, String targetFilename) throws IOException {
        File source = new File(sourcePath, sourceFilename);
        File target = new File(targetPath, targetFilename);
        if (!source.exists()) {
            throw new IOException("Source file '" + source.getAbsolutePath() + "' does not exist!");
        }
        if (source.getAbsolutePath().equals(target.getAbsolutePath())) {
            throw new IOException("Source and target file have the same path!");
        }
        target.createNewFile();
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            int totalLength = 0;
            int len = -1;
            byte[] buffer = new byte[8192];
            try {
                fis = new FileInputStream(source);
                while ((len = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                    totalLength += len;
                }
                this._log.info("Copied " + totalLength + " bytes from file '" + source.getAbsolutePath() + "' to file '" + target.getAbsolutePath() + "'");
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            File file = target;
            return file;
        }
        finally {
            if (fos != null) {
                try {
                    try {
                        fos.flush();
                    }
                    finally {
                        fos.close();
                    }
                }
                catch (Throwable t) {
                    this._log.warn("Unable to flush or close output stream", t);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close input stream");
                }
            }
        }
    }

    public String storeFile(File path, String filename, byte[] content) throws IOException {
        this._log.info("Storing " + content.length + " bytes into file '" + filename + "' under '" + path.getAbsolutePath() + "'");
        String fullFilename = String.valueOf(path.getAbsolutePath()) + File.separator + filename;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fullFilename);
            fos.write(content);
        }
        finally {
            if (fos != null) {
                try {
                    try {
                        fos.flush();
                    }
                    finally {
                        fos.close();
                    }
                }
                catch (Throwable t) {
                    this._log.warn("Unable to flush or close stream", t);
                }
            }
        }
        this._log.info("STORED");
        return fullFilename;
    }

    public byte[] readFile(File path, String filename) throws IOException {
        this._log.info("Reading content of file '" + filename + "' under '" + path.getAbsolutePath() + "'");
        File file = new File(path, filename);
        long length = file.length();
        if (length <= 0L) {
            return new byte[0];
        }
        byte[] content = new byte[(int)length];
        int readLength = -1;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            readLength = fis.read(content);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        this._log.info("READ (" + readLength + " bytes out of " + length + " bytes in file)");
        return content;
    }

    public String[] fetchTextFileAsLines(File path, String filename, String charset) throws IOException {
        this._log.info("Fetching file '" + filename + "' under path '" + path.getAbsolutePath() + "'");
        FileInputStream fstream = new FileInputStream(String.valueOf(path.getAbsolutePath()) + File.separator + filename);
        ArrayList<String> lines = new ArrayList<String>();
        DataInputStream in = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            in = new DataInputStream(fstream);
            isr = new InputStreamReader((InputStream)in, Charset.forName(charset));
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close stream", t);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close stream reader", t);
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close stream reader", t);
                }
            }
        }
        this._log.info("FETCHED");
        return lines.toArray(new String[lines.size()]);
    }

    public String fetchTextFile(File path, String filename, String charset) throws IOException {
        this._log.info("Fetching file '" + filename + "' under path '" + path.getAbsolutePath() + "'");
        StringBuffer returned = new StringBuffer();
        File in = new File(String.valueOf(path.getAbsolutePath()) + File.separator + filename);
        byte[] buffer = new byte[32768];
        int readLength = -1;
        FileInputStream fis = null;
        Charset selectedCharset = Charset.forName(charset);
        try {
            fis = new FileInputStream(in);
            while ((readLength = fis.read(buffer)) != -1) {
                returned.append(new String(buffer, 0, readLength, selectedCharset));
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        this._log.info("FETCHED");
        return returned.toString();
    }

    public String[] fetchUTF8TextFileAsLines(File path, String filename) throws IOException {
        return this.fetchTextFileAsLines(path, filename, "UTF-8");
    }

    public String fetchUTF8TextFile(File path, String filename) throws IOException {
        return this.fetchTextFile(path, filename, "UTF-8");
    }

    public void convertTextFileToUTF8(File path, String filename) throws Throwable {
        this._log.info("Converting file '" + filename + "' under path '" + path.getAbsolutePath() + "'");
        File in = new File(String.valueOf(path.getAbsolutePath()) + File.separator + filename);
        File out = new File(String.valueOf(path.getAbsolutePath()) + File.separator + "UTF-8_" + filename);
        if (out.exists() && !out.delete()) {
            throw new RuntimeException("Cannot delete previous occurrence of file " + out.getAbsolutePath());
        }
        byte[] buffer = new byte[32768];
        int readLength = -1;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fis = new FileInputStream(in);
            fos = new FileOutputStream(out);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            while ((readLength = fis.read(buffer)) != -1) {
                osw.write(new String(buffer, 0, readLength));
            }
        }
        finally {
            if (osw != null) {
                try {
                    try {
                        osw.flush();
                    }
                    finally {
                        osw.close();
                    }
                }
                catch (Throwable t) {
                    this._log.warn("Unable to flush or close stream", t);
                }
            }
            if (fos != null) {
                try {
                    try {
                        fos.flush();
                    }
                    finally {
                        fos.close();
                    }
                }
                catch (Throwable t) {
                    this._log.warn("Unable to flush or close stream", t);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close stream", t);
                }
            }
        }
        this._log.info("CONVERTED");
    }

    public final File getClasspathResourceAsFile(String resourceFullyQualifiedName) throws Throwable {
        String prefix = "TEMP_RES";
        String suffix = resourceFullyQualifiedName.lastIndexOf(".") > 0 ? resourceFullyQualifiedName.substring(resourceFullyQualifiedName.lastIndexOf(".")) : "tmp";
        File temporary = File.createTempFile(prefix, suffix);
        InputStream is = ResourcesUtils.getClasspathResourceAsStream(resourceFullyQualifiedName);
        FileOutputStream os = null;
        int len = -1;
        int totalLen = 0;
        byte[] buffer = new byte[8192];
        try {
            os = new FileOutputStream(temporary);
            while ((len = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
                totalLen += len;
            }
            this._log.info("Classpath resource '" + resourceFullyQualifiedName + "' is now available as file " + temporary.getAbsolutePath() + " (" + totalLen + " bytes transferred)");
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (Throwable t) {
                    this._log.error("Unable to flush output stream", t);
                }
                try {
                    ((OutputStream)os).close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close output stream", t);
                }
                try {
                    is.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close input stream", t);
                }
            }
        }
        return temporary;
    }
}

