/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import org.fao.fi.comet.core.engine.MatchingEngineMetadataResolver;
import org.fao.fi.comet.core.engine.process.handlers.MatchingProcessHandler;
import org.fao.fi.comet.core.exceptions.MatchingProcessException;
import org.fao.fi.comet.core.exceptions.MatchletConfigurationException;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.Matching;
import org.fao.fi.comet.core.model.engine.MatchingDetails;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessResult;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessorInfo;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.engine.MatchingsData;
import org.fao.fi.comet.core.model.matchlets.Matchlet;
import org.fao.fi.comet.core.model.matchlets.MatchletConfiguration;
import org.fao.fi.comet.core.model.matchlets.MatchletConfigurationParameter;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletData;
import org.fao.fi.comet.core.model.matchlets.support.MatchletInfo;
import org.fao.fi.comet.core.patterns.data.partitioners.DataPartitioner;
import org.fao.fi.comet.core.patterns.data.providers.DataProvider;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.core.patterns.data.providers.SizeAwareDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.StreamingDataProvider;
import org.fao.fi.comet.core.patterns.handlers.id.IDHandler;
import org.fao.fi.comet.core.patterns.handlers.id.impl.basic.SerializableDataChecksumIDHandler;
import org.fao.fi.comet.core.patterns.handlers.id.impl.basic.SerializableDataIDHandler;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.impl.logging.TransientLoggingAwareClient;

public class MatchingEngineCore<SOURCE extends Serializable, TARGET extends Serializable, CONFIG extends MatchingEngineProcessConfiguration>
extends TransientLoggingAwareClient {
    private static final long serialVersionUID = 6231916630516037512L;
    public static final int MAX_THREADS_IN_POOL = 64;
    private final ExecutorCompletionService<Matching<SOURCE, TARGET>> executorQueue;
    private final int _parallelThreads = Runtime.getRuntime().availableProcessors();

    public MatchingEngineCore() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public MatchingEngineCore(int parallelThreads) {
        AssertionUtils.$lte(parallelThreads, 64, "The number of parallel threads ({}) must be lower than or equal to the maximum available ({})", parallelThreads, 64);
        this._log.info("Using {} as number of parallel threads for computation", (Object)parallelThreads);
        this.executorQueue = new ExecutorCompletionService(Executors.newFixedThreadPool(parallelThreads));
    }

    public final int getParallelThreads() {
        return this._parallelThreads;
    }

    protected final Collection<Class<?>> getDataTypeSet(Collection<Matchlet<SOURCE, ?, TARGET, ?>> matchlets) {
        ListSet dataTypes = new ListSet();
        if (matchlets != null) {
            for (Matchlet<SOURCE, ?, TARGET, ?> matchlet : matchlets) {
                if (!ClassUtils.isAnnotationPresent(matchlet.getClass(), MatchletData.class)) continue;
                for (MatchletData annotation : ClassUtils.getAllAnnotationsOfType(matchlet.getClass(), MatchletData.class)) {
                    dataTypes.addAll(Arrays.asList(annotation.dataType()));
                }
            }
        }
        return dataTypes;
    }

    protected Matching<SOURCE, TARGET> doGetMatching(MatchingsData<SOURCE, TARGET> matchingsData, DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier, MatchingResult<?, ?> currentMatchingResult) {
        MatchingDetails<SOURCE, TARGET> details = matchingsData.findMatchingDetailsBySourceIdentifier(sourceIdentifier);
        if (details == null) {
            this._log.info("Ouch! Cannot find matching details to get for SID: {} - TID: {}", (Object)sourceIdentifier.getId(), (Object)targetIdentifier.getId());
            return null;
        }
        return details.findMatchingByTargetId(targetIdentifier);
    }

    protected Matching<SOURCE, TARGET> doRemoveMatching(MatchingsData<SOURCE, TARGET> matchingsData, DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier) {
        MatchingDetails<SOURCE, TARGET> details = matchingsData.findMatchingDetailsBySourceIdentifier(sourceIdentifier);
        if (details == null) {
            this._log.info("Ouch! Cannot find matching details to remove for SID: {} - TID: {}", (Object)sourceIdentifier.getId(), (Object)targetIdentifier.getId());
            return null;
        }
        return details.removeMatchingByTargetId(targetIdentifier);
    }

    protected MatchingDetails<SOURCE, TARGET> doGetMatchingDetails(MatchingsData<SOURCE, TARGET> matchingsData, DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier) {
        return matchingsData.findMatchingDetailsBySourceIdentifier(sourceIdentifier);
    }

    protected MatchingResult<?, ?> doPerformActualComparison(SOURCE source, DataIdentifier sourceIdentifier, TARGET target, DataIdentifier targetIdentifier, Matchlet<SOURCE, ?, TARGET, ?> matchlet) {
        return matchlet.performMatching(source, sourceIdentifier, target, targetIdentifier);
    }

    protected void afterComparisonCallback(SOURCE source, DataProvider<TARGET> targets) {
    }

    protected final Matching<SOURCE, TARGET> performAtomicComparison(CONFIG configuration, MatchingProcessHandler<TARGET> tracker, MatchingsData<SOURCE, TARGET> matchingsData, SOURCE source, TARGET target, DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier, Collection<? extends Matchlet<SOURCE, ?, TARGET, ?>> matchlets) {
        AssertionUtils.$nNull(target, "Matching data source cannot be null", new Object[0]);
        AssertionUtils.$nNull(target, "Matching data target cannot be null", new Object[0]);
        try {
            double matchletsTotalWeight = 0.0;
            double totalScore = 0.0;
            MatchingResult<?, ?> currentMatchingResult = null;
            tracker.notifyAtomicComparisonStart();
            Matching<SOURCE, TARGET> matching = matchingsData.lazyGetMatching(source, sourceIdentifier, target, targetIdentifier);
            tracker.setMaximumNumberOfMatchletsApplied(matchlets.size());
            for (Matchlet<SOURCE, ?, TARGET, ?> matchlet : matchlets) {
                if (!tracker.isRunning()) break;
                if (this.skipMatchlet(matchlet)) continue;
                double matchletWeight = matchlet.getWeight();
                currentMatchingResult = this.doPerformActualComparison(source, sourceIdentifier, target, targetIdentifier, matchlet);
                matching.updateMatchingResult(currentMatchingResult);
                if (matching.isAuthoritative()) {
                    AssertionUtils.$_assert(currentMatchingResult.isFullMatch() || currentMatchingResult.isNoMatch(), "An authoritative match should return either NO MATCH or FULL MATCH", new Object[0]);
                    totalScore = currentMatchingResult.getScore().getValue() * matchletWeight;
                    if (currentMatchingResult.isNoMatch()) {
                        tracker.notifyAuthoritativeNoMatch();
                    } else if (currentMatchingResult.isFullMatch()) {
                        tracker.notifyAuthoritativeFullMatch();
                    }
                    matchletsTotalWeight = matchletWeight;
                    break;
                }
                if (!currentMatchingResult.isNonPerformed() || !matchlet.isOptional()) {
                    matchletsTotalWeight += matchletWeight;
                }
                double currentScore = currentMatchingResult.getScore().getValue() * matchletWeight;
                totalScore += currentScore;
            }
            totalScore = Double.compare(matchletsTotalWeight, 0.0) == 0 ? 0.0 : totalScore / matchletsTotalWeight;
            matching.getScore().setValue(totalScore);
            tracker.notifyAtomicComparisonPerformed();
            AssertionUtils.$gte(totalScore, 0.0, "The computed weighted score ({}) cannot be lower than the minimum allowed ({})", totalScore, 0.0);
            AssertionUtils.$lte(totalScore, 1.0, "The computed weighted score ({}) cannot be higher than the maximum allowed ({})", totalScore, 1.0);
            if (!matching.isAuthoritative() && !matching.isNonPerformed() && Double.compare(matching.getScore().getValue(), ((MatchingEngineProcessConfiguration)configuration).getMinimumAllowedWeightedScore()) < 0) {
                this.doRemoveMatching(matchingsData, sourceIdentifier, targetIdentifier);
                return null;
            }
            Matching<SOURCE, TARGET> matching2 = matching;
            return matching2;
        }
        finally {
            tracker.notifyAtomicComparisonEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final MatchingsData<SOURCE, TARGET> performComparison(CONFIG configuration, MatchingProcessHandler<TARGET> tracker, MatchingsData<SOURCE, TARGET> currentMatchingsData, DataProvider<SOURCE> sources, TARGET target, String targetProviderId, DataPartitioner<SOURCE, TARGET> partitioner, Collection<? extends Matchlet<SOURCE, ?, TARGET, ?>> matchlets, IDHandler<SOURCE, ?> sourceIDHandler, IDHandler<TARGET, ?> targetIDHandler) {
        StreamingDataProvider streamingDataProvider;
        DataIdentifier sourceIdentifier;
        Matching<SOURCE, TARGET> matching = null;
        if (sources instanceof SizeAwareDataProvider) {
            tracker.setMaximumNumberOfAtomicComparisonsPerformedInRound(((SizeAwareDataProvider)sources).getAvailableDataSize());
        }
        boolean hasMatched = false;
        DataIdentifier targetIdentifier = new DataIdentifier(targetProviderId, targetIDHandler.getSerializedId(target));
        int maxCandidatesPerEntry = ((MatchingEngineProcessConfiguration)configuration).getMaxCandidatesPerEntry();
        boolean allCandidatesPerEntry = maxCandidatesPerEntry == 0;
        boolean haltAtFirstMatching = ((MatchingEngineProcessConfiguration)configuration).getHaltAtFirstValidMatching() == null ? Boolean.FALSE : ((MatchingEngineProcessConfiguration)configuration).getHaltAtFirstValidMatching();
        boolean handleErrors = ((MatchingEngineProcessConfiguration)configuration).getHandleErrors();
        int actualComparisons = 0;
        for (ProvidedData providedData : sources) {
            if (partitioner.include(providedData.getData(), target, matchlets)) {
                ++actualComparisons;
                sourceIdentifier = new DataIdentifier(providedData.getProviderId(), sourceIDHandler.getSerializedId(providedData.getData()));
                this.executorQueue.submit(new AtomicComparisonProcess(this, this, currentMatchingsData, matchlets, configuration, tracker, providedData, target, targetProviderId, sourceIDHandler, targetIDHandler));
                continue;
            }
            tracker.notifyAtomicComparisonSkipped();
            tracker.notifyAtomicComparisonPerformed();
        }
        while (actualComparisons-- > 0) {
            try {
                matching = this.executorQueue.take().get();
                if (matching != null) {
                    sourceIdentifier = matching.getSourceIdentifier();
                    if (!matching.isNonPerformed() && Double.compare(matching.getScore().getValue(), ((MatchingEngineProcessConfiguration)configuration).getMinimumAllowedWeightedScore()) >= 0) {
                        tracker.notifyMatch();
                        hasMatched = true;
                        MatchingDetails matchingDetails = currentMatchingsData.findMatchingDetailsBySourceIdentifier(sourceIdentifier);
                        if (matchingDetails != null) {
                            void var20_25;
                            if (!allCandidatesPerEntry) {
                                MatchingDetails<SOURCE, TARGET> matchingDetails2 = matchingDetails.retain(maxCandidatesPerEntry, currentMatchingsData.MATCHINGS_COMPARATOR);
                            }
                            if (var20_25.getMatchings() == null || var20_25.getMatchings().isEmpty()) {
                                currentMatchingsData.removeMatchingDetailsBySourceIdentifier(sourceIdentifier);
                            }
                        }
                    } else {
                        this.doRemoveMatching(currentMatchingsData, sourceIdentifier, targetIdentifier);
                    }
                }
                if (!hasMatched || !haltAtFirstMatching) continue;
                break;
            }
            catch (ExecutionException executionException) {
                if (handleErrors) {
                    tracker.notifyComparisonError();
                    continue;
                }
                throw new RuntimeException(executionException);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (sources instanceof StreamingDataProvider && (streamingDataProvider = (StreamingDataProvider)sources).isRewindable()) {
            streamingDataProvider.rewind();
        }
        return currentMatchingsData;
    }

    public final MatchingEngineProcessResult<SOURCE, TARGET, CONFIG> compareAll(CONFIG configuration, MatchingProcessHandler<TARGET> tracker, DataProvider<SOURCE> sources, DataPartitioner<SOURCE, TARGET> partitioner, DataProvider<TARGET> targets) throws MatchingProcessException {
        return this.compareAll(configuration, tracker, sources, partitioner, targets, new SerializableDataChecksumIDHandler(), new SerializableDataIDHandler());
    }

    public final MatchingEngineProcessResult<SOURCE, TARGET, CONFIG> compareAll(CONFIG configuration, MatchingProcessHandler<TARGET> tracker, DataProvider<SOURCE> sources, DataPartitioner<SOURCE, TARGET> partitioner, DataProvider<TARGET> targets, IDHandler<SOURCE, ?> sourceIDHandler, IDHandler<TARGET, ?> targetIDHandler) throws MatchingProcessException {
        AssertionUtils.$nNull(configuration, "The configuration cannot be null", new Object[0]);
        AssertionUtils.$nNull(tracker, "The tracker cannot be null", new Object[0]);
        AssertionUtils.$nNull(partitioner, "The partitioner cannot be null", new Object[0]);
        AssertionUtils.$nNull(sources, "The sources cannot be null", new Object[0]);
        AssertionUtils.$nNull(targets, "The targets cannot be null", new Object[0]);
        ((MatchingEngineProcessConfiguration)configuration).validate();
        Collection<Matchlet<SOURCE, ?, TARGET, ?>> matchlets = this.initializeMatchlets(configuration);
        AssertionUtils.$nEm(matchlets, "Matchlets cannot be null or empty", new Object[0]);
        AssertionUtils.$nNull(sourceIDHandler, "The source ID handler cannot be null", new Object[0]);
        AssertionUtils.$nNull(targetIDHandler, "The target ID handler cannot be null", new Object[0]);
        AssertionUtils.$_iArg(sources.iterator().hasNext(), "The sources must contain at least one element", new Object[0]);
        MatchingsData results = new MatchingsData();
        tracker.notifyComparisonProcessStarted(tracker.getProcessId());
        for (ProvidedData providedData : targets) {
            if (!tracker.isRunning()) break;
            tracker.notifyComparisonRoundStart(providedData);
            this.performComparison(configuration, tracker, results, sources, providedData.getData(), providedData.getProviderId(), partitioner, matchlets, sourceIDHandler, targetIDHandler);
            tracker.notifyComparisonRoundPerformed(providedData);
        }
        tracker.notifyComparisonProcessCompleted();
        this.cleanup((MatchingEngineProcessConfiguration)configuration, results);
        MatchingEngineProcessorInfo<CONFIG> matchingEngineProcessorInfo = new MatchingEngineProcessorInfo<CONFIG>(this.updateConfiguration(matchlets, configuration), tracker.getProcessStatus());
        return new MatchingEngineProcessResult(matchingEngineProcessorInfo, results);
    }

    protected void cleanup(MatchingEngineProcessConfiguration configuration, MatchingsData<SOURCE, TARGET> matchingsData) {
        matchingsData.cleanup(configuration.getMaxCandidatesPerEntry(), configuration.getMinimumAllowedWeightedScore());
    }

    protected boolean skipMatchlet(Matchlet<?, ?, ?, ?> matchletConfiguration) {
        return Double.compare(matchletConfiguration.getWeight(), 0.0) == 0;
    }

    protected final CONFIG updateConfiguration(Collection<? extends Matchlet<SOURCE, ?, TARGET, ?>> matchlets, CONFIG configuration) throws MatchletConfigurationException {
        MatchingEngineProcessConfiguration cloned = (MatchingEngineProcessConfiguration)ObjectsUtils.rawClone(configuration);
        ArrayList<MatchletConfiguration> effectiveMatchletsConfigurations = new ArrayList<MatchletConfiguration>();
        for (Matchlet<SOURCE, ?, TARGET, ?> matchlet : matchlets) {
            MatchletConfiguration currentMatchletConfiguration = new MatchletConfiguration(matchlet.getId(), matchlet.getName(), matchlet.getClass().getName());
            currentMatchletConfiguration.setMatchletParameters(matchlet.getConfiguration());
            Iterator<MatchletConfigurationParameter> iterator = currentMatchletConfiguration.getMatchletParameters().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isTransient()) continue;
                iterator.remove();
            }
            effectiveMatchletsConfigurations.add(currentMatchletConfiguration);
        }
        cloned.setMatchletsConfiguration(effectiveMatchletsConfigurations);
        return (CONFIG)cloned;
    }

    protected Class<? extends Matchlet> getDiscoverableMatchletClass() {
        return Matchlet.class;
    }

    public final Collection<MatchletInfo> getAllAvailableMatchletsInfo() {
        return MatchingEngineMetadataResolver.getAvailableMatchletsInfo(this.getDiscoverableMatchletClass());
    }

    private Collection<Matchlet<SOURCE, ?, TARGET, ?>> initializeMatchlets(CONFIG configuration) throws MatchletConfigurationException {
        if (configuration == null || ((MatchingEngineProcessConfiguration)configuration).getMatchletsConfigurations() == null || ((MatchingEngineProcessConfiguration)configuration).getMatchletsConfigurations().isEmpty()) {
            return null;
        }
        ArrayList matchlets = new ArrayList();
        ServiceLoader<Matchlet> loader = ServiceLoader.load(this.getDiscoverableMatchletClass());
        for (MatchletConfiguration matchletConfig : ((MatchingEngineProcessConfiguration)configuration).getMatchletsConfigurations()) {
            boolean provided = false;
            for (Matchlet matchlet : loader) {
                if (!matchlet.getName().equals(matchletConfig.getMatchletName())) continue;
                matchlet = ObjectsUtils.rawClone(matchlet);
                matchlet.configure(matchletConfig.getMatchletParameters());
                matchlet.setId(matchletConfig.getMatchletId());
                matchlet.validateConfiguration();
                matchlets.add(matchlet);
                provided = true;
                break;
            }
            if (provided) continue;
            throw new MatchletConfigurationException("No provider available for matchlet named " + matchletConfig.getMatchletId());
        }
        if (matchlets.isEmpty()) {
            return null;
        }
        return matchlets;
    }

    private static class AtomicComparisonProcess
    implements Callable<Matching<SOURCE, TARGET>> {
        private final MatchingEngineCore<SOURCE, TARGET, CONFIG> _engine;
        private final MatchingsData<SOURCE, TARGET> _currentMatchingsData;
        private final Collection<? extends Matchlet<SOURCE, ?, TARGET, ?>> _matchlets;
        private final CONFIG _conf;
        private final MatchingProcessHandler<TARGET> _tracker;
        private final ProvidedData<SOURCE> _source;
        private final TARGET _target;
        private final String _targetProviderId;
        private final IDHandler<SOURCE, ?> _sourceIDHandler;
        private final IDHandler<TARGET, ?> _targetIDHandler;
        final /* synthetic */ MatchingEngineCore this$0;

        public AtomicComparisonProcess(MatchingEngineCore<SOURCE, TARGET, CONFIG> engine, MatchingsData<SOURCE, TARGET> currentMatchingsData, Collection<? extends Matchlet<SOURCE, ?, TARGET, ?>> matchlets, CONFIG conf, MatchingProcessHandler<TARGET> tracker, ProvidedData<SOURCE> source, TARGET target, String targetProviderId, IDHandler<SOURCE, ?> sourceIDHandler, IDHandler<TARGET, ?> targetIDHandler) {
            this.this$0 = var1_1;
            this._engine = engine;
            this._currentMatchingsData = currentMatchingsData;
            this._matchlets = matchlets;
            this._conf = conf;
            this._tracker = tracker;
            this._source = source;
            this._target = target;
            this._targetProviderId = targetProviderId;
            this._sourceIDHandler = sourceIDHandler;
            this._targetIDHandler = targetIDHandler;
        }

        @Override
        public Matching<SOURCE, TARGET> call() throws InterruptedException, ExecutionException {
            if (!this._tracker.isRunning()) {
                throw new InterruptedException();
            }
            DataIdentifier sourceIdentifier = new DataIdentifier(this._source.getProviderId(), this._sourceIDHandler.getSerializedId(this._source.getData()));
            DataIdentifier targetIdentifier = new DataIdentifier(this._targetProviderId, this._targetIDHandler.getSerializedId(this._target));
            try {
                Matching matching = this._engine.performAtomicComparison(this._conf, this._tracker, this._currentMatchingsData, this._source.getData(), this._target, sourceIdentifier, targetIdentifier, this._matchlets);
                return matching;
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }
}

