/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.patterns.data.providers.impl;

import java.io.Serializable;
import org.fao.fi.comet.core.patterns.data.providers.DataProvider;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

public abstract class DataProviderSkeleton<ENTITY extends Serializable>
extends ImmutableLoggingClient
implements DataProvider<ENTITY> {
    private String _providerID;

    public DataProviderSkeleton() {
        this._providerID = ClassUtils.getThis(this);
    }

    public DataProviderSkeleton(String providerID) {
        AssertionUtils.$nNull(providerID, "Provider ID cannot be null", new Object[0]);
        this._providerID = providerID;
    }

    @Override
    public final String getProviderID() {
        return this._providerID;
    }

    @Override
    public final void setProviderID(String providerID) {
        AssertionUtils.$nNull(providerID, "Provider ID cannot be null", new Object[0]);
        this._providerID = providerID;
    }

    @Override
    public final void releaseResources() throws Exception {
        this._log.debug("Releasing resources for {} ({})...", (Object)this._providerID, (Object)this);
        long start = System.currentTimeMillis();
        try {
            try {
                this.doReleaseResources();
            }
            catch (Exception e) {
                this._log.warn("Unable to release resources for {} ({}): {} [ {} ]", new Object[]{this._providerID, this, e.getClass().getSimpleName(), e.getMessage()});
                throw e;
            }
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this._log.debug("Releasing resources for {} ({}) took {} mSec.", new Object[]{this._providerID, this, end - start});
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this._log.debug("Releasing resources for {} ({}) took {} mSec.", new Object[]{this._providerID, this, end - start});
    }

    protected abstract void doReleaseResources() throws Exception;
}

