/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.beans.text.xml;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.inject.Named;
import org.fao.vrmf.core.helpers.beans.AbstractHelperBean;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.impl.design.patterns.pair.NameValuePair;

@Named
public class XMLPrettyPrinter
extends AbstractHelperBean {
    private static final long serialVersionUID = 4707099744775433210L;
    protected StringBuilder _content = new StringBuilder();
    protected String _namespace = null;
    protected URI _namespaceURI = null;
    protected URL _schemaLocation = null;
    protected String _padder = null;
    protected boolean _includeHeaders = true;
    protected Stack<String> _tagStack = new Stack();
    protected int _level = 0;
    protected boolean _hasContent = false;

    public XMLPrettyPrinter() {
        this.hardReset();
    }

    public XMLPrettyPrinter(String namespace, URI namespaceURI, URL schemaLocation) {
        this();
        this._namespace = namespace;
        this._namespaceURI = namespaceURI;
        this._schemaLocation = schemaLocation;
    }

    public XMLPrettyPrinter(String namespace, URI namespaceURI, URL schemaLocation, String padder) {
        this(namespace, namespaceURI, schemaLocation);
        this._padder = padder;
    }

    public final URI getNamespaceURI() {
        return this._namespaceURI;
    }

    public final void setNamespaceURI(URI namespaceURI) {
        this._namespaceURI = namespaceURI;
    }

    public final URL getSchemaLocation() {
        return this._schemaLocation;
    }

    public final void setSchemaLocation(URL schemaLocation) {
        this._schemaLocation = schemaLocation;
    }

    public final boolean getIncludeHeaders() {
        return this._includeHeaders;
    }

    public final void setIncludeHeaders(boolean includeHeaders) {
        this._includeHeaders = includeHeaders;
    }

    public final String getPadder() {
        return this._padder;
    }

    public final void setPadder(String padder) {
        this._padder = padder;
    }

    public final int getLevel() {
        return this._level;
    }

    public final StringBuilder getNamespace() {
        if (StringUtils.rawTrim(this._namespace) == null) {
            return new StringBuilder();
        }
        return new StringBuilder(StringUtils.rawTrim(this._namespace)).append(":");
    }

    public final void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public final void reset() {
        this._level = 0;
        this._hasContent = false;
        this._tagStack.clear();
        this._content = new StringBuilder();
    }

    public final void hardReset() {
        this.reset();
        this._namespace = null;
        this._namespaceURI = null;
        this._schemaLocation = null;
        this._includeHeaders = true;
        this._padder = "\t";
    }

    protected String pad() {
        return this.pad(this._level);
    }

    protected String pad(int level) {
        String pad = "";
        int p = 0;
        while (p < level) {
            pad = String.valueOf(pad) + this._padder;
            ++p;
        }
        return pad;
    }

    public String comment(String comment) {
        String fragment = "<!-- " + comment + " -->\n";
        this._content.append(fragment);
        return fragment;
    }

    public String empty(String tag) {
        StringBuilder result = new StringBuilder();
        if (this._level == 0 && this._includeHeaders) {
            result.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        }
        if (this._level == 0 && StringUtils.rawTrim(this._namespace) != null) {
            result.append("<").append((CharSequence)this.getNamespace()).append(tag).append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(" xsi:schemaLocation=\"").append(this._namespaceURI.toASCIIString()).append(" ").append(this._schemaLocation.toExternalForm()).append("\"").append(" xmlns:").append(this._namespace).append("=\"").append(this._namespaceURI.toASCIIString()).append("\"").append("/>");
        } else {
            result.append(this._level == 0 || "nil".equalsIgnoreCase(tag) ? "" : "\n").append("nil".equalsIgnoreCase(tag) ? "" : this.pad()).append("<").append((CharSequence)this.getNamespace()).append(tag).append("/>");
        }
        this._content.append((CharSequence)result);
        return result.toString();
    }

    public String empty(String tag, NameValuePair attribute) {
        return this.empty(tag, new NameValuePair[]{attribute});
    }

    public String empty(String tag, NameValuePair ... attributes) {
        StringBuilder result = new StringBuilder();
        if (this._level == 0 && this._includeHeaders) {
            result.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        }
        if (this._level == 0 && StringUtils.rawTrim(this._namespace) != null) {
            result.append("<").append((CharSequence)this.getNamespace()).append(tag).append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(" xsi:schemaLocation=\"").append(this._namespaceURI.toASCIIString()).append(" ").append(this._schemaLocation.toExternalForm()).append("\"").append(" xmlns:").append(this._namespace).append("=\"").append(this._namespaceURI.toASCIIString()).append("\"");
        } else {
            result.append(this._level == 0 || "nil".equalsIgnoreCase(tag) ? "" : "\n").append("nil".equalsIgnoreCase(tag) ? "" : this.pad()).append("<").append((CharSequence)this.getNamespace()).append(tag);
        }
        Serializable value = null;
        if (attributes != null && attributes.length > 0) {
            NameValuePair[] nameValuePairArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                NameValuePair attribute = nameValuePairArray[n2];
                if (StringUtils.rawTrim(attribute.getName()) != null && (value = attribute.getValue()) != null) {
                    result.append(" ").append((CharSequence)this.getNamespace()).append(StringUtils.rawTrim(attribute.getName())).append("=\"");
                    result.append(value.toString().replaceAll("\\n|\\t|\\r", "").replaceAll("\\\"", "\\\\\""));
                    result.append("\"");
                }
                ++n2;
            }
        }
        result.append("/>");
        this._content.append((CharSequence)result);
        return result.toString();
    }

    public String element(String tag, Object value) {
        return this.element(tag, value, new NameValuePair[0]);
    }

    public String element(String tag, Object value, NameValuePair attribute) {
        NameValuePair[] nameValuePairArray;
        if (attribute == null) {
            nameValuePairArray = new NameValuePair[]{};
        } else {
            NameValuePair[] nameValuePairArray2 = new NameValuePair[1];
            nameValuePairArray = nameValuePairArray2;
            nameValuePairArray2[0] = attribute;
        }
        return this.element(tag, value, nameValuePairArray);
    }

    public String element(String tag, Object value, NameValuePair ... attributes) {
        StringBuilder fragment = new StringBuilder();
        fragment.append(this.open(tag, attributes)).append(value == null ? this.nil() : (Number.class.isAssignableFrom(value.getClass()) ? this.text(value.toString()) : this.cdata(value.toString()))).append(this.close());
        return fragment.toString();
    }

    public String nil() {
        try {
            String string = this.empty("nil");
            return string;
        }
        finally {
            this._hasContent = true;
        }
    }

    public String nil(NameValuePair attribute) {
        return this.nil(attribute);
    }

    public String nil(NameValuePair ... attributes) {
        try {
            String string = this.empty("nil", attributes);
            return string;
        }
        finally {
            this._hasContent = true;
        }
    }

    public String open(Class<?> tag) {
        return this.open(tag.getSimpleName());
    }

    public String open(String tag) {
        try {
            StringBuilder result = new StringBuilder();
            if (this._level == 0 && this._includeHeaders) {
                result.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            }
            if (this._level == 0 && StringUtils.rawTrim(this._namespace) != null) {
                result.append("<").append((CharSequence)this.getNamespace()).append(tag).append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(" xsi:schemaLocation=\"").append(this._namespaceURI.toASCIIString()).append(" ").append(this._schemaLocation.toExternalForm()).append("\"").append(" xmlns:").append(this._namespace).append("=\"").append(this._namespaceURI.toASCIIString()).append("\"").append(">");
            } else {
                result.append(this._level == 0 ? "" : "\n").append(this.pad()).append("<").append((CharSequence)this.getNamespace()).append(tag).append(">");
            }
            this._content.append((CharSequence)result);
            String string = result.toString();
            return string;
        }
        finally {
            this._hasContent = false;
            ++this._level;
            this._tagStack.push(tag);
        }
    }

    public String open(String tag, NameValuePair attribute) {
        return this.open(tag, new NameValuePair[]{attribute});
    }

    public String open(String tag, List<NameValuePair> attributes) {
        return this.open(tag, attributes == null ? null : attributes.toArray(new NameValuePair[attributes.size()]));
    }

    public String open(String tag, NameValuePair ... attributes) {
        try {
            StringBuilder result = new StringBuilder();
            if (this._level == 0 && this._includeHeaders) {
                result.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            }
            if (this._level == 0 && StringUtils.rawTrim(this._namespace) != null) {
                result.append("<").append((CharSequence)this.getNamespace()).append(tag).append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(" xsi:schemaLocation=\"").append(this._namespaceURI.toASCIIString()).append(" ").append(this._schemaLocation.toExternalForm()).append("\"").append(" xmlns:").append(this._namespace).append("=\"").append(this._namespaceURI.toASCIIString()).append("\"");
            } else {
                result.append(this._level == 0 ? "" : "\n").append(this.pad()).append("<").append((CharSequence)this.getNamespace()).append(tag);
            }
            Serializable value = null;
            if (attributes != null && attributes.length > 0) {
                NameValuePair[] nameValuePairArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    NameValuePair attribute = nameValuePairArray[n2];
                    if (attribute != null && StringUtils.rawTrim(attribute.getName()) != null && (value = attribute.getValue()) != null) {
                        result.append(" ").append((CharSequence)this.getNamespace()).append(StringUtils.rawTrim(attribute.getName())).append("=\"");
                        result.append(value.toString().replaceAll("\\n|\\t|\\r", "").replaceAll("\\\"", "\\\\\""));
                        result.append("\"");
                    }
                    ++n2;
                }
            }
            result.append(">");
            this._content.append((CharSequence)result);
            String string = result.toString();
            return string;
        }
        finally {
            this._hasContent = false;
            ++this._level;
            this._tagStack.push(tag);
        }
    }

    public String open(String tag, Map<String, Serializable> attributes) {
        ArrayList<NameValuePair> asList = new ArrayList<NameValuePair>();
        for (String key : attributes.keySet()) {
            asList.add(new NameValuePair(key, attributes.get(key)));
        }
        return this.open(tag, asList.toArray(new NameValuePair[0]));
    }

    public String close(Class<?> tag) {
        return this.close(tag.getSimpleName());
    }

    public String close(String tag) {
        try {
            String lastTag = this._tagStack.pop();
            --this._level;
            if (tag.equals(lastTag)) {
                StringBuilder fragment = new StringBuilder(this._hasContent ? "" : "\n").append(this._hasContent ? "" : this.pad()).append("</").append((CharSequence)this.getNamespace()).append(tag).append(">");
                this._content.append((CharSequence)fragment);
                String string = fragment.toString();
                return string;
            }
            throw new RuntimeException("Cannot close tag '" + tag + "': last opened tag was " + lastTag);
        }
        finally {
            this._hasContent = false;
        }
    }

    public String close() {
        try {
            String lastTag = this._tagStack.pop();
            --this._level;
            if (this._level < 0) {
                throw new RuntimeException("Cannot close last opened tag: document root reached");
            }
            StringBuilder fragment = new StringBuilder(this._hasContent ? "" : "\n").append(this._hasContent ? "" : this.pad()).append("</").append((CharSequence)this.getNamespace()).append(lastTag).append(">");
            this._content.append((CharSequence)fragment);
            String string = fragment.toString();
            return string;
        }
        finally {
            this._hasContent = false;
        }
    }

    public String cdata(String content) {
        this._hasContent = true;
        if (content != null) {
            StringBuilder fragment = new StringBuilder().append("<![CDATA[").append(content == null ? "" : content).append("]]>");
            this._content.append((CharSequence)fragment);
            return fragment.toString();
        }
        return this.nil();
    }

    public String text(String content) {
        boolean bl = this._hasContent = StringUtils.rawTrim(content) != null;
        if (this._hasContent) {
            String text = StringUtils.rawTrim(content);
            this._content.append(text);
            return text;
        }
        return this.nil();
    }

    public final String convertAttributeValue(String toConvert) {
        String trimmed = StringUtils.rawTrim(toConvert);
        if (trimmed == null) {
            return "";
        }
        trimmed = trimmed.replaceAll("[^a-zA-Z|0-9|_|\\s]", "").replaceAll("\\s{1,}", "_");
        return StringUtils.convertFromUnderscoresToCamelCase(trimmed);
    }

    public final String toString() {
        if (this._content == null) {
            return null;
        }
        return this._content.toString();
    }
}

