/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.lang.objects;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.fao.vrmf.core.behaviours.data.Fillable;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.extensions.collections.nu.impl.NuArrayList;
import org.fao.vrmf.core.extensions.exceptions.WrappedRuntimeException;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.support.FieldFilter;
import org.fao.vrmf.core.helpers.singletons.lang.objects.support.MultipleFieldFilter;
import org.fao.vrmf.core.helpers.singletons.lang.objects.support.impl.NonStaticFieldFilter;
import org.fao.vrmf.core.helpers.singletons.lang.objects.support.impl.NonStaticNonFinalFieldFilter;
import org.fao.vrmf.core.impl.design.patterns.predicate.BasicPredicate;
import org.fao.vrmf.core.models.data.annotations.DoNotSerialize;
import org.fao.vrmf.core.models.data.annotations.Metadata;
import org.fao.vrmf.core.models.data.annotations.MetadataFields;
import org.fao.vrmf.core.models.data.annotations.NonSerializedFields;

public class ObjectsUtils
extends AbstractHelperSingleton {
    public static final boolean TRAVERSE_OBJECT_HIERARCHY = true;
    public static final boolean DONT_TRAVERSE_OBJECT_HIERARCHY = false;
    public static final int EMIT_BASIC_DATA = 1;
    public static final int EMIT_VALUE_HASH = 2;
    public static final int EMIT_FIELD_NAME = 4;
    public static final int EMIT_FIELD_TYPE = 8;
    public static final int EMIT_FIELD_MOD = 16;
    public static final int EMIT_ALL = 30;
    public static final int DEFAULT_EMIT_OPTIONS = 1;
    public static final boolean GZIP_STREAM = true;
    public static final boolean DONT_GZIP_STREAM = false;
    protected static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static final String NULL = "<NULL>";
    protected static final String EMPTY = "<EMPTY>";
    protected static final String ALREADY_SERIALIZED = "<ALREADY SERIALIZED>";

    protected ObjectsUtils() {
    }

    public static boolean areEqual(Object firstObject, Object secondObject) {
        if (firstObject == null) {
            return secondObject == null;
        }
        return firstObject.equals(secondObject);
    }

    public static byte[] serialize(Serializable toSerialize, boolean gzip) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = null;
            ObjectOutputStream hos = null;
            if (gzip) {
                gzos = new GZIPOutputStream(baos);
                hos = new ObjectOutputStream(gzos);
            } else {
                hos = new ObjectOutputStream(baos);
            }
            hos.writeObject(toSerialize);
            if (gzip && gzos != null) {
                gzos.finish();
                gzos.flush();
            }
            byte[] toReturn = baos.toByteArray();
            hos.close();
            baos.close();
            return toReturn;
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Cannot serialize object " + toSerialize, t);
        }
    }

    public static Serializable deserialize(byte[] toDeserialize, boolean gzip) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(toDeserialize);
            GZIPInputStream gzis = null;
            ObjectInputStream ois = null;
            if (gzip) {
                gzis = new GZIPInputStream(bais);
                ois = new ObjectInputStream(gzis);
            } else {
                ois = new ObjectInputStream(bais);
            }
            Serializable toReturn = (Serializable)ois.readObject();
            if (gzis != null) {
                gzis.close();
            }
            bais.close();
            return toReturn;
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Cannot deserialize" + (gzip ? " gzipped" : "") + " byte stream", t);
        }
    }

    public static <S extends Serializable> S rawClone(S toClone) {
        block3: {
            try {
                if (toClone != null) break block3;
            }
            catch (Throwable t) {
                throw new WrappedRuntimeException("Unable to perform raw clone on " + toClone, t);
            }
            return null;
        }
        return (S)ObjectsUtils.deserialize(ObjectsUtils.serialize(toClone, true), true);
    }

    public static boolean safeEquals(Object first, Object second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null) {
            return first.equals(second);
        }
        return false;
    }

    public static boolean serializableEquals(Serializable first, Serializable second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        if (!first.getClass().equals(second.getClass())) {
            return false;
        }
        try {
            return ObjectsUtils.convertToString(first, false).equals(ObjectsUtils.convertToString(second, false));
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Unable to perform serializable equals on " + first + " and " + second, t);
        }
    }

    public static boolean toStringEquals(Object first, Object second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        if (!first.getClass().equals(second.getClass())) {
            return false;
        }
        String firstString = ObjectsUtils.toString(12, first);
        String secondString = ObjectsUtils.toString(12, second);
        return firstString.equals(secondString);
    }

    public static boolean rawEquals(Serializable first, Object second) {
        if (first == null || second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        if (!(second instanceof Serializable)) {
            return false;
        }
        if (!first.getClass().equals(second.getClass())) {
            return false;
        }
        Serializable asSerializable = (Serializable)Serializable.class.cast(second);
        try {
            return ObjectsUtils.convertToString(first, false).equals(ObjectsUtils.convertToString(asSerializable, false));
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Unable to perform raw equals on " + first + " and " + second, t);
        }
    }

    public static boolean smartEquals(Object first, Object second) {
        return ObjectsUtils.smartEquals(first, second, new HashSet<Object>());
    }

    private static boolean smartEquals(final Object first, final Object second, final Collection<Object> alreadyVisited) {
        boolean equals;
        if (first == null && second == null) {
            return true;
        }
        boolean bl = equals = first != null && second != null;
        if (!equals) {
            return false;
        }
        boolean bl2 = equals = first == second;
        if (equals) {
            return true;
        }
        equals = second.getClass().isAssignableFrom(first.getClass());
        if (equals && ObjectsUtils.isPrimitive(null, first) && ObjectsUtils.isPrimitive(null, second)) {
            return ObjectsUtils.safeEquals(first, second);
        }
        final Collection<Field> fields = ObjectsUtils.listFields(first, true, NonStaticFieldFilter.instance());
        return equals && AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Field field : fields) {
                    try {
                        field.setAccessible(true);
                        boolean isPrimitive = ObjectsUtils.isPrimitive(field, null);
                        boolean isArray = ObjectsUtils.isArray(field, null);
                        Object firstValue = field.get(first);
                        Object secondValue = field.get(second);
                        if (alreadyVisited.contains(firstValue) && alreadyVisited.contains(secondValue)) continue;
                        if (isPrimitive && !isArray && !ObjectsUtils.safeEquals(firstValue, secondValue)) {
                            return false;
                        }
                        if (isArray && !Arrays.equals((Object[])firstValue, (Object[])secondValue)) {
                            return false;
                        }
                        HashSet<Object> currentlyVisited = new HashSet<Object>(alreadyVisited);
                        currentlyVisited.add(firstValue);
                        currentlyVisited.add(secondValue);
                        if (isPrimitive || ObjectsUtils.smartEquals(firstValue, secondValue, currentlyVisited)) continue;
                        return false;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
                return true;
            }
        }) != false;
    }

    public static String toString(Object toConvert) {
        return ObjectsUtils.toString(1, toConvert);
    }

    public static String toString(int options, Object toConvert) {
        return ObjectsUtils.toString(options, toConvert, true);
    }

    public static String toString(Object toConvert, boolean traverseHierarchy) {
        return ObjectsUtils.toString(1, toConvert, true);
    }

    public static String toString(int options, Object toConvert, boolean traverseHierarchy) {
        return ObjectsUtils.toString(options, toConvert, traverseHierarchy, NonStaticFieldFilter.instance());
    }

    public static String toString(Object toConvert, FieldFilter ... fieldFilters) {
        return ObjectsUtils.toString(1, toConvert, true, fieldFilters);
    }

    public static String toString(int options, Object toConvert, FieldFilter ... fieldFilters) {
        return ObjectsUtils.toString(options, toConvert, true, fieldFilters);
    }

    public static String toString(Object toConvert, boolean traverseHierarchy, FieldFilter ... fieldFilters) {
        return ObjectsUtils.toString(1, toConvert, traverseHierarchy, fieldFilters);
    }

    public static String toString(int options, Object toConvert, boolean traverseHierarchy, FieldFilter ... fieldFilters) {
        return ObjectsUtils.toString(options, toConvert, new HashSet<Object>(), traverseHierarchy, fieldFilters);
    }

    private static String toString(int options, Object toConvert, Collection<Object> alreadySerialized, boolean traverseHierarchy, FieldFilter ... fieldFilters) {
        return AccessController.doPrivileged(new ToStringPrivilegedAction(options, toConvert, alreadySerialized, traverseHierarchy, fieldFilters));
    }

    public static boolean isAssignableFrom(Field field, Object value, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return field == null && value == null ? false : clazz.isAssignableFrom(value == null ? field.getType() : value.getClass());
    }

    public static boolean isString(Field field, Object value) {
        return ObjectsUtils.isAssignableFrom(field, value, String.class);
    }

    public static boolean isCollection(Field field, Object value) {
        return ObjectsUtils.isAssignableFrom(field, value, Collection.class);
    }

    public static boolean isMap(Field field, Object value) {
        return ObjectsUtils.isAssignableFrom(field, value, Map.class);
    }

    public static boolean isPrimitive(Field field, Object value) {
        Class<?> clazz;
        Object object = value == null ? (field == null ? null : field.getType()) : (clazz = value.getClass());
        return field == null && value == null ? true : clazz.isPrimitive() || "java.lang".equals(ClassUtils.getPackageName(clazz));
    }

    public static boolean isArray(Field field, Object value) {
        return field == null && value == null ? false : (value == null ? field.getType() : value.getClass()).isArray();
    }

    public static int smartHash(final Object object) {
        if (object == null) {
            return 0;
        }
        int prime = 31;
        final HashSet<String> nonSerializedFieldNames = new HashSet<String>();
        if (object.getClass().isAnnotationPresent(NonSerializedFields.class)) {
            nonSerializedFieldNames.addAll(Arrays.asList(object.getClass().getAnnotation(NonSerializedFields.class).fieldNames()));
        }
        final Collection<Field> fields = ObjectsUtils.listAllFields(object);
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                int result = 1;
                for (Field field : fields) {
                    if (field.isAnnotationPresent(DoNotSerialize.class) || nonSerializedFieldNames.contains(field.getName())) continue;
                    try {
                        field.setAccessible(true);
                        result = 31 * result + (field.get(object) == null ? 0 : ObjectsUtils.smartHash(field.get(object)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return result;
            }
        });
    }

    public static boolean isEmpty(final Fillable object) {
        Collection<MetadataFields> annotations;
        if (object == null) {
            return true;
        }
        final Collection<Field> fields = ObjectsUtils.listAllFields(object);
        if (fields.isEmpty()) {
            return true;
        }
        final ListSet metadataFields = new ListSet();
        if (ClassUtils.isAnnotationPresent(object.getClass(), MetadataFields.class) && !(annotations = ClassUtils.getAllAnnotationsOfType(object.getClass(), MetadataFields.class)).isEmpty()) {
            for (MetadataFields annotation : annotations) {
                if (annotation.value() == null || annotation.value().length <= 0) continue;
                metadataFields.addAll(Arrays.asList(annotation.value()));
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Field field : fields) {
                    if (field.isAnnotationPresent(Metadata.class) || metadataFields.contains(field.getName()) || ObjectsUtils.getFieldValue((Object)object, field) == null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static String convertToString(Serializable toSerialize, boolean gzip) {
        try {
            byte[] serialized = ObjectsUtils.serialize(toSerialize, gzip);
            StringBuffer toReturn = new StringBuffer();
            byte[] byArray = serialized;
            int n = serialized.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                toReturn.append(ObjectsUtils.convertByteToString(b));
                ++n2;
            }
            return toReturn.toString();
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Cannot serialize object " + toSerialize + " with GZIP compression " + (gzip ? "enabled" : "disabled"), t);
        }
    }

    public static Serializable convertToObject(String toConvert, boolean gzip) {
        try {
            byte[] serialized = new byte[toConvert.length() / 2];
            int s = 0;
            while (s < toConvert.length()) {
                serialized[s / 2] = ObjectsUtils.convertByteFromString(toConvert.substring(s, s + 2));
                s += 2;
            }
            return ObjectsUtils.deserialize(serialized, gzip);
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Cannot convert object from string " + toConvert + " with GZIP compression " + (gzip ? "enabled" : "disabled"), t);
        }
    }

    protected static CharSequence convertByteToString(byte toConvert) {
        int asInt = toConvert;
        int low = (asInt += 128) % 16;
        int high = asInt / 16;
        return new String(new char[]{HEX_CHARS[high], HEX_CHARS[low]});
    }

    protected static byte convertByteFromString(CharSequence toConvert) {
        int low = Arrays.binarySearch(HEX_CHARS, toConvert.charAt(1));
        int high = Arrays.binarySearch(HEX_CHARS, toConvert.charAt(0));
        return (byte)(high * 16 + low - 128);
    }

    public static Collection<Field> listFields(Object object, boolean traverseHierarchy, FieldFilter ... fieldFilters) {
        assert (object != null) : "Provided object cannot be null";
        return ClassUtils.listFields(object.getClass(), traverseHierarchy, fieldFilters);
    }

    public static Collection<Field> listFields(Object object, boolean traverseHierarchy) {
        return ObjectsUtils.listFields(object, traverseHierarchy, NonStaticFieldFilter.instance());
    }

    public static Collection<Field> listAllFields(Object object) {
        return ObjectsUtils.listFields(object, true);
    }

    public static Field getField(Object object, String fieldName, boolean traverseHierarchy) {
        assert (object != null) : "Provided object cannot be null";
        assert (fieldName != null) : "Provided field name cannot be null";
        return ClassUtils.getField(object.getClass(), fieldName, traverseHierarchy);
    }

    public static Object getFieldValue(Object object, String fieldName) {
        return ObjectsUtils.getFieldValue(object, fieldName, true);
    }

    public static Object getFieldValue(Object object, String fieldName, boolean traverseHierarchy) {
        assert (object != null) : "Provided object cannot be null";
        assert (fieldName != null) : "Provided field name cannot be null";
        Field field = ObjectsUtils.getField(object, fieldName, traverseHierarchy);
        return ObjectsUtils.getFieldValue(object, field, traverseHierarchy);
    }

    public static Object getFieldValue(Object object, Field field) {
        return ObjectsUtils.getFieldValue(object, field, true);
    }

    public static Object getFieldValue(Object object, Field field, boolean traverseHierarchy) {
        assert (object != null) : "Provided object cannot be null";
        assert (field != null) : "Provided field cannot be null";
        try {
            if (field != null) {
                field.setAccessible(true);
                return field.get(object);
            }
            throw new UnsupportedOperationException();
        }
        catch (SecurityException Se) {
            throw new UnsupportedOperationException(Se);
        }
        catch (IllegalArgumentException IArg) {
            throw new UnsupportedOperationException(IArg);
        }
        catch (IllegalAccessException IAcc) {
            throw new UnsupportedOperationException(IAcc);
        }
    }

    public static Collection<Object> getFieldValues(final Object object, FieldFilter filter, final boolean traverseHierarchy) {
        assert (object != null) : "Provided object cannot be null";
        final FieldFilter actualFilter = filter == null ? new NonStaticFieldFilter() : filter;
        return AccessController.doPrivileged(new PrivilegedAction<Collection<Object>>(){

            @Override
            public Collection<Object> run() {
                ArrayList<Object> values = new ArrayList<Object>();
                Collection<Field> fields = ObjectsUtils.listFields(object, traverseHierarchy);
                for (Field field : fields) {
                    if (!actualFilter.include(field)) continue;
                    field.setAccessible(true);
                    try {
                        values.add(field.get(object));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return values;
            }
        });
    }

    public static Collection<Object> getFieldValues(Object object, boolean traverseHierarchy) {
        return ObjectsUtils.getFieldValues(object, null, traverseHierarchy);
    }

    public static Collection<Object> getAllFieldValues(Object object, FieldFilter filter) {
        return ObjectsUtils.getFieldValues(object, filter, true);
    }

    public static Collection<Object> getAllFieldValues(Object object) {
        return ObjectsUtils.getFieldValues(object, null, true);
    }

    public static Collection<Annotation> getAnnotations(Object object, boolean traverseHierarchy) {
        assert (object != null) : "Provided object cannot be null";
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Class<?> clazz = object.getClass().getSuperclass();
        while (traverseHierarchy && clazz != null && !clazz.equals(Object.class)) {
            annotations.addAll(Arrays.asList(clazz.getDeclaredAnnotations()));
            clazz = clazz.getSuperclass();
        }
        annotations.addAll(Arrays.asList(object.getClass().getDeclaredAnnotations()));
        return annotations;
    }

    public static Collection<Field> getAnnotatedFields(Object object, final Class<? extends Annotation> annotation, boolean traverseHierarchy) {
        AssertionUtils.$nNull(object, "Provided object cannot be NULL", new Object[0]);
        AssertionUtils.$nNull(annotation, "Provided annotation cannot be NULL", new Object[0]);
        return new NuArrayList<Field>(ObjectsUtils.listFields(object, traverseHierarchy)).select(new BasicPredicate<Field>(){

            @Override
            public boolean is(Field subject) {
                return subject.isAnnotationPresent(annotation);
            }
        });
    }

    public static Collection<Field> getAllAnnotatedFields(Object object, Class<? extends Annotation> annotation) {
        return ObjectsUtils.getAnnotatedFields(object, annotation, true);
    }

    public static Collection<Annotation> getAllAnnotations(Object object) {
        return ObjectsUtils.getAnnotations(object, true);
    }

    public static <S> S coalesce(S ... objects) {
        S[] SArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            S current = SArray[n2];
            if (current != null) {
                return current;
            }
            ++n2;
        }
        return null;
    }

    public static <S> S coalesce(Collection<S> objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        for (S current : objects) {
            if (current == null) continue;
            return current;
        }
        return null;
    }

    public static <BEAN> BEAN copyBean(BEAN toCopy) throws Throwable {
        if (toCopy == null) {
            return null;
        }
        Object copied = toCopy.getClass().newInstance();
        Collection<Field> fields = ObjectsUtils.listFields(toCopy, true, NonStaticNonFinalFieldFilter.instance());
        for (Field field : fields) {
            field.setAccessible(true);
            if (Serializable.class.isAssignableFrom(field.getType())) {
                field.set(copied, ObjectsUtils.rawClone((Serializable)field.get(toCopy)));
                continue;
            }
            field.set(copied, field.get(toCopy));
        }
        return (BEAN)copied;
    }

    public static <SOURCE, TARGET extends SOURCE> TARGET transferBean(SOURCE source, TARGET target) {
        assert (source != null) : "Source cannot be null";
        assert (target != null) : "Target cannot be null";
        Collection<Field> fields = ObjectsUtils.listFields(source, true, NonStaticNonFinalFieldFilter.instance());
        Collection<Field> targetFields = ObjectsUtils.listFields(target, true, NonStaticNonFinalFieldFilter.instance());
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                if (!targetFields.contains(field)) continue;
                if (Serializable.class.isAssignableFrom(field.getType())) {
                    field.set(target, ObjectsUtils.rawClone((Serializable)field.get(source)));
                    continue;
                }
                field.set(target, field.get(source));
            }
            catch (IllegalArgumentException IArg) {
                ObjectsUtils.getLogger(ObjectsUtils.class).warn("Unable to transfer field " + field.getName() + " from " + source + " to " + target, (Throwable)IArg);
            }
            catch (IllegalAccessException IAcc) {
                ObjectsUtils.getLogger(ObjectsUtils.class).warn("Unable to transfer field " + field.getName() + " from " + source + " to " + target, (Throwable)IAcc);
            }
        }
        return target;
    }

    static class ToStringPrivilegedAction
    implements PrivilegedAction<String> {
        private int _options;
        private Object _target;
        private Collection<Object> _alreadySerialized;
        private boolean _traverseHierarchy;
        private MultipleFieldFilter _fieldFilters;

        public ToStringPrivilegedAction(Object target) {
            this(1, target);
        }

        public ToStringPrivilegedAction(int emitOptions, Object target) {
            this(emitOptions, target, new HashSet<Object>(), true, NonStaticFieldFilter.instance());
        }

        public ToStringPrivilegedAction(Object target, boolean traverseHierarchy) {
            this(1, target, traverseHierarchy);
        }

        public ToStringPrivilegedAction(int emitOptions, Object target, boolean traverseHierarchy) {
            this(emitOptions, target, new HashSet<Object>(), traverseHierarchy, NonStaticFieldFilter.instance());
        }

        public ToStringPrivilegedAction(Object target, boolean traverseHierarchy, FieldFilter ... fieldFilters) {
            this(1, target, new HashSet<Object>(), traverseHierarchy, fieldFilters);
        }

        public ToStringPrivilegedAction(Object target, FieldFilter ... fieldFilters) {
            this(1, target, new HashSet<Object>(), true, fieldFilters);
        }

        public ToStringPrivilegedAction(int emitOptions, Object target, FieldFilter ... fieldFilters) {
            this(emitOptions, target, new HashSet<Object>(), true, fieldFilters);
        }

        public ToStringPrivilegedAction(int emitOptions, Object target, boolean traverseHierarchy, FieldFilter ... fieldFilters) {
            this(emitOptions, target, new HashSet<Object>(), traverseHierarchy, fieldFilters);
        }

        public ToStringPrivilegedAction(int options, Object target, Collection<Object> alreadySerialized, boolean traverseHierarchy, FieldFilter ... fieldFilters) {
            this._options = options;
            this._target = target;
            this._alreadySerialized = alreadySerialized == null ? new HashSet() : alreadySerialized;
            this._traverseHierarchy = traverseHierarchy;
            this._fieldFilters = new MultipleFieldFilter(fieldFilters);
        }

        public Set<String> excludedFieldNames(Object target) {
            HashSet<String> excludedFieldNames = new HashSet<String>();
            if (target != null && ClassUtils.isAnnotationPresent(target.getClass(), NonSerializedFields.class)) {
                excludedFieldNames.addAll(Arrays.asList(ClassUtils.getFirstAnnotationOfType(this._target.getClass(), NonSerializedFields.class).fieldNames()));
            }
            return excludedFieldNames;
        }

        public boolean containsReference(Collection<?> list, Object reference) {
            if (reference == null || list == null || list.isEmpty()) {
                return false;
            }
            for (Object current : list) {
                if (current != reference) continue;
                return true;
            }
            return false;
        }

        public boolean containsObjectWithHash(Collection<?> list, Object occurrency) {
            if (occurrency == null || list == null || list.isEmpty()) {
                return false;
            }
            for (Object current : list) {
                if (!current.getClass().equals(occurrency.getClass()) || System.identityHashCode(current) != System.identityHashCode(occurrency)) continue;
                return true;
            }
            return false;
        }

        public String getFieldModifiers(Field field) {
            if (field == null) {
                return "";
            }
            StringBuilder result = new StringBuilder("[");
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                result.append("s");
            }
            if (Modifier.isFinal(modifiers)) {
                result.append("f");
            }
            if (Modifier.isAbstract(modifiers)) {
                result.append("a");
            }
            if (Modifier.isPublic(modifiers)) {
                result.append("P");
            }
            if (Modifier.isProtected(modifiers)) {
                result.append("p");
            }
            if (Modifier.isPrivate(modifiers)) {
                result.append("#");
            }
            if (Modifier.isSynchronized(modifiers)) {
                result.append("$");
            }
            if (Modifier.isTransient(modifiers)) {
                result.append("t");
            }
            if (Modifier.isVolatile(modifiers)) {
                result.append("v");
            }
            if (Modifier.isNative(modifiers)) {
                result.append("n");
            }
            result.append("]");
            return result.toString();
        }

        public String hash(Field field, Object value) {
            return field == null ? this.hash(value) : String.valueOf(field.getType().getSimpleName()) + "@" + (value == null ? "NULL" : Integer.valueOf(System.identityHashCode(value)));
        }

        public String hash(Object value) {
            return value == null ? ObjectsUtils.NULL : String.valueOf(value.getClass().getSimpleName()) + "@" + System.identityHashCode(value);
        }

        public boolean must(int emitOption) {
            return (this._options & emitOption) == emitOption;
        }

        @Override
        public String run() {
            StringBuilder result = new StringBuilder();
            if (this._target == null) {
                result.append(ObjectsUtils.NULL);
            } else {
                if ((!ObjectsUtils.isPrimitive(null, this._target) || ObjectsUtils.isArray(null, this._target)) && this.must(2)) {
                    result.append(this.hash(this._target)).append(" ");
                }
                if (this.must(8)) {
                    result.append("(").append(this._target.getClass().getSimpleName()).append(")");
                }
                this._alreadySerialized.add(this._target);
                Collection<Field> fields = ObjectsUtils.listFields(this._target, this._traverseHierarchy, this._fieldFilters.getFieldFilters());
                if (ObjectsUtils.isArray(null, this._target) || ObjectsUtils.isCollection(null, this._target)) {
                    result.append("[ ");
                    if (ObjectsUtils.isArray(null, this._target)) {
                        int a = 0;
                        while (a < Array.getLength(this._target)) {
                            HashSet<Object> alreadySerialized = new HashSet<Object>(this._alreadySerialized);
                            result.append(ObjectsUtils.toString(this._options, Array.get(this._target, a), alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters())).append(", ");
                            ++a;
                        }
                    } else if (ObjectsUtils.isCollection(null, this._target)) {
                        for (Object current : (Collection)this._target) {
                            HashSet<Object> alreadySerialized = new HashSet<Object>(this._alreadySerialized);
                            result.append(ObjectsUtils.toString(this._options, current, alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters())).append(", ");
                        }
                    }
                    result.append(" ]");
                } else if (ObjectsUtils.isMap(null, this._target)) {
                    result.append("< ");
                    Map asMap = (Map)this._target;
                    for (Object key : asMap.keySet()) {
                        HashSet<Object> alreadySerialized = new HashSet<Object>(this._alreadySerialized);
                        result.append(ObjectsUtils.toString(this._options, key, alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters())).append(" -> ");
                        result.append(ObjectsUtils.toString(this._options, asMap.get(key), alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters()));
                        result.append(", ");
                    }
                    result.append(" >");
                } else if (ObjectsUtils.isPrimitive(null, this._target)) {
                    result.append(ObjectsUtils.isString(null, this._target) ? "\"" : "").append(this._target.toString()).append(ObjectsUtils.isString(null, this._target) ? "\"" : "");
                } else {
                    result.append("{ ");
                    Object fieldValue = null;
                    for (Field field : fields) {
                        try {
                            HashSet<Object> alreadySerialized;
                            field.setAccessible(true);
                            if (this.must(4)) {
                                if (this.must(16)) {
                                    result.append(this.getFieldModifiers(field)).append(" ");
                                }
                                result.append(field.getName()).append(":= ");
                            }
                            if (this.must(8)) {
                                result.append("(").append(field.getType().getSimpleName()).append(")");
                            }
                            fieldValue = field.get(this._target);
                            if (field == null || fieldValue == null) {
                                result.append(ObjectsUtils.NULL);
                            } else if (ObjectsUtils.isArray(field, fieldValue) || ObjectsUtils.isCollection(field, fieldValue)) {
                                result.append("[ ");
                                if (ObjectsUtils.isArray(field, fieldValue)) {
                                    int a = 0;
                                    while (a < Array.getLength(fieldValue)) {
                                        alreadySerialized = new HashSet<Object>(this._alreadySerialized);
                                        result.append(ObjectsUtils.toString(this._options, Array.get(fieldValue, a), alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters())).append(", ");
                                        ++a;
                                    }
                                } else if (ObjectsUtils.isCollection(field, fieldValue)) {
                                    for (Object current : (Collection)fieldValue) {
                                        alreadySerialized = new HashSet<Object>(this._alreadySerialized);
                                        result.append(ObjectsUtils.toString(this._options, current, alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters())).append(", ");
                                    }
                                }
                                result.append(" ]");
                            } else if (ObjectsUtils.isMap(field, fieldValue)) {
                                result.append("< ");
                                Map asMap = (Map)fieldValue;
                                for (Object key : asMap.keySet()) {
                                    alreadySerialized = new HashSet<Object>(this._alreadySerialized);
                                    result.append(ObjectsUtils.toString(this._options, key, alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters())).append(" -> ");
                                    result.append(ObjectsUtils.toString(this._options, asMap.get(key), alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters()));
                                    result.append(", ");
                                }
                                result.append(" >");
                            } else if (ObjectsUtils.isPrimitive(field, fieldValue)) {
                                result.append(ObjectsUtils.isString(field, fieldValue) ? "\"" : "").append(fieldValue.toString()).append(ObjectsUtils.isString(field, fieldValue) ? "\"" : "");
                            } else if (this.containsObjectWithHash(this._alreadySerialized, fieldValue)) {
                                if (this.must(2)) {
                                    result.append("*").append(this.hash(field, fieldValue));
                                } else {
                                    result.append(ObjectsUtils.ALREADY_SERIALIZED);
                                }
                            } else {
                                result.append(ObjectsUtils.toString(this._options, fieldValue, this._alreadySerialized, this._traverseHierarchy, this._fieldFilters.getFieldFilters()));
                            }
                            result.append(", ");
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    result.append(" }");
                }
            }
            return result.toString().replaceAll(",  \\}", " }").replaceAll(",  \\]", " ]").replaceAll(",  \\>", " >");
        }
    }
}

