/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.services.invokers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.fao.vrmf.core.services.AsynchronousService;
import org.fao.vrmf.core.services.invokers.AsynchronousServicesInvoker;
import org.fao.vrmf.core.services.invokers.impl.AbstractServiceInvoker;
import org.fao.vrmf.core.services.request.ServiceRequest;
import org.fao.vrmf.core.services.response.ServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractAsynchronousServiceInvoker<REQ extends ServiceRequest, RES extends ServiceResponse, SER extends AsynchronousService<REQ, RES>>
extends AbstractServiceInvoker<REQ, RES, SER>
implements AsynchronousServicesInvoker<REQ, RES, SER>,
InitializingBean {
    private static final int DEFAULT_MAX_CONCURRENT_REQUESTS = 10;
    protected final Logger _executorsLog = LoggerFactory.getLogger((String)"org.fao.vrmf.executors");
    private ExecutorService _executorService;
    private int _maxConcurrentRequests = 10;

    public void afterPropertiesSet() throws Exception {
        if (this._providers != null) {
            Collections.sort(this._providers, new Comparator<AsynchronousService<REQ, RES>>(){

                @Override
                public int compare(AsynchronousService<REQ, RES> o1, AsynchronousService<REQ, RES> o2) {
                    return new Integer(o1.getServiceTimeout()).compareTo(new Integer(o2.getServiceTimeout()));
                }
            });
        }
        this._executorService = Executors.newFixedThreadPool(this._maxConcurrentRequests * (this._providers == null || this._providers.isEmpty() ? 1 : this._providers.size()));
    }

    @Override
    public final List<SER> getServiceProviders() {
        return this._providers;
    }

    protected final CompletionService<RES> getNewCompletionService() {
        return new ExecutorCompletionService(this._executorService, new ArrayBlockingQueue(this._providers == null ? 1 : this._providers.size()));
    }

    @Override
    public final void setMaxConcurrentRequests(int maxConcurrentRequests) {
        if (maxConcurrentRequests > 0) {
            this._maxConcurrentRequests = maxConcurrentRequests;
        } else {
            this._log.warn("Invalid value for max concurrent requests ({}). Setting its default value ({}) instead...", (Object)maxConcurrentRequests, (Object)10);
            this._maxConcurrentRequests = 10;
        }
    }

    @Override
    public Collection<RES> invokeAsynchronously(REQ request) throws Throwable {
        return this.invokeAsynchronously(request, 0);
    }

    @Override
    public Collection<RES> invokeAsynchronously(REQ request, int timeout) throws Throwable {
        CompletionService<RES> completionService = this.getNewCompletionService();
        if (request == null || !request.isValid()) {
            throw new UnsupportedOperationException("Service request " + request + " is not valid");
        }
        if (this.getServiceProviders() == null) {
            throw new UnsupportedOperationException("No service provider is currently managed by " + this);
        }
        Iterator<SER> iterator = this.getServiceProviders().iterator();
        while (iterator.hasNext()) {
            AsynchronousService provider;
            final AsynchronousService $provider = provider = (AsynchronousService)iterator.next();
            completionService.submit(new Callable<RES>((ServiceRequest)request){
                private final /* synthetic */ ServiceRequest val$request;
                {
                    this.val$request = serviceRequest;
                }

                @Override
                public RES call() throws Exception {
                    return $provider.invoke(this.val$request);
                }
            });
        }
        ArrayList<ServiceResponse> allResults = new ArrayList<ServiceResponse>();
        int total = this.getServiceProviders().size();
        int timedOut = 0;
        int completed = 0;
        Future<RES> future = null;
        long start = System.currentTimeMillis();
        int cycled = 0;
        while (cycled < total) {
            long end;
            try {
                start = System.currentTimeMillis();
                if (timeout > 0) {
                    this._executorsLog.debug("Polling 'future' result with a timeout of {} mSec...", (Object)timeout);
                    future = completionService.poll(timeout, TimeUnit.MILLISECONDS);
                } else {
                    this._executorsLog.debug("Polling 'future' result ( no timeout set )...", (Object)timeout);
                    future = completionService.poll();
                }
                end = System.currentTimeMillis();
                this._executorsLog.debug("Got a 'future' result in {} mSec", (Object)(end - start));
                if (future != null) {
                    this._executorsLog.debug("Getting data from 'future' {}", future);
                    ServiceResponse futureResult = (ServiceResponse)future.get();
                    this._executorsLog.debug("Got data {} from 'future' {}", (Object)futureResult, future);
                    ++completed;
                    if (futureResult != null) {
                        allResults.add(futureResult);
                    }
                } else {
                    ++timedOut;
                    end = System.currentTimeMillis();
                    this._executorsLog.warn("A task went timeout after {} mSec", (Object)(end - start));
                }
            }
            catch (InterruptedException Ie) {
                ++timedOut;
                end = System.currentTimeMillis();
                this._executorsLog.warn("A task went timeout after {} mSec: {} [ {} ]", new Object[]{end - start, Ie.getClass().getSimpleName(), Ie.getMessage()});
            }
            ++cycled;
        }
        this._executorsLog.info("{} out of {} tasks completed successfully", (Object)completed, (Object)total);
        if (timedOut > 0) {
            this._executorsLog.warn("{} out of {} tasks went timeout", (Object)timedOut, (Object)total);
        }
        return allResults;
    }
}

