/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.services.invokers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;
import org.fao.vrmf.core.services.Service;
import org.fao.vrmf.core.services.invokers.ServicesInvoker;
import org.fao.vrmf.core.services.request.ServiceRequest;
import org.fao.vrmf.core.services.response.ServiceResponse;

public abstract class AbstractServiceInvoker<REQ extends ServiceRequest, RES extends ServiceResponse, SER extends Service<REQ, RES>>
extends ImmutableLoggingClient
implements ServicesInvoker<REQ, RES, SER> {
    protected List<SER> _providers;

    @Override
    @Inject
    public void setServiceProviders(List<SER> providers) {
        this._providers = providers;
    }

    @Override
    public Collection<RES> invoke(REQ request) throws Throwable {
        if (request == null || !request.isValid()) {
            throw new UnsupportedOperationException("Service request " + request + " is not valid");
        }
        ArrayList allResults = new ArrayList();
        for (Service provider : this._providers) {
            Object results = provider.invoke(request);
            if (results == null) continue;
            allResults.add(results);
        }
        return allResults;
    }
}

