/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.preprocess.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Rule", propOrder={"_id", "_description", "_match", "_transform"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Rule
implements Serializable {
    private static final long serialVersionUID = 3446485053381053271L;
    @XmlAttribute(name="id", required=true)
    protected String _id;
    @XmlElement(name="Match", required=true)
    protected String _match;
    @XmlElement(name="Transform", required=true)
    protected String _transform;
    @XmlElement(name="Description")
    protected String _description;
    protected static Map<String, Pattern> PATTERN_MAP = new HashMap<String, Pattern>();

    public Rule() {
    }

    public Rule(String id, String match, String transform, String description) {
        this._id = id;
        this._match = match;
        this._transform = transform;
        this._description = description;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getMatch() {
        return this._match;
    }

    public void setMatch(String match) {
        this._match = match;
    }

    public String getTransform() {
        return this._transform;
    }

    public void setTransform(String transform) {
        this._transform = transform;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    protected void checkRegexpValidity() {
        if (this._match != null) {
            Pattern.compile(this._match);
        }
    }

    protected Pattern getPattern(String regexp) {
        if (!PATTERN_MAP.containsKey(regexp)) {
            PATTERN_MAP.put(regexp, Pattern.compile(regexp));
        }
        return PATTERN_MAP.get(regexp);
    }

    public final String apply(String input) {
        if (input == null) {
            return null;
        }
        if (this._match == null || this._transform == null) {
            return input;
        }
        Pattern pattern = PATTERN_MAP.get(this._match);
        if (pattern == null) {
            pattern = Pattern.compile(this._match, 0);
            PATTERN_MAP.put(this._match, pattern);
        }
        return pattern.matcher(input).replaceAll(this._transform);
    }

    void afterUnmarshal(Unmarshaller u, Object parent) throws JAXBException {
        try {
            this.checkRegexpValidity();
        }
        catch (PatternSyntaxException PSe) {
            throw new UnmarshalException("Pattern " + this._match + " in rule @id=" + this._id + " is not well formed. " + PSe.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._description == null ? 0 : this._description.hashCode());
        result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
        result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
        result = 31 * result + (this._transform == null ? 0 : this._transform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this._description == null ? other._description != null : !this._description.equals(other._description)) {
            return false;
        }
        if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
            return false;
        }
        if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
            return false;
        }
        return !(this._transform == null ? other._transform != null : !this._transform.equals(other._transform));
    }
}

