/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species;

import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.domain.species.VernacularNamesFactory;
import org.fao.fi.comet.domain.species.model.InputSpeciesData;
import org.fao.fi.comet.domain.species.model.VernacularNameData;

public class InputSpeciesFactory {
    public static final String DEFAULT_DATA_SOURCE_ID = "UserProvidedData";

    public static final InputSpeciesData newInstance(String original) {
        return InputSpeciesFactory.newInstance(DEFAULT_DATA_SOURCE_ID, original, original);
    }

    public static final InputSpeciesData newInstance(String dataSource, String id, String original) {
        return InputSpeciesFactory.newInstance(dataSource, id, original, original, original, null, original, null);
    }

    public static final InputSpeciesData newInstance(String dataSource, String id, String original, String preparsedOriginal, String parsedScientificName, String parsedAuthority, String postParsedScientificName, String postParsedAuthority) {
        return InputSpeciesFactory.newInstance(dataSource, id, original, preparsedOriginal, parsedScientificName, parsedAuthority, postParsedScientificName, postParsedAuthority, "NIL");
    }

    public static final InputSpeciesData newInstance(String dataSource, String id, String original, String preparsedOriginal, String parsedScientificName, String parsedAuthority, String postParsedScientificName, String postParsedAuthority, String parser) {
        return InputSpeciesFactory.newInstance(dataSource, id, original, preparsedOriginal, parsedScientificName, parsedAuthority, postParsedScientificName, postParsedAuthority, null, parser);
    }

    public static final InputSpeciesData newInstance(String dataSource, String id, String original, String preparsedOriginal, String parsedScientificName, String parsedAuthority, String postParsedScientificName, String postParsedAuthority, TypedComplexName scientificCName) {
        return InputSpeciesFactory.newInstance(dataSource, id, original, preparsedOriginal, parsedScientificName, parsedAuthority, postParsedScientificName, postParsedAuthority, scientificCName, "NIL");
    }

    public static final InputSpeciesData newInstance(String dataSource, String id, String original, String preparsedOriginal, String parsedScientificName, String parsedAuthority, String postParsedScientificName, String postParsedAuthority, TypedComplexName scientificCName, String parser) {
        InputSpeciesData data = new InputSpeciesData();
        data.setDataSource(dataSource);
        data.setId(id);
        data.setOriginal(original);
        data.setPreparsedOriginal(preparsedOriginal);
        data.setParsedScientificName(parsedScientificName);
        data.setParsedAuthority(parsedAuthority);
        data.setPostParsedScientificName(postParsedScientificName);
        data.setPostParsedAuthority(postParsedAuthority);
        data.setScientificName(postParsedScientificName);
        data.setAuthor(postParsedAuthority);
        data.setScientificCName(scientificCName);
        data.setVernacularNames(new VernacularNameData[]{VernacularNamesFactory.newInstance(id, "UNKNOWN", null, original)});
        if (scientificCName != null) {
            data.setVernacularCNames(new LinkedTypedComplexName[]{new LinkedTypedComplexName(id, "vernacular_UNKNOWN", scientificCName.getName(), scientificCName.getSimplifiedName(), scientificCName.getSimplifiedNameNGrams(), scientificCName.getSimplifiedNameSoundex())});
        }
        data.setParser(parser);
        return data;
    }
}

