/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.output.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessResult;
import org.fao.fi.comet.domain.species.model.InputSpeciesData;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.vrmf.core.helpers.singletons.text.xml.JAXBUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.XMLBuilderUtils;

public class XMLOutputTransformer {
    public static final String IDENTITY_TEMPLATE = "identity";
    public static final String STRIPPED_TEMPLATE = "stripped";
    public static final String SIMPLE_TEMPLATE = "simple";
    public static final String CSV_TEMPLATE = "csv";
    public static final String CSV_NO_HEADER_TEMPLATE = "csvNoHeader";
    public static final String[] AVAILABLE_TEMPLATES = new String[]{"stripped", "simple", "csv", "csvNoHeader"};
    public static final Set<String> AVAILABLE_TEMPLATES_SET = new HashSet<String>(Arrays.asList(AVAILABLE_TEMPLATES));

    public static final boolean hasAValidTemplate(String format) {
        return AVAILABLE_TEMPLATES_SET.contains(format);
    }

    public void applyEmbeddedTemplate(MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> toTransform, String format, PrintStream printStream) throws JAXBException, TransformerConfigurationException, TransformerException, IOException {
        InputStream transformationStream = null;
        try {
            transformationStream = this.getClass().getResourceAsStream("resources/xslt/" + format + ".xslt");
            this.transform(toTransform, transformationStream, printStream);
        }
        finally {
            if (transformationStream != null) {
                try {
                    transformationStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void applyExternalTemplate(MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> toTransform, String xsltFile, PrintStream printStream) throws JAXBException, TransformerConfigurationException, TransformerException, IOException {
        FileInputStream transformationStream = null;
        try {
            transformationStream = new FileInputStream(xsltFile);
            this.transform(toTransform, transformationStream, printStream);
        }
        finally {
            if (transformationStream != null) {
                try {
                    ((InputStream)transformationStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void transform(MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> toTransform, InputStream transformationStream, PrintStream printStream) throws JAXBException, TransformerConfigurationException, TransformerException, IOException {
        String output = JAXBUtils.toXML(new Class[]{InputSpeciesData.class, ReferenceSpeciesData.class, TypedComplexName.class}, toTransform);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(transformationStream));
        ByteArrayInputStream bais = new ByteArrayInputStream(output.getBytes("UTF-8"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamSource xml = new StreamSource(bais);
        StreamResult xmlt = new StreamResult(baos);
        transformer.transform(xml, xmlt);
        baos.flush();
        baos.close();
        output = new String(baos.toByteArray(), "UTF-8");
        boolean isXML = output.startsWith("<?xml");
        printStream.print(isXML ? XMLBuilderUtils.prettyPrint(output) : output);
    }
}

