/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.support;

import javax.xml.bind.annotation.XmlType;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.tools.topology.behaviours.WeightValue;

@XmlType(name="UnmodifiableMatchingScore")
public final class UnmodifiableMatchingScore
extends MatchingScore {
    private static final long serialVersionUID = -6821192099216353523L;

    public UnmodifiableMatchingScore() {
        this._value = 0.0;
        this._matchingType = null;
    }

    public UnmodifiableMatchingScore(MatchingScore wrapped) {
        AssertionUtils.$nNull(wrapped, "Provided score cannot be null", new Object[0]);
        AssertionUtils.$gte(wrapped._value, 0.0, "Score value {} cannot be lower than the minimum allowed ({})", wrapped._value, 0.0);
        AssertionUtils.$lte(wrapped._value, 1.0, "Score value {} cannot be higher than the maximum allowed ({})", wrapped._value, 1.0);
        AssertionUtils.$nNull(wrapped._matchingType, "Provided matching type cannot be null", new Object[0]);
        this._value = wrapped._value;
        this._matchingType = wrapped._matchingType;
    }

    public UnmodifiableMatchingScore(double value, MatchingType matchingType) {
        AssertionUtils.$gte(value, 0.0, "Score value {} cannot be lower than the minimum allowed ({})", value, 0.0);
        AssertionUtils.$lte(value, 1.0, "Score value {} cannot be higher than the maximum allowed ({})", value, 1.0);
        AssertionUtils.$nNull(matchingType, "Provided matching type cannot be null", new Object[0]);
        this._value = value;
        this._matchingType = matchingType;
    }

    @Override
    public void setValue(double value) {
        boolean currentlyNotSet;
        boolean bl = currentlyNotSet = Double.compare(0.0, this._value) == 0;
        if (!currentlyNotSet) {
            AssertionUtils.$eq(value, this._value, "You cannot change this' matching score value", new Object[0]);
        }
    }

    @Override
    public void setMatchingType(MatchingType matchingType) {
        if (this._matchingType != null) {
            AssertionUtils.$eq(matchingType, this._matchingType, "You cannot change this' matching type", new Object[0]);
        }
    }

    @Override
    public MatchingScore multiply(WeightValue another) {
        return AssertionUtils.$_failRet(MatchingScore.class, "You cannot multiply this matching score with another", new Object[0]);
    }

    @Override
    public void increaseValue(double valueDelta) {
        AssertionUtils.$_fail("You cannot increase this matching score's value", new Object[0]);
    }
}

