/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended;

import org.fao.fi.comet.core.exceptions.MatchletConfigurationException;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletDefaultSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletParameter;
import org.fao.fi.comet.core.model.matchlets.annotations.parameters.DoubleRange;
import org.fao.fi.comet.core.model.matchlets.support.MatchingSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.uniform.matchlets.skeleton.UVectorialMatchletSkeleton;
import org.fao.fi.comet.domain.species.matchlets.extended.support.CNamesScoreCalculator;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

@MatchletDefaultSerializationExclusionPolicy(value={MatchingSerializationExclusionPolicy.NON_PERFORMED})
public abstract class AbstractCNameVectorialMatchlet
extends UVectorialMatchletSkeleton<ReferenceSpeciesData, TypedComplexName> {
    private static final long serialVersionUID = 1653730901184509134L;
    public static final String LEVENSHTEIN_WEIGHT_PARAM = "levenshteinWeight";
    public static final String SOUNDEX_WEIGHT_PARAM = "soundexWeight";
    public static final String TRIGRAM_WEIGHT_PARAM = "trigramWeight";
    private static final double MIN_WEIGHT = 0.0;
    private static final double MAX_WEIGHT = 100.0;
    @MatchletParameter(name="levenshteinWeight", description="Sets the weight of the levenshtein distance contribution in the computation of the final matching score.")
    @DoubleRange(from=0.0, to=100.0, includeFrom=true, includeTo=true)
    protected double _levenshteinWeight;
    @MatchletParameter(name="soundexWeight", description="Sets the weight of the soundex contribution in the computation of the final matching score.")
    @DoubleRange(from=0.0, to=100.0, includeFrom=true, includeTo=true)
    protected double _soundexWeight;
    @MatchletParameter(name="trigramWeight", description="Sets the weight of the trigram contribution in the computation of the final matching score.")
    @DoubleRange(from=0.0, to=100.0, includeFrom=true, includeTo=true)
    protected double _trigramWeight;
    private final CNamesScoreCalculator _scoreCalculator;

    public AbstractCNameVectorialMatchlet() {
        this(70.0, 30.0, 0.0);
    }

    public AbstractCNameVectorialMatchlet(double levenshteinWeight, double soundexWeight, double trigramWeight) {
        AssertionUtils.$gte(levenshteinWeight, 0.0, "Levenshtein weight ({}) must be greater than or equal to {}", levenshteinWeight, 0.0);
        AssertionUtils.$lte(levenshteinWeight, 100.0, "Levenshtein weight ({}) must be lower than or equal to {}", levenshteinWeight, 100.0);
        AssertionUtils.$gte(soundexWeight, 0.0, "Soundex weight ({}) must be greater than or equal to {}", soundexWeight, 0.0);
        AssertionUtils.$lte(soundexWeight, 100.0, "Soundex weight ({}) must be lower than or equal to {}", soundexWeight, 100.0);
        AssertionUtils.$gte(trigramWeight, 0.0, "Trigram weight ({}) must be greater than or equal to {}", trigramWeight, 0.0);
        AssertionUtils.$lte(trigramWeight, 100.0, "Trigram weight ({}) must be lower than or equal to {}", trigramWeight, 100.0);
        this._soundexWeight = soundexWeight;
        this._levenshteinWeight = levenshteinWeight;
        this._trigramWeight = trigramWeight;
        this._scoreCalculator = new CNamesScoreCalculator();
    }

    @Override
    protected void doValidateConfiguration() throws MatchletConfigurationException {
        super.doValidateConfiguration();
        AssertionUtils.$gte(this._levenshteinWeight, 0.0, "{} Levenshtein weight must be greater than (or equal to) {} (currently: {})", this.getClass().getSimpleName(), 0.0, this._levenshteinWeight);
        AssertionUtils.$lte(this._levenshteinWeight, 100.0, "{} Levenshtein weight must be lower than (or equal to) {} (currently: {})", this.getClass().getSimpleName(), 100.0, this._levenshteinWeight);
        AssertionUtils.$gte(this._soundexWeight, 0.0, "{} soundex weight must be greater than (or equal to) {} (currently: {})", this.getClass().getSimpleName(), 0.0, this._soundexWeight);
        AssertionUtils.$lte(this._soundexWeight, 100.0, "{} soundex weight must be lower than (or equal to) {} (currently: {})", this.getClass().getSimpleName(), 100.0, this._soundexWeight);
        AssertionUtils.$gte(this._trigramWeight, 0.0, "{} trigram weight must be greater than (or equal to) {} (currently: {})", this.getClass().getSimpleName(), 0.0, this._trigramWeight);
        AssertionUtils.$lte(this._trigramWeight, 100.0, "{} trigram weight must be lower than (or equal to) {} (currently: {})", this.getClass().getSimpleName(), 100.0, this._trigramWeight);
    }

    public double getLevenshteinWeight() {
        return this._levenshteinWeight;
    }

    public void setLevenshteinWeight(double levenshteinWeight) {
        this._levenshteinWeight = levenshteinWeight;
    }

    public double getSoundexWeight() {
        return this._soundexWeight;
    }

    public void setSoundexWeight(double soundexWeight) {
        this._soundexWeight = soundexWeight;
    }

    public double getTrigramWeight() {
        return this._trigramWeight;
    }

    public void setTrigramWeight(double trigramWeight) {
        this._trigramWeight = trigramWeight;
    }

    @Override
    public MatchingScore computeScore(ReferenceSpeciesData source, DataIdentifier sourceIdentifier, TypedComplexName sourceData, ReferenceSpeciesData target, DataIdentifier targetIdentifier, TypedComplexName targetData) {
        boolean hasTargetData;
        boolean hasSourceData = sourceData != null && sourceData.getName() != null;
        boolean bl = hasTargetData = targetData != null && targetData.getName() != null;
        if (!hasSourceData || !hasTargetData) {
            if (this._isOptional) {
                return MatchingScore.getNonPerformedTemplate();
            }
            return MatchingScore.getNonAuthoritativeNoMatchTemplate();
        }
        return this._scoreCalculator.computeScore(this._levenshteinWeight, this._soundexWeight, this._trigramWeight, source, sourceIdentifier, sourceData, target, targetIdentifier, targetData);
    }
}

