/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.text.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;

public final class DateFormatterUtils
extends AbstractHelperSingleton {
    private static final String SIMPLE_DATE_FORMATTER_PATTERN = "yyyy/MM/dd";
    private static final String DATE_AND_TIME_FORMATTER_PATTERN = "yyyy/MM/dd HH:mm:ss, z";

    public static final synchronized String formatDate() {
        return DateFormatterUtils.formatDate(null);
    }

    public static final synchronized String formatDate(Date toFormat) {
        return new SimpleDateFormat(SIMPLE_DATE_FORMATTER_PATTERN).format(toFormat == null ? new Date() : toFormat);
    }

    public static final synchronized String formatDateAndTime() {
        return DateFormatterUtils.formatDateAndTime(null);
    }

    public static final synchronized String formatDateAndTime(Date toFormat) {
        return new SimpleDateFormat(DATE_AND_TIME_FORMATTER_PATTERN).format(toFormat == null ? new Date() : toFormat);
    }

    public static final String formatDateWithPattern(Date toFormat, String pattern) {
        return new SimpleDateFormat(pattern).format(toFormat == null ? new Date() : toFormat);
    }

    public static final String formatDateWithPattern(String pattern) {
        return DateFormatterUtils.formatDateWithPattern(null, pattern);
    }
}

