/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.patterns.handlers.id.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fao.fi.comet.core.patterns.handlers.id.IDHandler;

public abstract class IDHandlerSkeleton<DATA, IDENTIFIER extends Serializable>
implements IDHandler<DATA, IDENTIFIER> {
    private final Map<DATA, IDENTIFIER> _idCache = Collections.synchronizedMap(new HashMap());

    @Override
    public final IDENTIFIER getId(DATA data) {
        if (data == null) {
            return null;
        }
        Serializable cachedId = (Serializable)this._idCache.get(data);
        if (cachedId == null) {
            this._idCache.put(data, this.doGetId(data));
        }
        return (IDENTIFIER)((Serializable)this._idCache.get(data));
    }

    @Override
    public final String serializeId(IDENTIFIER id) {
        if (id == null) {
            return null;
        }
        return this.sanitize(this.doSerializeId(id));
    }

    @Override
    public String getSerializedId(DATA data) {
        return this.serializeId(this.getId(data));
    }

    protected abstract IDENTIFIER doGetId(DATA var1);

    protected String doSerializeId(IDENTIFIER id) {
        return id.toString();
    }

    protected String sanitize(String id) {
        return id.replaceAll("\"", "&quot;");
    }
}

