/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended;

import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.fi.comet.core.uniform.matchlets.skeleton.UScalarMatchletSkeleton;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public class FuzzyTaxamatchMatchlet
extends UScalarMatchletSkeleton<ReferenceSpeciesData, ReferenceSpeciesData> {
    private static final long serialVersionUID = -5646686342308645734L;
    public static final String NAME = "FuzzyTaxamatchMatchlet";

    public FuzzyTaxamatchMatchlet() {
        this._name = NAME;
    }

    @Override
    public String getDescription() {
        return "Performs a fuzzy Taxamatch-like matching between two species";
    }

    @Override
    protected ReferenceSpeciesData doExtractData(ReferenceSpeciesData entity, DataIdentifier dataIdentifier) {
        return entity;
    }

    @Override
    public MatchingScore computeScore(ReferenceSpeciesData source, DataIdentifier sourceIdentifier, ReferenceSpeciesData sourceData, ReferenceSpeciesData target, DataIdentifier targetIdentifier, ReferenceSpeciesData targetData) {
        boolean bothHaveSpecies;
        TypedComplexName sourceNormalizedGenusCName = source.getNormalizedGenusCName();
        TypedComplexName targetNormalizedGenusCName = target.getNormalizedGenusCName();
        TypedComplexName sourceNormalizedSpeciesCName = source.getNormalizedSpeciesCName();
        TypedComplexName targetNormalizedSpeciesCName = target.getNormalizedSpeciesCName();
        boolean noneHasGenus = !(sourceNormalizedGenusCName != null && !sourceNormalizedGenusCName.isEmpty() || targetNormalizedGenusCName != null && !targetNormalizedGenusCName.isEmpty());
        boolean bothHaveGenus = sourceNormalizedGenusCName != null && !sourceNormalizedGenusCName.isEmpty() && targetNormalizedGenusCName != null && !targetNormalizedGenusCName.isEmpty();
        boolean noneHasSpecies = !(sourceNormalizedSpeciesCName != null && !sourceNormalizedSpeciesCName.isEmpty() || targetNormalizedSpeciesCName != null && !targetNormalizedSpeciesCName.isEmpty());
        boolean bl = bothHaveSpecies = sourceNormalizedSpeciesCName != null && !sourceNormalizedSpeciesCName.isEmpty() && targetNormalizedSpeciesCName != null && !targetNormalizedSpeciesCName.isEmpty();
        if (noneHasGenus && noneHasSpecies) {
            return MatchingScore.getNonPerformedTemplate();
        }
        double speciesPhoneticScore = 0.0;
        double genusPhoneticScore = 0.0;
        double speciesRelativeSimilarityScore = 0.0;
        double genusRelativeSimilarityScore = 0.0;
        double speciesDistanceScore = 0.0;
        double genusDistanceScore = 0.0;
        double speciesScore = 0.0;
        double genusScore = 0.0;
        if (bothHaveGenus) {
            genusPhoneticScore = this.soundexSimilarity(sourceNormalizedGenusCName.getSimplifiedNameSoundex(), targetNormalizedGenusCName.getSimplifiedNameSoundex());
            genusDistanceScore = this.distance(sourceNormalizedGenusCName.getSimplifiedName(), targetNormalizedGenusCName.getSimplifiedName());
            genusRelativeSimilarityScore = this.relativeSimilarity(sourceNormalizedGenusCName.getSimplifiedName(), targetNormalizedGenusCName.getSimplifiedName());
            genusScore = this.overallScore(genusPhoneticScore, genusDistanceScore, genusRelativeSimilarityScore);
        }
        if (bothHaveSpecies) {
            speciesPhoneticScore = this.soundexSimilarity(sourceNormalizedSpeciesCName.getSimplifiedNameSoundex(), targetNormalizedSpeciesCName.getSimplifiedNameSoundex());
            speciesDistanceScore = this.distance(sourceNormalizedSpeciesCName.getSimplifiedName(), targetNormalizedSpeciesCName.getSimplifiedName());
            speciesRelativeSimilarityScore = this.relativeSimilarity(sourceNormalizedSpeciesCName.getSimplifiedName(), targetNormalizedSpeciesCName.getSimplifiedName());
            speciesScore = this.overallScore(speciesPhoneticScore, speciesDistanceScore, speciesRelativeSimilarityScore);
        }
        if (bothHaveGenus && bothHaveSpecies) {
            return new MatchingScore((genusScore + speciesScore) / 2.0, MatchingType.NON_AUTHORITATIVE);
        }
        double score = this.overallScore(Math.max(genusPhoneticScore, speciesPhoneticScore), Math.min(genusDistanceScore, speciesDistanceScore), Math.max(genusRelativeSimilarityScore, speciesRelativeSimilarityScore));
        return new MatchingScore(score, MatchingType.NON_AUTHORITATIVE);
    }

    private double overallScore(double phoneticScore, double distanceScore, double similarityScore) {
        double score = (phoneticScore + distanceScore + similarityScore) / 3.0;
        return score;
    }

    private double distance(String source, String target) {
        int distance = StringUtils.computeDistance(StringUtils.rawTrim(source), StringUtils.rawTrim(target));
        return distance > 4 ? 0.0 : 1.0 - (double)distance / 5.0;
    }

    private double relativeSimilarity(String source, String target) {
        return StringUtils.computeRelativeSimilarity(StringUtils.rawTrim(source), StringUtils.rawTrim(target));
    }

    private double soundexSimilarity(String source, String target) {
        int max;
        int targetSoundexInt;
        int sourceSoundexInt;
        int min;
        char targetSoundexStart;
        if (source == null || target == null) {
            return 0.0;
        }
        if (source.equals(target)) {
            return 1.0;
        }
        double score = 0.0;
        char sourceSoundexStart = source.charAt(0);
        if (sourceSoundexStart == (targetSoundexStart = target.charAt(0))) {
            score = 0.4;
        }
        score = (min = Math.min(sourceSoundexInt = Integer.valueOf(source.substring(1)).intValue(), targetSoundexInt = Integer.valueOf(target.substring(1)).intValue())) == (max = Math.max(sourceSoundexInt, targetSoundexInt)) ? (score += 0.6) : (score += 0.6 * (double)min / (double)max);
        return score;
    }
}

