/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.soundex.impl;

import java.util.ArrayList;
import javax.inject.Named;
import org.fao.vrmf.core.tools.lexical.soundex.SoundexConstants;
import org.fao.vrmf.core.tools.lexical.soundex.SoundexGenerator;

@Named
public class BasicSoundexGenerator
implements SoundexGenerator {
    private static final long serialVersionUID = 6244056044888575218L;
    private int _minimumLength = 4;
    private int _maximumLength = 4;

    public BasicSoundexGenerator() {
        this(4);
    }

    public BasicSoundexGenerator(int minimumLength) {
        assert (minimumLength > 0) : "Minimum length cannot be lower than or equal to zero";
        this._minimumLength = minimumLength;
    }

    public BasicSoundexGenerator(int minimumLength, int maximumLength) {
        assert (minimumLength > 0) : "Minimum length cannot be lower than or equal to zero";
        assert (maximumLength > 0) : "Maximum length cannot be lower than or equal to zero";
        assert (minimumLength <= maximumLength) : "Maximum length cannot be lower than the minimum length";
        this._minimumLength = minimumLength;
        this._maximumLength = maximumLength;
    }

    protected final boolean isVowel(Character character) {
        return "AEIOUYHW".contains(character.toString().toUpperCase());
    }

    @Override
    public String computeSoundex(String part) {
        part = part.toUpperCase();
        Character firstLetter = Character.valueOf(part.charAt(0));
        String lastLetters = part.substring(1);
        lastLetters = SoundexConstants.VOWELS_PATTERN.matcher(lastLetters).replaceAll("");
        String cleaned = firstLetter + lastLetters;
        SoundexQueue converted = new SoundexQueue();
        int c = 0;
        while (c < cleaned.toCharArray().length) {
            if (c > 0 || !this.isVowel(firstLetter)) {
                converted.add(this.convertLetter(cleaned.charAt(c)));
            }
            ++c;
        }
        if (converted.size() >= 1 && !this.isVowel(firstLetter)) {
            converted.remove(0);
        }
        StringBuffer result = new StringBuffer();
        result.append(firstLetter);
        for (Integer c2 : converted) {
            result.append(c2);
        }
        if (result.length() > this._maximumLength) {
            result.delete(this._maximumLength, result.length());
        }
        while (result.length() < this._minimumLength) {
            result.append("0");
        }
        return result.toString().trim();
    }

    private final int convertLetter(char letter) {
        switch (Character.toLowerCase(letter)) {
            case 'b': 
            case 'f': 
            case 'p': 
            case 'v': {
                return 1;
            }
            case 'c': 
            case 'g': 
            case 'j': 
            case 'k': 
            case 'q': 
            case 's': 
            case 'x': 
            case 'z': {
                return 2;
            }
            case 'd': 
            case 't': {
                return 3;
            }
            case 'l': {
                return 4;
            }
            case 'm': 
            case 'n': {
                return 5;
            }
            case 'r': {
                return 6;
            }
            case 'h': 
            case 'w': {
                return 0;
            }
        }
        throw new RuntimeException("Invalid character '" + letter + "' provided");
    }

    private static class SoundexQueue
    extends ArrayList<Integer> {
        private static final long serialVersionUID = -3027326107406870582L;

        @Override
        public boolean add(Integer e) {
            if (e == 0) {
                return false;
            }
            if (this.size() > 0 && ((Integer)this.get(this.size() - 1)).equals(e)) {
                return false;
            }
            return super.add(e);
        }
    }
}

