/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.extensions.collections.nu.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.fao.vrmf.core.behaviours.design.patterns.predicate.Action;
import org.fao.vrmf.core.behaviours.design.patterns.predicate.Predicate;
import org.fao.vrmf.core.extensions.collections.nu.NuList;
import org.fao.vrmf.core.impl.design.patterns.predicate.AlwaysTruePredicate;

public class NuArrayList<ENTRY>
extends ArrayList<ENTRY>
implements NuList<ENTRY> {
    private static final long serialVersionUID = 836982161123383893L;

    public NuArrayList() {
    }

    public NuArrayList(ENTRY[] items) {
        this((Collection<ENTRY>)Arrays.asList(items));
    }

    public NuArrayList(Collection<ENTRY> items) {
        this();
        this.addAll(items);
    }

    @Override
    public boolean add(ENTRY e) {
        return super.add(e);
    }

    @Override
    public void add(int index, ENTRY element) {
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends ENTRY> c) {
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ENTRY> c) {
        return super.addAll(index, c);
    }

    @Override
    public final ENTRY first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (ENTRY)this.get(0);
    }

    @Override
    public final ENTRY last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (ENTRY)this.get(this.size() - 1);
    }

    @Override
    public final NuList<ENTRY> select(Predicate<ENTRY> predicate) {
        assert (predicate != null) : "Predicate cannot be NULL";
        NuArrayList selected = new NuArrayList();
        for (Object current : this) {
            if (!predicate.is(current)) continue;
            selected.add((ENTRY)current);
        }
        return selected;
    }

    @Override
    public NuList<ENTRY> selectOthers(Predicate<ENTRY> predicate) {
        assert (predicate != null) : "Predicate cannot be NULL";
        NuArrayList selected = new NuArrayList();
        for (Object current : this) {
            if (!predicate.isNot(current)) continue;
            selected.add((ENTRY)current);
        }
        return selected;
    }

    @Override
    public final void forEachDo(Action<ENTRY> action) {
        assert (action != null) : "Action cannot be NULL";
        this.forEachSelectedDo(new AlwaysTruePredicate(), action);
    }

    @Override
    public final void forEachSelectedDo(Predicate<ENTRY> predicate, Action<ENTRY> action) {
        assert (predicate != null) : "Predicate cannot be NULL";
        assert (action != null) : "Action cannot be NULL";
        for (Object current : this) {
            if (!predicate.is(current)) continue;
            action.perform(current);
        }
    }

    @Override
    public final void forEachOtherDo(Predicate<ENTRY> predicate, Action<ENTRY> action) {
        assert (predicate != null) : "Predicate cannot be NULL";
        assert (action != null) : "Action cannot be NULL";
        for (Object current : this) {
            if (!predicate.isNot(current)) continue;
            action.perform(current);
        }
    }

    @Override
    public final NuArrayList<ENTRY> reverse() {
        NuArrayList reversed = new NuArrayList();
        for (Object current : this) {
            reversed.add(0, (ENTRY)current);
        }
        return reversed;
    }
}

