/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import java.net.InetAddress;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessStatus;
import org.fao.vrmf.core.helpers.singletons.io.EncryptionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;

@XmlType(name="MatchingEngineProcessorInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MatchingEngineProcessorInfo<CONFIG extends MatchingEngineProcessConfiguration>
implements Serializable {
    private static final long serialVersionUID = -3406956100846096504L;
    @XmlAttribute(name="processID")
    private String _processID;
    @XmlAttribute(name="processExecutorIP")
    private String _processExecutorIP;
    @XmlAttribute(name="processExecutorName")
    private String _processExecutorName;
    @XmlAttribute(name="processExecutorThreadName")
    private String _processExecutorThreadName;
    @XmlElement(name="Configuration")
    private CONFIG _configuration;
    @XmlElement(name="Status")
    private MatchingEngineProcessStatus _status;

    public MatchingEngineProcessorInfo() {
    }

    public MatchingEngineProcessorInfo(CONFIG configuration, MatchingEngineProcessStatus status) {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            this._processExecutorIP = localhost.getHostAddress();
            this._processExecutorName = localhost.getCanonicalHostName();
        }
        catch (Throwable t) {
            this._processExecutorIP = "127.0.0.1";
            this._processExecutorName = "localhost";
        }
        this._processExecutorThreadName = Thread.currentThread().getName();
        this._processID = String.valueOf(System.currentTimeMillis()) + ":" + this._processExecutorIP + ":" + this._processExecutorName + ":" + this._processExecutorThreadName;
        try {
            this._processID = EncryptionUtils.getMD5Sum(this._processID);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._status = status;
        this._configuration = configuration;
    }

    public String getProcessID() {
        return this._processID;
    }

    public String getProcessExecutorIP() {
        return this._processExecutorIP;
    }

    public String getProcessExecutorName() {
        return this._processExecutorName;
    }

    public String getProcessExecutorThreadName() {
        return this._processExecutorThreadName;
    }

    public MatchingEngineProcessStatus getStatus() {
        return this._status;
    }

    public void setStatus(MatchingEngineProcessStatus status) {
        this._status = status;
    }

    public CONFIG getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(CONFIG configuration) {
        AssertionUtils.$nNull(configuration, "Please provide a non-null reference to the originating matching configuration", new Object[0]);
        this._configuration = (MatchingEngineProcessConfiguration)ObjectsUtils.rawClone(configuration);
    }
}

